/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.FilterConfigImpl;
import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.ServletConfigImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.util.LoggerUtils;
import java.io.IOException;
import java.util.EventListener;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;

public final class FilterChainImpl
implements FilterChain {
    public static final int INCREMENT = 8;
    private FilterConfigImpl[] filters = new FilterConfigImpl[8];
    private static final Object[] lock = new Object[0];
    private int n = 0;
    private Servlet servlet = null;
    private ServletConfigImpl configImpl;

    protected void init() throws ServletException {
        for (FilterConfigImpl f : this.filters) {
            if (f == null) continue;
            f.getFilter().init((FilterConfig)f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ServletRequestEvent event = new ServletRequestEvent(this.configImpl.getServletContext(), request);
        try {
            for (EventListener l : ((ServletContextImpl)this.configImpl.getServletContext()).getListeners()) {
                try {
                    if (!(l instanceof ServletRequestListener)) continue;
                    ((ServletRequestListener)l).requestInitialized(event);
                }
                catch (Throwable t) {
                    LoggerUtils.getLogger().log(Level.WARNING, "", t);
                }
            }
            this.setPos(request, 0);
            this.doFilter(request, response);
        }
        finally {
            for (EventListener l : ((ServletContextImpl)this.configImpl.getServletContext()).getListeners()) {
                try {
                    if (!(l instanceof ServletRequestListener)) continue;
                    ((ServletRequestListener)l).requestDestroyed(event);
                }
                catch (Throwable t) {
                    LoggerUtils.getLogger().log(Level.WARNING, "", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        int pos = this.getPos(request);
        if (pos < this.n) {
            FilterConfigImpl filterConfig = null;
            Object[] objectArray = lock;
            synchronized (lock) {
                filterConfig = this.filters[pos++];
                this.setPos(request, pos);
                // ** MonitorExit[var5_9] (shouldn't be in output)
                Filter filter = null;
                try {
                    filter = filterConfig.getFilter();
                    filter.doFilter(request, response, (FilterChain)this);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ServletException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ServletException("Throwable", e);
                }
                return;
            }
        }
        try {
            if (this.servlet != null) {
                this.servlet.service(request, response);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException("Throwable", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFilter(FilterConfigImpl filterConfig) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.n == this.filters.length) {
                FilterConfigImpl[] newFilters = new FilterConfigImpl[this.n + 8];
                System.arraycopy(this.filters, 0, newFilters, 0, this.n);
                this.filters = newFilters;
            }
            this.filters[this.n++] = filterConfig;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected int getPos(ServletRequest request) {
        return ((HttpServletRequestImpl)request).getFilterChainPos();
    }

    protected void setPos(ServletRequest request, int pos) {
        ((HttpServletRequestImpl)request).setFilterChainPos(pos);
    }

    protected void setServlet(ServletConfigImpl configImpl, Servlet servlet) {
        this.configImpl = configImpl;
        this.servlet = servlet;
    }

    protected FilterConfigImpl getFilter(int i) {
        return this.filters[i];
    }

    protected Servlet getServlet() {
        return this.servlet;
    }

    protected ServletConfigImpl getServletConfig() {
        return this.configImpl;
    }

    public void destroy() {
        for (FilterConfigImpl filter : this.filters) {
            if (filter == null) continue;
            filter.recycle();
        }
        if (this.servlet != null) {
            this.servlet.destroy();
            this.servlet = null;
        }
        this.filters = null;
    }
}

