/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.LocalServerCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.InstanceDirs;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public abstract class LocalInstanceCommand
extends LocalServerCommand {
    @Param(name="nodeagent", optional=true)
    protected String nodeAgent;
    @Param(name="nodehome", optional=true)
    protected String agentDir;
    @Param(name="node", optional=true)
    protected String node;
    protected String instanceName;
    protected File agentsDir;
    protected File nodeAgentDir;
    protected File instanceDir;
    private InstanceDirs instanceDirs;
    private static final LocalStringsImpl strings = new LocalStringsImpl(LocalInstanceCommand.class);

    protected void validate() throws CommandException, CommandValidationException {
        this.initInstance();
    }

    protected boolean mkdirs(File f) {
        return f.mkdirs();
    }

    protected void initInstance() throws CommandException {
        String agentsDirPath = null;
        agentsDirPath = LocalInstanceCommand.ok((String)this.agentDir) ? this.agentDir : this.getAgentsDirPath();
        this.agentsDir = new File(agentsDirPath);
        this.mkdirs(this.agentsDir);
        if (!this.agentsDir.isDirectory()) {
            throw new CommandException(strings.get("Instance.badAgentDir", new Object[]{this.agentsDir}));
        }
        if (this.nodeAgent != null) {
            this.nodeAgentDir = new File(this.agentsDir, this.nodeAgent);
        } else {
            this.nodeAgentDir = this.getTheOneAndOnlyAgent(this.agentsDir);
            this.nodeAgent = this.nodeAgentDir.getName();
        }
        if (this.instanceName != null) {
            this.instanceDir = new File(this.nodeAgentDir, this.instanceName);
            this.mkdirs(this.instanceDir);
        } else {
            this.instanceDir = this.getTheOneAndOnlyInstance(this.nodeAgentDir);
            this.instanceName = this.instanceDir.getName();
        }
        if (!this.instanceDir.isDirectory()) {
            throw new CommandException(strings.get("Instance.badInstanceDir", new Object[]{this.instanceDir}));
        }
        this.nodeAgentDir = SmartFile.sanitize((File)this.nodeAgentDir);
        this.instanceDir = SmartFile.sanitize((File)this.instanceDir);
        try {
            this.instanceDirs = new InstanceDirs(this.instanceDir);
            this.setServerDirs(this.instanceDirs.getServerDirs());
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        logger.printDebugMessage("nodeAgentDir: " + this.nodeAgentDir);
        logger.printDebugMessage("instanceDir: " + this.instanceDir);
    }

    protected final InstanceDirs getInstanceDirs() {
        return this.instanceDirs;
    }

    protected final void setDasDefaults(File propfile) throws CommandException {
        Properties dasprops = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propfile);
            dasprops.load(fis);
            fis.close();
            fis = null;
            String p = dasprops.getProperty("agent.das.host");
            if (p != null) {
                this.programOpts.setHost(p);
            }
            p = dasprops.getProperty("agent.das.port");
            int port = -1;
            if (p != null) {
                port = Integer.parseInt(p);
            }
            if ((p = dasprops.getProperty("agent.das.protocol")) != null && p.equals("rmi_jrmp")) {
                this.programOpts.setPort(this.updateDasPort(dasprops, port, propfile));
            } else if (p == null || p.equals("http")) {
                this.programOpts.setPort(port);
            } else {
                throw new CommandException(strings.get("Instance.badProtocol", new Object[]{propfile.toString(), p}));
            }
            p = dasprops.getProperty("agent.das.isSecure");
            if (p != null) {
                this.programOpts.setSecure(Boolean.parseBoolean(p));
            }
            if ((p = dasprops.getProperty("agent.das.user")) != null) {
                this.programOpts.setUser(p);
            }
        }
        catch (IOException ioex) {
            throw new CommandException(strings.get("Instance.cantReadDasProperties", new Object[]{propfile.getPath()}));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException cex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateDasPort(Properties dasprops, int port, File propfile) {
        if (port == 8686) {
            logger.printMessage(strings.get("Instance.oldDasProperties", new Object[]{propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())}));
            port = this.programOpts.getPort();
        } else {
            Console cons = System.console();
            if (cons != null) {
                String line = cons.readLine("%s", strings.get("Instance.oldDasPropertiesPrompt", new Object[]{propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())}));
                while (line != null && line.length() > 0) {
                    block19: {
                        try {
                            port = Integer.parseInt(line);
                            if (port <= 0 || port > 65535) break block19;
                            break;
                        }
                        catch (NumberFormatException nfex) {
                            // empty catch block
                        }
                    }
                    line = cons.readLine(strings.get("Instance.reenterPort"), Integer.toString(this.programOpts.getPort()));
                }
            } else {
                logger.printMessage(strings.get("Instance.oldDasPropertiesWrong", new Object[]{propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())}));
                port = this.programOpts.getPort();
            }
        }
        dasprops.setProperty("agent.das.protocol", "http");
        dasprops.setProperty("agent.das.port", Integer.toString(port));
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(propfile));
            dasprops.store(bos, "Domain Administration Server Connection Properties");
            bos.close();
            bos = null;
        }
        catch (IOException ex2) {
            logger.printMessage(strings.get("Instance.dasPropertiesUpdateFailed"));
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException cex) {}
            }
        }
        logger.printDebugMessage("New DAS port number: " + port);
        return port;
    }

    private File getTheOneAndOnlyAgent(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files.length > 1) {
            throw new CommandException(strings.get("Agent.tooManyAgentDirs", new Object[]{parent}));
        }
        if (files.length == 1) {
            return files[0];
        }
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            File f = new File(parent, hostname);
            if (!f.mkdirs() || !f.isDirectory()) {
                throw new CommandException(strings.get("Agent.cantCreateAgentDir", new Object[]{f}));
            }
            return f;
        }
        catch (UnknownHostException ex) {
            throw new CommandException(strings.get("Agent.cantGetHostName", new Object[]{ex}));
        }
    }

    private File getTheOneAndOnlyInstance(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandException(strings.get("Instance.noInstanceDirs", new Object[]{parent}));
        }
        if (files.length > 2) {
            throw new CommandException(strings.get("Instance.tooManyInstanceDirs", new Object[]{parent}));
        }
        for (File f : files) {
            if (f.getName().equals("agent")) continue;
            return f;
        }
        throw new CommandException(strings.get("Instance.noInstanceDirs", new Object[]{parent}));
    }

    private String getAgentsDirPath() throws CommandException {
        String agentsDirPath = this.getSystemProperty("com.sun.aas.agentRoot");
        if (StringUtils.ok((String)agentsDirPath)) {
            return agentsDirPath;
        }
        String installRootPath = this.getSystemProperty("com.sun.aas.installRoot");
        if (!StringUtils.ok((String)installRootPath)) {
            installRootPath = System.getProperty("com.sun.aas.installRoot");
        }
        if (!StringUtils.ok((String)installRootPath)) {
            throw new CommandException("Agent.noInstallDirPath");
        }
        return installRootPath + "/" + "nodeagents";
    }
}

