/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import javax.naming.NamingException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.persistence.jpa.ServerProviderContainerContractInfo;
import org.jvnet.hk2.component.Habitat;

public class EmbeddedProviderContainerContractInfo
extends ServerProviderContainerContractInfo {
    private static final String DEFAULT_EMBEDDED_DS_NAME = "jdbc/__embedded_default";
    private Habitat habitat;
    private static final String CONNECTION_POOL_ID = "__embedded_default_pool";
    private static final String CONNECTION_POOL_DB_NAME = "${com.sun.aas.instanceRoot}/lib/databases/embedded_default";
    private static final String EMBEDDED_DERBY_DS_NAME = "org.apache.derby.jdbc.EmbeddedDataSource";

    public EmbeddedProviderContainerContractInfo(DeploymentContext deploymentContext, ConnectorRuntime connectorRuntime, Habitat habitat, boolean isDas) {
        super(deploymentContext, connectorRuntime, isDas);
        this.habitat = habitat;
    }

    public String getDefaultDataSourceName() {
        this.checkAndCreateDefaultDSResource();
        return DEFAULT_EMBEDDED_DS_NAME;
    }

    public boolean isWeavingEnabled() {
        return false;
    }

    private void checkAndCreateDefaultDSResource() {
        boolean dataSourceExist = true;
        try {
            this.lookupDataSource(DEFAULT_EMBEDDED_DS_NAME);
        }
        catch (NamingException e) {
            dataSourceExist = false;
        }
        if (!dataSourceExist) {
            this.createDefaultDSResource();
        }
    }

    private void createDefaultDSResource() {
        ParameterMap params = new ParameterMap();
        params.add((Object)"datasourceclassname", (Object)EMBEDDED_DERBY_DS_NAME);
        params.add((Object)"property", (Object)"databaseName=${com.sun.aas.instanceRoot}/lib/databases/embedded_default:connectionAttributes=\\;create\\=true");
        params.add((Object)"jdbc_connection_pool_id", (Object)CONNECTION_POOL_ID);
        this.runCommand("create-jdbc-connection-pool", params);
        params = new ParameterMap();
        params.add((Object)"connectionpoolid", (Object)CONNECTION_POOL_ID);
        params.add((Object)"jndi_name", (Object)DEFAULT_EMBEDDED_DS_NAME);
        this.runCommand("create-jdbc-resource", params);
    }

    private ActionReport runCommand(String commandName, ParameterMap parameters) {
        CommandRunner cr = this.habitat.getComponent(CommandRunner.class);
        ActionReport ar = this.habitat.getComponent(ActionReport.class);
        cr.getCommandInvocation(commandName, ar).parameters(parameters).execute();
        return ar;
    }
}

