/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="delete-system-property")
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE})
@I18n(value="delete.system.property")
public class DeleteSystemProperty
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteSystemProperty.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="property_name", primary=true)
    String propName;
    @Inject
    Domain domain;

    @Override
    public void execute(AdminCommandContext context) {
        Domain spb;
        ActionReport report = context.getActionReport();
        Property domainProp = this.domain.getProperty("administrative.domain.name");
        String domainName = domainProp.getValue();
        if ("domain".equals(this.target) || this.target.equals(domainName)) {
            spb = this.domain;
        } else {
            spb = this.domain.getConfigNamed(this.target);
            if (spb == null) {
                spb = this.domain.getClusterNamed(this.target);
            }
            if (spb == null) {
                spb = this.domain.getServerNamed(this.target);
            }
        }
        if (spb == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target:{0}. Valid targets types are domain, config, cluster, default server, clustered instance, stand alone instance", new Object[]{this.target});
            report.setMessage(msg);
            return;
        }
        if (!spb.containsProperty(this.propName)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("no.such.property", "System Property named {0} does not exist at the given target {1}", new Object[]{this.propName, this.target});
            report.setMessage(msg);
            return;
        }
        if (this.definitions(this.propName) == 1) {
            ArrayList<String> refs = new ArrayList<String>();
            Dom root = Dom.unwrap((ConfigBeanProxy)this.domain);
            String sysPropName = SystemPropertyConstants.getPropertyAsValue((String)this.propName);
            DeleteSystemProperty.listRefs(root, sysPropName, refs);
            if (!refs.isEmpty()) {
                String msg = localStrings.getLocalString("cant.delete.referenced.property", "System Property {0} is referenced by {1} in the configuration. Please remove the references first.", new Object[]{this.propName, Arrays.toString(refs.toArray())});
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<SystemPropertyBag>(){

                @Override
                public Object run(SystemPropertyBag param) throws PropertyVetoException, TransactionFailure {
                    param.getSystemProperty().remove(param.getSystemProperty(DeleteSystemProperty.this.propName));
                    return param;
                }
            }, spb);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            String msg = localStrings.getLocalString("delete.sysprops.ok", "System Property named {0} deleted from given target {1}. Make sure you check its references.", new Object[]{this.propName, this.target});
            report.setMessage(msg);
        }
        catch (TransactionFailure tf) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tf);
        }
    }

    private int definitions(String propName) {
        int defs = 0;
        Domain bag = this.domain;
        if (bag.containsProperty(propName)) {
            ++defs;
        }
        if ((bag = this.domain.getServerNamed(this.target)) != null && bag.containsProperty(propName)) {
            ++defs;
        }
        if ((bag = this.domain.getConfigNamed(this.target)) != null && bag.containsProperty(propName)) {
            ++defs;
        }
        if ((bag = this.domain.getClusterNamed(this.target)) != null && bag.containsProperty(propName)) {
            ++defs;
        }
        return defs;
    }

    private static void listRefs(Dom dom, String value, List<String> refs) {
        for (String aname : dom.getAttributeNames()) {
            String raw = dom.rawAttribute(aname);
            if (raw == null || !raw.equals(value)) continue;
            refs.add(dom.model.getTagName() + ":" + aname);
        }
        for (String ename : dom.getElementNames()) {
            List<Dom> nodes = null;
            try {
                nodes = dom.nodeElements(ename);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (nodes == null) continue;
            for (Dom node : nodes) {
                DeleteSystemProperty.listRefs(node, value, refs);
            }
        }
    }
}

