/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util.buf;

import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UDecoder {
    private static final Logger logger = LoggerUtils.getLogger();
    private static final String ALLOW_ENCODED_SLASH_NAME = "com.sun.grizzly.util.buf.UDecoder.ALLOW_ENCODED_SLASH";
    public static final boolean ALLOW_ENCODED_SLASH = Boolean.valueOf(System.getProperty("com.sun.grizzly.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "false"));
    private boolean allowEncodedSlash;

    public UDecoder() {
        this(ALLOW_ENCODED_SLASH);
    }

    public UDecoder(boolean allowEncodedSlash) {
        this.allowEncodedSlash = allowEncodedSlash;
    }

    public void convert(ByteChunk mb) throws IOException {
        this.convert(mb, true);
    }

    public void convert(ByteChunk mb, boolean query) throws IOException {
        this.convert(mb, query, this.allowEncodedSlash);
    }

    public void convert(ByteChunk mb, boolean query, boolean allowEncodedSlash) throws IOException {
        int start = mb.getOffset();
        byte[] buff = mb.getBytes();
        int end = mb.getEnd();
        int idx = ByteChunk.indexOf(buff, start, end, '%');
        int idx2 = -1;
        if (query) {
            idx2 = ByteChunk.indexOf(buff, start, end, '+');
        }
        if (idx < 0 && idx2 < 0) {
            return;
        }
        if (idx2 >= 0 && idx2 < idx) {
            idx = idx2;
        }
        if (idx < 0) {
            idx = idx2;
        }
        boolean noSlash = !allowEncodedSlash && !query;
        int j = idx;
        while (j < end) {
            if (buff[j] == 43 && query) {
                buff[idx] = 32;
            } else if (buff[j] != 37) {
                buff[idx] = buff[j];
            } else {
                if (j + 2 >= end) {
                    throw new CharConversionException("EOF");
                }
                byte b1 = buff[j + 1];
                byte b2 = buff[j + 2];
                if (!UDecoder.isHexDigit(b1) || !UDecoder.isHexDigit(b2)) {
                    throw new CharConversionException("isHexDigit");
                }
                j += 2;
                int res = UDecoder.x2c(b1, b2);
                if (noSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed by default.  To enable encodedslashes, set the property com.sun.grizzly.util.buf.UDecoder.ALLOW_ENCODED_SLASH to true.");
                }
                buff[idx] = (byte)res;
            }
            ++j;
            ++idx;
        }
        mb.setEnd(idx);
    }

    public void convert(CharChunk mb) throws IOException {
        this.convert(mb, true);
    }

    public void convert(CharChunk mb, boolean query) throws IOException {
        int start = mb.getOffset();
        char[] buff = mb.getBuffer();
        int cend = mb.getEnd();
        int idx = CharChunk.indexOf(buff, start, cend, '%');
        int idx2 = -1;
        if (query) {
            idx2 = CharChunk.indexOf(buff, start, cend, '+');
        }
        if (idx < 0 && idx2 < 0) {
            return;
        }
        if (idx2 >= 0 && idx2 < idx) {
            idx = idx2;
        }
        if (idx < 0) {
            idx = idx2;
        }
        int j = idx;
        while (j < cend) {
            if (buff[j] == '+' && query) {
                buff[idx] = 32;
            } else if (buff[j] != '%') {
                buff[idx] = buff[j];
            } else {
                if (j + 2 >= cend) {
                    throw new CharConversionException("EOF");
                }
                char b1 = buff[j + 1];
                char b2 = buff[j + 2];
                if (!UDecoder.isHexDigit(b1) || !UDecoder.isHexDigit(b2)) {
                    throw new CharConversionException("isHexDigit");
                }
                j += 2;
                int res = UDecoder.x2c(b1, b2);
                buff[idx] = (char)res;
            }
            ++j;
            ++idx;
        }
        mb.setEnd(idx);
    }

    public void convert(MessageBytes mb) throws IOException {
        this.convert(mb, true);
    }

    public void convert(MessageBytes mb, boolean query) throws IOException {
        this.convert(mb, query, this.allowEncodedSlash);
    }

    public void convert(MessageBytes mb, boolean query, boolean allowEncodingSlash) throws IOException {
        switch (mb.getType()) {
            case 1: {
                String strValue = mb.toString();
                if (strValue == null) {
                    return;
                }
                mb.setString(this.convert(strValue, query));
                break;
            }
            case 3: {
                CharChunk charC = mb.getCharChunk();
                this.convert(charC, query);
                break;
            }
            case 2: {
                ByteChunk bytesC = mb.getByteChunk();
                this.convert(bytesC, query, allowEncodingSlash);
            }
        }
    }

    public String convert(String str) {
        return this.convert(str, true);
    }

    public String convert(String str, boolean query) {
        if (str == null) {
            return null;
        }
        if (!(query && str.indexOf(43) >= 0 || str.indexOf(37) >= 0)) {
            return str;
        }
        StringBuilder dec = new StringBuilder();
        int strPos = 0;
        int strLen = str.length();
        dec.ensureCapacity(str.length());
        while (strPos < strLen) {
            char laChar;
            int laPos;
            for (laPos = strPos; !(laPos >= strLen || (laChar = str.charAt(laPos)) == '+' && query || laChar == '%'); ++laPos) {
            }
            if (laPos > strPos) {
                dec.append(str.substring(strPos, laPos));
                strPos = laPos;
            }
            if (strPos >= strLen) break;
            char metaChar = str.charAt(strPos);
            if (metaChar == '+') {
                dec.append(' ');
                ++strPos;
                continue;
            }
            if (metaChar != '%') continue;
            dec.append((char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16));
            strPos += 3;
        }
        return dec.toString();
    }

    private static boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private static int x2c(byte b1, byte b2) {
        int digit = b1 >= 65 ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        digit *= 16;
        return digit += b2 >= 65 ? (b2 & 0xDF) - 65 + 10 : b2 - 48;
    }

    private static int x2c(char b1, char b2) {
        int digit = b1 >= 'A' ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        digit *= 16;
        return digit += b2 >= 'A' ? (b2 & 0xDF) - 65 + 10 : b2 - 48;
    }

    private static void log(String s) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "URLDecoder: " + s);
        }
    }

    public boolean isAllowEncodedSlash() {
        return this.allowEncodedSlash;
    }

    public void setAllowEncodedSlash(boolean allowEncodedSlash) {
        this.allowEncodedSlash = allowEncodedSlash;
    }
}

