/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.J2EESecurityManager;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.security.SecurityLifecycleException;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.WebSecurityDeployerStatsProvider;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.glassfish.api.Startup;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;

@Service
@Scoped(value=Singleton.class)
public class SecurityLifecycle
implements PostConstruct,
PreDestroy {
    @Inject
    private ServerContext sc;
    @Inject
    private PolicyLoader policyLoader;
    @Inject
    private SecurityServicesUtil secServUtil;
    @Inject
    private Util util;
    @Inject
    private SSLUtils sslUtils;
    @Inject
    private SecurityConfigListener configListener;
    @Inject(name="MessageSecurityConfigListener", optional=true)
    private ConfigListener msgSecurityConfigListener;
    @Inject
    private Habitat habitat;
    @Inject
    private RealmsManager realmsManager;
    private static Map statsProviders = new HashMap();
    private static WebSecurityDeployerStatsProvider webStatsProvider = null;
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(SecurityLifecycle.class);
    private EventListener listener = null;
    private static final String SYS_PROP_LOGIN_CONF = "java.security.auth.login.config";
    private static final String SYS_PROP_JAVA_SEC_POLICY = "java.security.policy";
    private static final Logger _logger = LogDomains.getLogger(SecurityLifecycle.class, (String)"javax.enterprise.system.core.security");

    public SecurityLifecycle() {
        try {
            SecurityManager secMgr;
            if (Util.isEmbeddedServer()) {
                if (System.getProperty(SYS_PROP_LOGIN_CONF) == null) {
                    System.setProperty(SYS_PROP_LOGIN_CONF, Util.writeConfigFileToTempDir("login.conf").getAbsolutePath());
                }
                if (System.getProperty(SYS_PROP_JAVA_SEC_POLICY) == null) {
                    System.setProperty(SYS_PROP_JAVA_SEC_POLICY, Util.writeConfigFileToTempDir("server.policy").getAbsolutePath());
                }
            }
            if ((secMgr = System.getSecurityManager()) != null && !J2EESecurityManager.class.equals(secMgr.getClass())) {
                J2EESecurityManager mgr = new J2EESecurityManager();
                try {
                    System.setSecurityManager(mgr);
                }
                catch (SecurityException ex) {
                    _logger.log(Level.WARNING, "security.secmgr.could.not.override");
                }
            }
            if (_logger.isLoggable(Level.INFO)) {
                if (secMgr != null) {
                    _logger.info("security.secmgron");
                } else {
                    _logger.info("security.secmgroff");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public void onInitialization() {
        try {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Security startup service called");
            }
            webStatsProvider = new WebSecurityDeployerStatsProvider();
            StatsProviderManager.register((String)"security", (PluginPoint)PluginPoint.SERVER, (String)"security/web", (Object)webStatsProvider);
            this.initializeJMAC();
            this.policyLoader.loadPolicy();
            this.realmsManager.createRealms();
            AuditManager auditManager = this.secServUtil.getAuditManager();
            auditManager.loadAuditModules();
            auditManager.serverStarted();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Security service(s) started successfully....");
            }
        }
        catch (Exception ex) {
            throw new SecurityLifecycleException(ex);
        }
    }

    private void initializeJMAC() throws IOException {
        String defaultFactory = Security.getProperty("authconfigprovider.factory");
        if (defaultFactory == null) {
            Security.setProperty("authconfigprovider.factory", GFAuthConfigFactory.class.getName());
        }
    }

    private void registerPolicyHandlers() throws PolicyContextException {
        PolicyContextHandler pch = PolicyContextHandlerImpl.getInstance();
        PolicyContext.registerHandler((String)"javax.ejb.EnterpriseBean", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.ejb.arguments", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"javax.servlet.http.HttpServletRequest", (PolicyContextHandler)pch, (boolean)true);
        PolicyContext.registerHandler((String)"java.security.Policy.supportsReuse", (PolicyContextHandler)pch, (boolean)true);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.START;
    }

    public void postConstruct() {
        this.onInitialization();
        this.listener = new AuditServerShutdownListener();
        Events events = this.habitat.getByContract(Events.class);
        events.register(this.listener);
    }

    public void preDestroy() {
    }

    public class AuditServerShutdownListener
    implements EventListener {
        public void event(EventListener.Event event) {
            if (EventTypes.SERVER_SHUTDOWN.equals((Object)event.type())) {
                SecurityLifecycle.this.secServUtil.getAuditManager().serverShutdown();
            }
        }
    }
}

