/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.universal.process.LocalAdminCommand;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.v3.admin.cluster.RemoteInstanceCommandHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.cluster.ssh.connect.RemoteConnectHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="create-instance")
@I18n(value="create.instance")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class CreateInstanceCommand
implements AdminCommand,
PostConstruct {
    private static final String DEFAULT_NODE = "localhost";
    private static final String LOCAL_HOST = "localhost";
    private static final String NL = System.getProperty("line.separator");
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    private Nodes nodes;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Servers servers;
    @Inject
    private Configs configs;
    @Param(name="node", optional=true, defaultValue="localhost")
    String node;
    @Param(name="nodeagent", optional=true)
    String nodeAgent;
    @Param(name="config", optional=true)
    String configRef;
    @Param(name="cluster", optional=true)
    String clusterName;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    @Param(name="instance_name", primary=true)
    private String instance;
    private Logger logger;
    private AdminCommandContext ctx;
    private RemoteInstanceCommandHelper helper;

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.env, this.servers, this.configs);
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.logger;
        if (this.nodes.getNode(this.node) == null) {
            String msg = Strings.get("noSuchNode", this.node);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.nodeAgent == null || this.nodeAgent.length() == 0) {
            this.nodeAgent = this.getHostFromNodeName(this.node);
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_register-instance", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"node", (Object)this.node);
        map.add((Object)"nodeagent", (Object)this.nodeAgent);
        map.add((Object)"config", (Object)this.configRef);
        map.add((Object)"cluster", (Object)this.clusterName);
        map.add((Object)"systemproperties", (Object)this.systemProperties);
        map.add((Object)"DEFAULT", (Object)this.instance);
        ci.parameters(map);
        ci.execute();
        if (this.node == null || this.node.equals("localhost")) {
            LocalAdminCommand lac = new LocalAdminCommand("_create-instance-filesystem", new String[]{this.instance});
            String msg = Strings.get("creatingInstance", this.instance, "localhost");
            this.logger.info(msg);
            try {
                int status = lac.execute();
            }
            catch (ProcessManagerException ex) {
                msg = Strings.get("create.instance.failed", this.instance);
                this.logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
            }
        } else {
            String msg = Strings.get("creatingInstance", this.instance, this.node);
            this.logger.info(msg);
            this.createInstanceRemote();
        }
    }

    private String getHostFromNodeName(String nodeName) {
        Node theNode = this.nodes.getNode(nodeName);
        if (theNode == null) {
            return "localhost";
        }
        String hostName = theNode.getNodeHost();
        if (hostName == null || hostName.length() == 0) {
            return "localhost";
        }
        return hostName;
    }

    private void createInstanceRemote() {
        RemoteConnectHelper rch = new RemoteConnectHelper(this.habitat, this.nodeList, this.logger, this.helper.getHost(this.instance), this.helper.getAdminPort(this.instance));
        ActionReport report = this.ctx.getActionReport();
        if (rch.isRemoteConnectRequired(this.node)) {
            StringBuilder output = new StringBuilder();
            int status = rch.runCommand(this.node, "_create-instance-filesystem", this.instance, output);
            if (output.length() > 0) {
                this.logger.info(output.toString());
            }
            if (status != 1) {
                String msg = Strings.get("create.instance.failed", this.instance);
                this.logger.warning(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(output.toString() + NL + msg);
            }
        } else {
            String msg = Strings.get("mustRunLocal", this.getHostFromNodeName(this.node), this.node, "asadmin create-local-instance --filesystemonly " + this.instance);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            report.setMessage(msg);
        }
    }
}

