/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.versioning;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@I18n(value="versioning.service")
@Service
@Scoped(value=PerLookup.class)
public class VersioningService {
    private static final LocalStringManagerImpl LOCALSTRINGS = new LocalStringManagerImpl(VersioningService.class);
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Domain domain;
    static final String REPOSITORY_DASH = "-";
    public static final String EXPRESSION_SEPARATOR = ":";
    public static final String EXPRESSION_WILDCARD = "*";

    public static final String getUntaggedName(String appName) throws VersioningSyntaxException {
        int colonIndex;
        if (appName != null && !appName.isEmpty() && (colonIndex = appName.indexOf(EXPRESSION_SEPARATOR)) != -1) {
            if (colonIndex == appName.length() - 1) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("invalid.appname", "excepted version identifier after colon: {0}", new Object[]{appName}));
            }
            return appName.substring(0, colonIndex);
        }
        return appName;
    }

    public static final String getExpression(String appName) throws VersioningSyntaxException {
        int colonIndex = appName.indexOf(EXPRESSION_SEPARATOR);
        if (colonIndex != -1) {
            if (colonIndex == appName.length() - 1) {
                throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("invalid.appName", "excepted version expression/identifier after colon: {0}", new Object[]{appName}));
            }
            return appName.substring(colonIndex + 1, appName.length());
        }
        return null;
    }

    public static final void checkIdentifier(String appName) throws VersioningSyntaxException {
        String identifier = VersioningService.getExpression(appName);
        if (identifier != null && identifier.contains(EXPRESSION_WILDCARD)) {
            throw new VersioningSyntaxException(LOCALSTRINGS.getLocalString("versioning.service.wildcard.not.allowed", "Wildcard character(s) are not allowed in a version identifier."));
        }
    }

    public static final List<String> getVersions(String untaggedName, List<ApplicationRef> allApplicationRefs) {
        ArrayList<String> allVersions = new ArrayList<String>();
        for (ApplicationRef ref : allApplicationRefs) {
            if (!ref.getRef().startsWith(untaggedName + EXPRESSION_SEPARATOR) && !ref.getRef().equals(untaggedName)) continue;
            allVersions.add(ref.getRef());
        }
        return allVersions;
    }

    public final List<String> getAllversions(String untaggedName, String target) {
        List allApplicationRefs = this.domain.getApplicationRefsInTarget(target);
        return VersioningService.getVersions(untaggedName, allApplicationRefs);
    }

    public final String getEnabledVersion(String name, String target) throws VersioningSyntaxException {
        String untaggedName = VersioningService.getUntaggedName(name);
        List<String> allVersions = this.getAllversions(untaggedName, target);
        if (allVersions != null) {
            for (String app : allVersions) {
                ApplicationRef ref = this.domain.getApplicationRefInTarget(app, target);
                if (ref == null || !Boolean.valueOf(ref.getEnabled()).booleanValue()) continue;
                return app;
            }
        }
        return null;
    }

    public static final List<String> matchExpression(List<String> listVersion, String appName) throws VersioningException {
        if (listVersion.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        String expressionVersion = VersioningService.getExpression(appName);
        if (expressionVersion == null) {
            if (listVersion.contains(appName)) {
                return listVersion.subList(listVersion.indexOf(appName), listVersion.indexOf(appName) + 1);
            }
            throw new VersioningException(LOCALSTRINGS.getLocalString("version.notreg", "version {0} not registered", new Object[]{appName}));
        }
        if (expressionVersion.indexOf(EXPRESSION_WILDCARD) == -1) {
            if (listVersion.contains(appName)) {
                return listVersion.subList(listVersion.indexOf(appName), listVersion.indexOf(appName) + 1);
            }
            throw new VersioningException(LOCALSTRINGS.getLocalString("version.notreg", "Version {0} not registered", new Object[]{appName}));
        }
        StringTokenizer st = new StringTokenizer(expressionVersion, EXPRESSION_WILDCARD);
        String lastToken = null;
        ArrayList<String> matchedVersions = new ArrayList<String>(listVersion);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            for (String app : listVersion) {
                String identifier = VersioningService.getExpression(app);
                int lastTokenIndex = -1;
                if (lastToken != null) {
                    lastTokenIndex = identifier.indexOf(lastToken);
                }
                if (identifier != null) {
                    if (expressionVersion.startsWith(token) && !identifier.startsWith(token)) {
                        matchedVersions.remove(app);
                        continue;
                    }
                    if (expressionVersion.endsWith(token) && !identifier.endsWith(token)) {
                        matchedVersions.remove(app);
                        continue;
                    }
                    if (identifier.contains(token.subSequence(0, token.length() - 1)) && identifier.indexOf(token) > lastTokenIndex) continue;
                    matchedVersions.remove(app);
                    continue;
                }
                matchedVersions.remove(app);
            }
            lastToken = token;
        }
        return matchedVersions;
    }

    public final List<String> getMatchedVersions(String name, String target) throws VersioningException {
        String untagged = VersioningService.getUntaggedName(name);
        List<String> allVersions = this.getAllversions(untagged, target);
        if (allVersions.size() == 0) {
            if (!name.equals(untagged)) {
                throw new VersioningException(LOCALSTRINGS.getLocalString("application.noversion", "Application {0} has no version registered", new Object[]{untagged}));
            }
            return Collections.EMPTY_LIST;
        }
        return VersioningService.matchExpression(allVersions, name);
    }

    public static final String getRepositoryName(String appName) throws VersioningSyntaxException {
        String expression = VersioningService.getExpression(appName);
        String untaggedName = VersioningService.getUntaggedName(appName);
        if (expression != null) {
            StringBuilder repositoryNameBuilder = new StringBuilder(untaggedName);
            repositoryNameBuilder.append(REPOSITORY_DASH);
            repositoryNameBuilder.append(expression);
            return repositoryNameBuilder.toString();
        }
        return untaggedName;
    }

    public void handleDisable(String appName, String target, ActionReport report) throws VersioningSyntaxException {
        String enabledVersion = this.getEnabledVersion(appName, target);
        if (enabledVersion != null && !enabledVersion.equals(appName)) {
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"DEFAULT", (Object)enabledVersion);
            parameters.add((Object)"target", (Object)target);
            ActionReport subReport = report.addSubActionsReport();
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("disable", subReport);
            inv.parameters(parameters).execute();
        }
    }
}

