/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.glassfish.admin.rest.provider.InputException;

public class InputReader {
    private int index;
    private Reader reader;
    private char lastChar;
    private boolean useLastChar;

    public InputReader(Reader reader) {
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.useLastChar = false;
        this.index = 0;
    }

    public InputReader(String s) {
        this(new StringReader(s));
    }

    public void back() throws InputException {
        if (this.useLastChar || this.index <= 0) {
            throw new InputException("Stepping back two steps is not supported");
        }
        --this.index;
        this.useLastChar = true;
    }

    public char next() throws InputException {
        int c;
        if (this.useLastChar) {
            this.useLastChar = false;
            if (this.lastChar != '\u0000') {
                ++this.index;
            }
            return this.lastChar;
        }
        try {
            c = this.reader.read();
        }
        catch (IOException exc) {
            throw new InputException(exc);
        }
        if (c <= 0) {
            this.lastChar = '\u0000';
            return '\u0000';
        }
        ++this.index;
        this.lastChar = (char)c;
        return this.lastChar;
    }

    public InputException error(String message) {
        return new InputException(message + this.toString());
    }

    public char nextNonSpace() throws InputException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    public String next(int n) throws InputException {
        if (n == 0) {
            return "";
        }
        char[] buffer = new char[n];
        int pos = 0;
        if (this.useLastChar) {
            this.useLastChar = false;
            buffer[0] = this.lastChar;
            pos = 1;
        }
        try {
            int len;
            while (pos < n && (len = this.reader.read(buffer, pos, n - pos)) != -1) {
                pos += len;
            }
        }
        catch (IOException exc) {
            throw new InputException(exc);
        }
        this.index += pos;
        if (pos < n) {
            throw this.error("Substring bounds error");
        }
        this.lastChar = buffer[n - 1];
        return new String(buffer);
    }

    public boolean more() throws InputException {
        char nextChar = this.next();
        if (nextChar == '\u0000') {
            return false;
        }
        this.back();
        return true;
    }
}

