/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.provider.StringListResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
public class StringListResultJsonProvider
extends ProviderUtil
implements MessageBodyWriter<StringListResult> {
    @Context
    protected UriInfo uriInfo;

    public long getSize(StringListResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            if (Class.forName("org.glassfish.admin.rest.provider.StringListResult").equals(genericType)) {
                return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    public void writeTo(StringListResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getJson(proxy).getBytes());
    }

    private String getJson(StringListResult proxy) {
        String indent = "  ";
        String uri = this.uriInfo.getAbsolutePath().toString();
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String result = "{";
        result = result + "\n\n" + indent;
        result = result + this.getTypeKey(name);
        if (proxy.isError()) {
            result = result + ":{";
            result = result + this.getAttribute("error", proxy.getErrorMessage());
            result = result + "},";
        } else {
            result = result + ":[";
            boolean firstEntry = true;
            for (String message : proxy.getMessages()) {
                if (!firstEntry) {
                    result = result + ",";
                }
                result = result + "\n" + indent + "  ";
                result = result + StringListResultJsonProvider.quote(message);
                firstEntry = false;
            }
            result = result + "],";
        }
        result = result + "\n\n" + indent;
        result = result + StringListResultJsonProvider.quote(StringListResultJsonProvider.getMethodsKey()) + ":{";
        result = result + StringListResultJsonProvider.getJsonForMethodMetaData(proxy.getMetaData(), indent + "  ");
        result = result + "\n" + indent + "}";
        result = result + "\n\n" + "}";
        return result;
    }

    private String getAttribute(String name, String value) {
        String result = "";
        result = result + StringListResultJsonProvider.quote(name) + " : " + StringListResultJsonProvider.quote(value);
        return result;
    }
}

