/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.impl.base.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.ClusterManager;
import com.sun.enterprise.mgmt.ClusterView;
import com.sun.enterprise.mgmt.ClusterViewEvent;
import com.sun.enterprise.mgmt.ClusterViewEvents;
import com.sun.enterprise.mgmt.ClusterViewManager;
import com.sun.enterprise.mgmt.HealthMessage;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageEvent;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.MessageListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class MasterNode
implements MessageListener,
Runnable {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private static final Logger masterLogger = Logger.getLogger("ShoalLogger.MasterNode");
    private final ClusterManager manager;
    private boolean masterAssigned = false;
    private volatile boolean discoveryInProgress = true;
    private PeerID localNodeID;
    private final SystemAdvertisement sysAdv;
    private volatile boolean started = false;
    private volatile boolean stop = false;
    private Thread thread = null;
    private ClusterViewManager clusterViewManager;
    private ClusterView discoveryView;
    private final AtomicLong masterViewID = new AtomicLong();
    final Object MASTERLOCK = new Object();
    private static final String CCNTL = "CCNTL";
    private static final String MASTERNODE = "MN";
    private static final String MASTERQUERY = "MQ";
    private static final String NODEQUERY = "NQ";
    private static final String MASTERNODERESPONSE = "MR";
    private static final String NODERESPONSE = "NR";
    private static final String NAMESPACE = "MASTER";
    private static final String NODEADV = "NAD";
    private static final String AMASTERVIEW = "AMV";
    private static final String MASTERVIEWSEQ = "SEQ";
    private static final String GROUPSTARTING = "GS";
    private static final String GROUPSTARTUPCOMPLETE = "GSC";
    private int interval = 6;
    private long timeout = 10000L;
    private static final String VIEW_CHANGE_EVENT = "VCE";
    private boolean groupStarting = false;
    private List<String> groupStartingMembers = null;
    private final Timer timer;
    private DelayedSetGroupStartingCompleteTask groupStartingTask = null;
    private static final long MAX_GROUPSTARTING_TIME = 240000L;
    private static final long GROUPSTARTING_COMPLETE_DELAY = 30000L;
    private boolean clusterStopping = false;
    final Object discoveryLock = new Object();
    private GMSContext ctx = null;
    private final SortedSet<MasterNodeMessageEvent> outstandingMasterNodeMessages;
    private Thread processOutstandingMessagesThread = null;

    MasterNode(ClusterManager manager, long timeout, int interval) {
        this.localNodeID = manager.getPeerID();
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.interval = interval;
        this.manager = manager;
        this.sysAdv = manager.getSystemAdvertisement();
        this.discoveryView = new ClusterView(this.sysAdv);
        this.timer = new Timer(true);
        this.outstandingMasterNodeMessages = new TreeSet<MasterNodeMessageEvent>();
    }

    long getTimeout() {
        return this.timeout * (long)this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkMaster(SystemAdvertisement systemAdv) {
        if (this.masterAssigned && this.isMaster()) {
            LOG.log(Level.FINE, "checkMaster : clusterStopping() = " + this.clusterStopping);
            if (this.clusterStopping) {
                LOG.log(Level.FINE, "Resigning Master Node role in anticipation of a master node announcement");
                LOG.log(Level.FINE, "Accepting DAS as new master in the event of cluster stopping...");
                MasterNode masterNode = this;
                synchronized (masterNode) {
                    this.clusterViewManager.setMaster(systemAdv, false);
                    this.masterAssigned = true;
                }
                return false;
            }
            LOG.log(Level.FINE, "Master node role collision with " + systemAdv.getName() + " .... attempting to resolve");
            this.send(systemAdv.getID(), systemAdv.getName(), this.createMasterCollisionMessage());
            if (this.manager.getPeerID().compareTo(systemAdv.getID()) >= 0) {
                LOG.log(Level.FINE, "Affirming Master Node role");
            } else {
                LOG.log(Level.FINE, "Resigning Master Node role in anticipation of a master node announcement");
                this.clusterViewManager.setMaster(systemAdv, false);
            }
            return false;
        }
        Object object = this;
        synchronized (object) {
            this.clusterViewManager.setMaster(systemAdv, true);
            this.masterAssigned = true;
        }
        object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        LOG.log(Level.FINE, "Discovered a Master node :" + systemAdv.getName());
        return true;
    }

    private Message createMasterCollisionMessage() {
        Message msg = this.createSelfNodeAdvertisement();
        msg.addMessageElement(CCNTL, this.localNodeID);
        LOG.log(Level.FINER, "Created a Master Collision Message");
        return msg;
    }

    private Message createSelfNodeAdvertisement() {
        MessageImpl msg = new MessageImpl(3);
        msg.addMessageElement(NODEADV, this.sysAdv);
        return msg;
    }

    private void sendSelfNodeAdvertisement(PeerID id, String name) {
        Message msg = this.createSelfNodeAdvertisement();
        LOG.log(Level.FINER, "Sending a Node Response Message ");
        msg.addMessageElement(NODERESPONSE, (Serializable)((Object)"noderesponse"));
        this.send(id, name, msg);
    }

    private void sendGroupStartupComplete() {
        Message msg = this.createSelfNodeAdvertisement();
        LOG.log(Level.FINER, "Sending GroupStartupComplete Message for group:" + this.manager.getGroupName());
        msg.addMessageElement(GROUPSTARTUPCOMPLETE, (Serializable)((Object)"true"));
        this.send(null, null, msg);
    }

    private Message createMasterQuery() {
        Message msg = this.createSelfNodeAdvertisement();
        msg.addMessageElement(MASTERQUERY, (Serializable)((Object)"query"));
        LOG.log(Level.FINER, "Created a Master Node Query Message ");
        return msg;
    }

    private Message createNodeQuery() {
        Message msg = this.createSelfNodeAdvertisement();
        msg.addMessageElement(NODEQUERY, (Serializable)((Object)"nodequery"));
        LOG.log(Level.FINER, "Created a Node Query Message ");
        return msg;
    }

    private Message createMasterResponse(boolean announcement, PeerID masterID) {
        Message msg = this.createSelfNodeAdvertisement();
        String type = MASTERNODE;
        if (!announcement) {
            type = MASTERNODERESPONSE;
        }
        msg.addMessageElement(type, masterID);
        if (this.groupStarting) {
            msg.addMessageElement(GROUPSTARTING, (Serializable)((Object)Boolean.toString(this.groupStarting)));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Created a Master Response Message with masterId = " + masterID.toString() + " groupStarting=" + Boolean.toString(this.groupStarting));
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean discoverMaster() {
        this.masterViewID.set(this.clusterViewManager.getMasterViewID());
        long timeToWait = this.timeout;
        LOG.log(Level.FINER, "Attempting to discover a master node");
        Message query = this.createMasterQuery();
        this.send(null, null, query);
        LOG.log(Level.FINER, " waiting for " + this.timeout + " ms");
        try {
            Object object = this.MASTERLOCK;
            synchronized (object) {
                this.MASTERLOCK.wait(timeToWait);
            }
        }
        catch (InterruptedException intr) {
            Thread.interrupted();
            LOG.log(Level.FINER, "Thread interrupted", intr);
        }
        LOG.log(Level.FINE, "masterAssigned=" + this.masterAssigned);
        return this.masterAssigned;
    }

    boolean isMaster() {
        if (masterLogger.isLoggable(Level.FINER)) {
            masterLogger.log(Level.FINER, "isMaster :" + this.clusterViewManager.isMaster() + " MasterAssigned :" + this.masterAssigned + " View Size :" + this.clusterViewManager.getViewSize());
        } else if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "isMaster :" + this.clusterViewManager.isMaster() + " MasterAssigned :" + this.masterAssigned + " View Size :" + this.clusterViewManager.getViewSize());
        }
        return this.clusterViewManager.isMaster();
    }

    boolean isMasterAssigned() {
        return this.masterAssigned;
    }

    PeerID getMasterNodeID() {
        return this.clusterViewManager.getMaster().getID();
    }

    synchronized boolean isStarted() {
        return this.started;
    }

    void resetMaster() {
        LOG.log(Level.FINER, "Resetting Master view");
        this.masterAssigned = false;
    }

    SystemAdvertisement processNodeAdvertisement(Message msg) throws IOException {
        SystemAdvertisement adv;
        Object msgElement = msg.getMessageElement(NODEADV);
        if (msgElement == null) {
            LOG.log(Level.WARNING, "Missing NODEADV message element. message = " + msg);
            return null;
        }
        if (msgElement instanceof SystemAdvertisement) {
            adv = (SystemAdvertisement)msgElement;
            if (!adv.getID().equals(this.localNodeID)) {
                LOG.log(Level.FINER, "Received a System advertisment Name :" + adv.getName());
            }
        } else {
            LOG.log(Level.WARNING, "Received an unknown message");
            adv = null;
        }
        return adv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeAnnouncement(Message msg, SystemAdvertisement source) throws IOException {
        Object msgElement = msg.getMessageElement(MASTERNODE);
        if (msgElement == null) {
            return false;
        }
        GMSMember member = Utility.getGMSMember(source);
        long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Received a Master Node Announcement from  member:" + member.getMemberToken() + " of group:" + member.getGroupName() + " masterViewSeqId:" + seqID + " masterAssigned:" + this.masterAssigned + " isMaster:" + this.isMaster());
        }
        if (this.checkMaster(source)) {
            msgElement = msg.getMessageElement(AMASTERVIEW);
            if (msgElement != null && msgElement instanceof List) {
                List newLocalView = (List)msgElement;
                if (newLocalView != null) {
                    LOG.log(Level.FINER, MessageFormat.format("Received an authoritative view from {0}, of size {1} resetting local view containing {2}", source.getName(), newLocalView.size(), this.clusterViewManager.getLocalView().getSize()));
                }
                if ((msgElement = msg.getMessageElement(VIEW_CHANGE_EVENT)) != null && msgElement instanceof ClusterViewEvent) {
                    LOG.log(Level.FINE, "MasterNode:PMNA: Received Master View with Seq Id=" + seqID + "Current sequence is " + this.clusterViewManager.getMasterViewID());
                    if (!this.isDiscoveryInProgress() && seqID <= this.clusterViewManager.getMasterViewID()) {
                        LOG.log(Level.WARNING, MessageFormat.format("Received an older clusterView sequence {0}. Current sequence :{1} discarding out of sequence view", seqID, this.clusterViewManager.getMasterViewID()));
                        return true;
                    }
                    ClusterViewEvent cvEvent = (ClusterViewEvent)msgElement;
                    assert (newLocalView != null);
                    if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                        LOG.log(Level.FINE, "New ClusterViewManager does not contain self. Publishing Self");
                        this.sendSelfNodeAdvertisement(source.getID(), null);
                        return true;
                    }
                    this.clusterViewManager.setMasterViewID(seqID);
                    this.masterViewID.set(seqID);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "MN: New MasterViewID = " + this.clusterViewManager.getMasterViewID());
                    }
                    this.clusterViewManager.addToView(newLocalView, true, cvEvent);
                }
            } else {
                LOG.log(Level.WARNING, "New View Received without corresponding ViewChangeEvent details");
            }
        }
        Object object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeResponse(Message msg, SystemAdvertisement source) throws IOException {
        boolean masterChanged;
        Object msgElement = msg.getMessageElement(MASTERNODERESPONSE);
        if (msgElement == null) {
            return false;
        }
        long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Received a MasterNode Response from Member:" + source.getName() + " PMNR masterViewSeqId:" + seqID + " current MasterViewSeqId:" + this.masterViewID.get() + " masterAssigned=" + this.masterAssigned + " isMaster=" + this.isMaster() + " discoveryInProgress:" + this.isDiscoveryInProgress());
        }
        if ((msgElement = msg.getMessageElement(GROUPSTARTING)) != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "MNR indicates GroupStart for group: " + this.manager.getGroupName());
            }
            this.setGroupStarting(true);
            this.delayedSetGroupStarting(false, 240000L);
        }
        if ((msgElement = msg.getMessageElement(AMASTERVIEW)) == null || !(msgElement instanceof List)) {
            MasterNode masterNode = this;
            synchronized (masterNode) {
                this.clusterViewManager.setMaster(source, true);
                this.masterAssigned = true;
            }
            return true;
        }
        List newLocalView = (List)msgElement;
        msgElement = msg.getMessageElement(VIEW_CHANGE_EVENT);
        if (msgElement == null || !(msgElement instanceof ClusterViewEvent)) {
            MasterNode masterNode = this;
            synchronized (masterNode) {
                this.clusterViewManager.setMaster(source, true);
                this.masterAssigned = true;
            }
            return true;
        }
        if (!this.isDiscoveryInProgress() && seqID <= this.clusterViewManager.getMasterViewID()) {
            MasterNode masterNode = this;
            synchronized (masterNode) {
                this.clusterViewManager.setMaster(source, true);
                this.masterAssigned = true;
            }
            LOG.log(Level.WARNING, MessageFormat.format("Received an older clusterView sequence {0} of size :{1} Current sequence :{2} discarding out of sequence view", seqID, newLocalView.size(), this.clusterViewManager.getMasterViewID()));
            return true;
        }
        ClusterViewEvent cvEvent = (ClusterViewEvent)msgElement;
        Object object = this;
        synchronized (object) {
            this.clusterViewManager.setMasterViewID(seqID);
            this.masterViewID.set(seqID);
            masterChanged = this.clusterViewManager.setMaster(newLocalView, source);
            this.masterAssigned = true;
        }
        if (masterChanged) {
            this.clusterViewManager.notifyListeners(cvEvent);
        } else {
            this.clusterViewManager.addToView(newLocalView, true, cvEvent);
        }
        object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        return true;
    }

    boolean processGroupStartupComplete(Message msg, SystemAdvertisement source) throws IOException {
        Object msgElement = msg.getMessageElement(GROUPSTARTUPCOMPLETE);
        if (msgElement == null) {
            return false;
        }
        this.delayedSetGroupStarting(false, 30000L);
        return true;
    }

    boolean processChangeEvent(Message msg, SystemAdvertisement source) throws IOException {
        Object msgElement = msg.getMessageElement(VIEW_CHANGE_EVENT);
        LOG.log(Level.FINER, "Inside processChangeEvent for group: " + this.manager.getGroupName());
        if (msgElement != null && msgElement instanceof ClusterViewEvent) {
            ClusterViewEvent cvEvent = (ClusterViewEvent)msgElement;
            msgElement = msg.getMessageElement(AMASTERVIEW);
            if (msgElement != null && msgElement instanceof List && cvEvent != null) {
                long seqID;
                if (cvEvent.getEvent() == ClusterViewEvents.JOINED_AND_READY_EVENT && cvEvent.getAdvertisement().getID().equals(this.localNodeID)) {
                    this.manager.getHealthMonitor().setJoinedAndReadyReceived();
                }
                if ((seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ)) <= this.clusterViewManager.getMasterViewID()) {
                    LOG.log(Level.WARNING, MessageFormat.format("Received a stale clusterview, older clusterview sequence {0}. Current sequence :{1} discarding out of sequence view.  Notified listeners of ChangeEvent={2} from {3} for group: {4}", seqID, this.clusterViewManager.getMasterViewID(), cvEvent.getEvent().toString(), cvEvent.getAdvertisement().getName(), this.manager.getGroupName()));
                    this.clusterViewManager.notifyListeners(cvEvent);
                    return true;
                }
                List newLocalView = (List)msgElement;
                LOG.log(Level.FINER, MessageFormat.format("Received a new view of size :{0}, event :{1}", newLocalView.size(), cvEvent.getEvent().toString()));
                if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                    LOG.log(Level.FINER, "Received ClusterViewManager does not contain self. Publishing Self");
                    this.sendSelfNodeAdvertisement(source.getID(), null);
                    return true;
                }
                this.clusterViewManager.setMasterViewID(seqID);
                this.masterViewID.set(seqID);
                this.clusterViewManager.addToView(newLocalView, true, cvEvent);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeQuery(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        Object msgElement = msg.getMessageElement(MASTERQUERY);
        if (msgElement == null || adv == null) {
            return false;
        }
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINE, MessageFormat.format("Received a MasterNode Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message masterResponseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(masterResponseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Master " + this.manager.getInstanceName() + " broadcasting ADD_EVENT  of member: " + adv.getName() + " to GMS group: " + this.manager.getGroupName());
                }
                this.sendNewView(null, cvEvent, masterResponseMsg, false);
            } else {
                LOG.log(Level.FINER, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        }
        SystemAdvertisement madv = this.clusterViewManager.getMaster();
        SystemAdvertisement oldSysAdv = this.clusterViewManager.get(adv.getID());
        if (madv != null && adv != null && madv.getID().equals(adv.getID())) {
            if (this.confirmInstanceHasRestarted(oldSysAdv, adv)) {
                LOG.warning("Previously elected Master node " + madv.getName() + " has restarted. There was no failure notification sent out for it.");
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("MasterNode.processMasterNodeQuery() : clusterViewManager.getMaster().getID() = " + this.clusterViewManager.getMaster().getID());
                    LOG.finer("MasterNode.processMasterNodeQuery() : adv.getID() = " + adv.getID());
                    LOG.finer("MasterNode.processMasterNodeQuery() : clusterViewManager.getMaster().getname() = " + this.clusterViewManager.getMaster().getName());
                    LOG.finer("MasterNode.processMasterNodeQuery() : adv.getID() = " + adv.getName());
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("MasterNode.processMasterNodeQuery() : re-electing the master...");
                }
                this.manager.getClusterViewManager().remove(adv);
                this.manager.getClusterViewManager().add(adv);
                this.resetMaster();
                this.appointMasterNode();
            } else {
                LOG.fine("MasterNode.processMasterNodeQuery() : master node did not restart as suspected");
            }
        } else {
            this.confirmInstanceHasRestarted(oldSysAdv, adv);
        }
        return true;
    }

    boolean confirmInstanceHasRestarted(SystemAdvertisement oldSysAdv, SystemAdvertisement newSysAdv) {
        if (oldSysAdv != null && newSysAdv != null) {
            LOG.fine("MasterNode.confirmInstanceHasRestarted() : oldSysAdv.getName() = " + oldSysAdv.getName());
            long cachedAdvStartTime = -1L;
            try {
                cachedAdvStartTime = Long.valueOf(oldSysAdv.getCustomTagValue(CustomTagNames.START_TIME.toString()));
                LOG.fine("MasterNode.confirmInstanceHasRestarted() : cachedAdvStartTime = " + cachedAdvStartTime);
            }
            catch (NoSuchFieldException ex) {
                LOG.fine("MasterNode.confirmInstanceHasRestarted : Could not find the START_TIME field in the cached system advertisement");
                return false;
            }
            if (cachedAdvStartTime != -1L) {
                long currentAdvStartTime = -1L;
                try {
                    currentAdvStartTime = Long.valueOf(newSysAdv.getCustomTagValue(CustomTagNames.START_TIME.toString()));
                }
                catch (NoSuchFieldException ex) {
                    LOG.fine("MasterNode.confirmInstanceHasRestarted : Could not find the START_TIME field in the current system advertisement");
                    return false;
                }
                LOG.fine("MasterNode.confirmInstanceHasRestarted() : currentAdvStartTime = " + currentAdvStartTime);
                if (currentAdvStartTime != cachedAdvStartTime) {
                    this.manager.getHealthMonitor().cleanAllCaches(oldSysAdv.getName());
                    LOG.log(Level.WARNING, MessageFormat.format("Instance {0} was restarted at  {1,time,full} on {1,date}.", newSysAdv.getName(), new Date(currentAdvStartTime)));
                    LOG.log(Level.WARNING, MessageFormat.format("Note that there was no Failure notification sent out for this instance that was previously started at  {0,time,full} on {0,date}", new Date(cachedAdvStartTime)));
                    return true;
                }
                LOG.fine("MasterNode.confirmInstanceHasRestarted : currentAdvStartTime and cachedAdvStartTime have the same value = " + new Date(cachedAdvStartTime) + " .Instance " + newSysAdv.getName() + "was not restarted.");
                return false;
            }
            LOG.fine("MasterNode.confirmInstanceHasRestarted : cachedAdvStartTime does not havea valid value = " + cachedAdvStartTime);
            return false;
        }
        LOG.fine("MasterNode.confirmInstanceHasRestarted : oldSysAdv or newSysAdv is null");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNodeQuery(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        Object msgElement = msg.getMessageElement(NODEQUERY);
        if (msgElement == null || adv == null) {
            return false;
        }
        LOG.log(Level.FINER, MessageFormat.format("Received a Node Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINE, MessageFormat.format("Received a Node Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message responseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(responseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                this.sendNewView(null, cvEvent, responseMsg, false);
            } else {
                LOG.log(Level.FINER, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        } else {
            Message response = this.createSelfNodeAdvertisement();
            response.addMessageElement(NODERESPONSE, (Serializable)((Object)"noderesponse"));
            LOG.log(Level.FINER, "Sending Node response to  :" + adv.getName());
            this.send(adv.getID(), null, response);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNodeResponse(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        Object msgElement = msg.getMessageElement(NODERESPONSE);
        if (msgElement == null || adv == null) {
            return false;
        }
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINE, MessageFormat.format("Received a Node Response from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message responseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(responseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                this.sendNewView(null, cvEvent, responseMsg, false);
            } else {
                LOG.log(Level.FINER, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeCollision(Message msg, SystemAdvertisement adv) throws IOException {
        Object msgElement = msg.getMessageElement(CCNTL);
        if (msgElement == null) {
            return false;
        }
        SystemAdvertisement madv = this.manager.getSystemAdvertisement();
        LOG.log(Level.FINE, MessageFormat.format("Candidate Master: " + madv.getName() + "received a MasterNode Collision from Name :{0} ID :{1}", adv.getName(), adv.getID()));
        if (madv.getID().compareTo(adv.getID()) >= 0) {
            LOG.log(Level.FINE, "Member " + madv.getName() + " affirming Master Node role over member:" + adv.getName());
            Object object = this.MASTERLOCK;
            synchronized (object) {
                this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                this.announceMaster(this.manager.getSystemAdvertisement());
                this.MASTERLOCK.notifyAll();
            }
        } else {
            LOG.log(Level.FINE, "Resigning Master Node role");
            this.clusterViewManager.setMaster(adv, true);
        }
        return true;
    }

    void probeNode(HealthMessage.Entry entry) throws IOException {
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINER, "Probing ID = " + entry.id + ", name = " + entry.adv.getName());
            this.send(entry.id, null, this.createNodeQuery());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageEvent(MessageEvent event) throws MessageIOException {
        Message msg = event.getMessage();
        if (msg == null) {
            return;
        }
        MasterNodeMessageEvent mnme = new MasterNodeMessageEvent(event);
        if (mnme.seqId == -1L) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("receiveMessageEvent: process master node message masterViewSeqId:" + mnme.seqId + " from member:" + event.getSourcePeerID());
            }
            this.processNextMessageEvent(mnme);
        } else {
            boolean added;
            SortedSet<MasterNodeMessageEvent> sortedSet = this.outstandingMasterNodeMessages;
            synchronized (sortedSet) {
                added = this.outstandingMasterNodeMessages.add(mnme);
                this.outstandingMasterNodeMessages.notify();
            }
            if (added) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("receiveMessageEvent: added master node message masterViewSeqId:" + mnme.seqId + " from member:" + event.getSourcePeerID());
                }
            } else {
                LOG.warning("receiveMessageEvent: ignored duplicate master node message masterViewSeqId:" + mnme.seqId + " from member:" + event.getSourcePeerID());
            }
        }
    }

    public void processNextMessageEvent(MasterNodeMessageEvent masterNodeMessage) throws MessageIOException {
        boolean result = false;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Received a message inside  pipeMsgEvent");
        }
        if (this.manager.isStopping()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Since this Peer is Stopping, returning without processing incoming master node message. ");
            }
            return;
        }
        if (this.isStarted()) {
            Message msg = masterNodeMessage.msg;
            long seqId = masterNodeMessage.seqId;
            if (msg == null) {
                LOG.log(Level.WARNING, "Received a null message");
                return;
            }
            try {
                SystemAdvertisement adv = this.processNodeAdvertisement(msg);
                if (adv != null && adv.getID().equals(this.localNodeID)) {
                    LOG.log(Level.FINEST, "Discarding loopback message");
                    return;
                }
                if (adv != null) {
                    if (this.isMaster() && this.masterAssigned) {
                        result = this.clusterViewManager.add(adv);
                    } else if (this.discoveryInProgress) {
                        result = false;
                        this.discoveryView.add(adv);
                    }
                }
                if (this.processMasterNodeQuery(msg, adv, result)) {
                    return;
                }
                if (this.processNodeQuery(msg, adv, result)) {
                    return;
                }
                if (this.processNodeResponse(msg, adv, result)) {
                    return;
                }
                if (this.processGroupStartupComplete(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeResponse(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeAnnouncement(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeCollision(msg, adv)) {
                    return;
                }
                if (this.processChangeEvent(msg, adv)) {
                    return;
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            LOG.log(Level.FINER, MessageFormat.format("ClusterViewManager contains {0} entries", this.clusterViewManager.getViewSize()));
        } else {
            LOG.log(Level.FINER, "Started : " + this.isStarted());
        }
    }

    @Override
    public int getType() {
        return 3;
    }

    private void announceMaster(SystemAdvertisement adv) {
        Message msg = this.createMasterResponse(true, adv.getID());
        ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, adv);
        if (this.masterAssigned && this.isMaster()) {
            LOG.log(Level.INFO, MessageFormat.format("Announcing Master Node designation for member: {1} of group: {2}. Local view contains {0} entries", this.clusterViewManager.getViewSize(), this.manager.getInstanceName(), this.manager.getGroupName()));
            this.sendNewView(null, cvEvent, msg, true);
        }
    }

    @Override
    public void run() {
        this.startMasterNodeDiscovery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMasterNodeDiscovery() {
        int count = 0;
        Object object = this;
        synchronized (object) {
            if (!this.masterAssigned) {
                this.clusterViewManager.start();
            }
        }
        if (this.masterAssigned) {
            this.discoverMaster();
            this.discoveryInProgress = false;
            LOG.log(Level.FINE, "startMasterNodeDiscovery: discovery completed. masterSequenceId:" + this.masterViewID.get() + " clusterViewManager.masterViewID:" + this.clusterViewManager.getMasterViewID());
            object = this.discoveryLock;
            synchronized (object) {
                this.discoveryLock.notifyAll();
            }
            return;
        }
        while (!this.stop && count < this.interval && !this.discoverMaster()) {
            ++count;
        }
        if (!this.masterAssigned) {
            LOG.log(Level.FINER, "MN Discovery timeout, appointing master");
            this.appointMasterNode();
        }
        LOG.log(Level.FINEST, "startMasterNodeDiscovery making discoveryInProgress false");
        LOG.log(Level.FINE, "startMasterNodeDiscovery: after discoverMaster polling, discovery completed. masterSequenceId:" + this.masterViewID.get() + " clusterViewManager.masterViewID:" + this.clusterViewManager.getMasterViewID());
        this.discoveryInProgress = false;
        object = this.discoveryLock;
        synchronized (object) {
            this.discoveryLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appointMasterNode() {
        if (this.masterAssigned) {
            return;
        }
        LOG.log(Level.FINER, "MasterNode: discoveryInProgress=" + this.discoveryInProgress);
        SystemAdvertisement madv = this.discoveryInProgress ? this.discoveryView.getMasterCandidate() : this.clusterViewManager.getMasterCandidate();
        LOG.log(Level.FINER, "MasterNode: Master Candidate=" + madv.getName());
        Object object = this;
        synchronized (object) {
            this.clusterViewManager.setMaster(madv, false);
            this.masterAssigned = true;
        }
        if (madv.getID().equals(this.localNodeID)) {
            LOG.log(Level.FINER, "MasterNode: Setting myself as MasterNode ");
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            LOG.log(Level.FINER, "MasterNode: masterViewId =" + this.masterViewID);
            if (this.discoveryInProgress) {
                List<SystemAdvertisement> list = this.discoveryView.getView();
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
                this.clusterViewManager.addToView(list, true, cvEvent);
            } else {
                LOG.log(Level.FINER, "MasterNode: Notifying Local Listeners of  Master Change");
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
                this.clusterViewManager.notifyListeners(cvEvent);
            }
        }
        this.discoveryView.clear();
        this.discoveryView.add(this.sysAdv);
        object = this.MASTERLOCK;
        synchronized (object) {
            if (madv.getID().equals(this.localNodeID)) {
                LOG.log(Level.INFO, "Assuming Master Node designation member:" + madv.getName() + " for group:" + this.manager.getGroupName());
                LOG.log(Level.FINER, "MasterNode: announcing MasterNode assumption ");
                this.announceMaster(this.manager.getSystemAdvertisement());
                this.MASTERLOCK.notifyAll();
            }
        }
    }

    private void send(PeerID peerid, String name, Message msg) {
        try {
            if (peerid != null) {
                LOG.log(Level.FINER, "Unicasting Message to :" + name + "ID=" + peerid);
                boolean sent = this.manager.getNetworkManager().send(peerid, msg);
                if (!sent) {
                    LOG.log(Level.WARNING, "OutputPipe.send unexpectedly returned false sending messge " + msg + " to instance " + name);
                }
            } else {
                LOG.log(Level.FINER, "Broadcasting Message");
                boolean sent = this.manager.getNetworkManager().broadcast(msg);
                if (!sent) {
                    LOG.log(Level.WARNING, "OutputPipe.send unexpectedly returned false broadcasting messge " + msg + " to cluster");
                }
            }
        }
        catch (IOException io) {
            LOG.log(Level.FINEST, "Failed to send message", io);
        }
    }

    void sendNewView(PeerID toID, ClusterViewEvent event, Message msg, boolean includeView) {
        if (includeView) {
            this.addAuthoritativeView(msg);
        }
        msg.addMessageElement(VIEW_CHANGE_EVENT, event);
        LOG.log(Level.FINER, "Sending new authoritative cluster view to group, event :" + event.getEvent().toString() + " viewSeqId: " + this.clusterViewManager.getMasterViewID());
        this.send(toID, null, msg);
    }

    void addAuthoritativeView(Message msg) {
        ClusterView cv = this.clusterViewManager.getLocalView();
        List<SystemAdvertisement> view = cv.getView();
        LOG.log(Level.FINE, "MasterNode: Adding Authoritative View of size " + view.size() + "  to view message masterSeqId=" + cv.masterViewId);
        msg.addMessageElement(AMASTERVIEW, (Serializable)((Object)view));
        MasterNode.addLongToMessage(msg, NAMESPACE, MASTERVIEWSEQ, cv.masterViewId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() {
        LOG.log(Level.FINER, "Stopping MasterNode");
        this.discoveryView.clear();
        this.thread = null;
        this.masterAssigned = false;
        this.started = false;
        this.stop = true;
        this.discoveryInProgress = false;
        Object object = this.discoveryLock;
        synchronized (object) {
            this.discoveryLock.notifyAll();
        }
        this.manager.getNetworkManager().removeMessageListener(this);
        this.processOutstandingMessagesThread.interrupt();
    }

    synchronized void start() {
        LOG.log(Level.FINER, "Starting MasterNode");
        this.clusterViewManager = this.manager.getClusterViewManager();
        this.started = true;
        this.manager.getNetworkManager().addMessageListener(this);
        LOG.info("MasterNode message listener is registered for member: " + this.manager.getInstanceName() + " group:" + this.manager.getGroupName());
        this.processOutstandingMessagesThread = new Thread((Runnable)new ProcessOutstandingMessagesTask(), "MasterNode processOutStandingMessages");
        this.processOutstandingMessagesThread.setDaemon(true);
        this.processOutstandingMessagesThread.start();
        this.thread = new Thread((Runnable)this, "MasterNode");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewChanged(ClusterViewEvent event) {
        if (this.isMaster() && this.masterAssigned) {
            this.clusterViewManager.notifyListeners(event);
            Message msg = this.createSelfNodeAdvertisement();
            AtomicLong atomicLong = this.masterViewID;
            synchronized (atomicLong) {
                this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                this.addAuthoritativeView(msg);
            }
            this.sendNewView(null, event, msg, false);
        }
    }

    private static void addLongToMessage(Message message, String nameSpace, String elemName, long data) {
        message.addMessageElement(elemName, Long.valueOf(data));
    }

    private static long getLongFromMessage(Message message, String nameSpace, String elemName) throws NumberFormatException {
        Object value = message.getMessageElement(elemName);
        if (value != null) {
            return Long.parseLong(value.toString());
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void takeOverMasterRole() {
        Object object = this.MASTERLOCK;
        synchronized (object) {
            SystemAdvertisement madv = this.clusterViewManager.get(this.localNodeID);
            LOG.log(Level.FINER, "MasterNode: Forcefully becoming the Master..." + madv.getName());
            MasterNode masterNode = this;
            synchronized (masterNode) {
                this.clusterViewManager.setMaster(madv, false);
                this.masterAssigned = true;
            }
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            LOG.log(Level.FINER, "MasterNode: becomeMaster () : masterViewId =" + this.masterViewID);
            LOG.log(Level.FINER, "MasterNode: becomeMaster () : Notifying Local Listeners of  Master Change");
            ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
            this.clusterViewManager.notifyListeners(cvEvent);
            this.discoveryView.clear();
            this.discoveryView.add(this.sysAdv);
            LOG.log(Level.FINER, "MasterNode: becomeMaster () : announcing MasterNode assumption ");
            this.announceMaster(this.manager.getSystemAdvertisement());
            this.MASTERLOCK.notifyAll();
            this.manager.notifyNewMaster();
        }
    }

    void setClusterStopping() {
        this.clusterStopping = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterViewEvent sendReadyEventView(SystemAdvertisement adv) {
        ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.JOINED_AND_READY_EVENT, adv);
        LOG.log(Level.FINEST, MessageFormat.format("Sending to Group, Joined and Ready Event View for peer :{0}", adv.getName()));
        Message msg = this.createSelfNodeAdvertisement();
        AtomicLong atomicLong = this.masterViewID;
        synchronized (atomicLong) {
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            this.addAuthoritativeView(msg);
        }
        this.sendNewView(null, cvEvent, msg, false);
        return cvEvent;
    }

    boolean isDiscoveryInProgress() {
        return this.discoveryInProgress;
    }

    void setGroupStarting(boolean value) {
        this.groupStarting = value;
        this.getGMSContext().setGroupStartup(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayedSetGroupStarting(boolean value, long delaySet) {
        Timer timer = this.timer;
        synchronized (timer) {
            if (this.groupStartingTask != null) {
                this.groupStartingTask.cancel();
            }
            this.groupStartingTask = new DelayedSetGroupStartingCompleteTask(delaySet);
            this.timer.schedule((TimerTask)this.groupStartingTask, delaySet);
        }
    }

    public boolean isGroupStartup() {
        return this.groupStarting;
    }

    void groupStartup(GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        StringBuffer sb = new StringBuffer();
        this.groupStartingMembers = memberTokens;
        switch (startupState) {
            case INITIATED: {
                this.setGroupStarting(true);
                sb.append(" Starting Members: ");
                break;
            }
            case COMPLETED_FAILED: {
                this.setGroupStarting(false);
                sb.append(" Failed Members: ");
                if (!this.isMaster() || !this.isMasterAssigned()) break;
                this.sendGroupStartupComplete();
                break;
            }
            case COMPLETED_SUCCESS: {
                this.setGroupStarting(false);
                sb.append(" Started Members: ");
                if (!this.isMaster() || !this.isMasterAssigned()) break;
                this.sendGroupStartupComplete();
            }
        }
        for (String member : memberTokens) {
            sb.append(member).append(",");
        }
        LOG.info("GroupStart for group: " + this.getGMSContext().getGroupName() + " State:" + startupState.toString() + sb);
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.manager.getGroupName());
        }
        return this.ctx;
    }

    public class ProcessOutstandingMessagesTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (MasterNode.this.manager != null && !MasterNode.this.manager.isStopping()) {
                MasterNodeMessageEvent msg = null;
                try {
                    SortedSet sortedSet = MasterNode.this.outstandingMasterNodeMessages;
                    synchronized (sortedSet) {
                        if (MasterNode.this.outstandingMasterNodeMessages.size() > 0) {
                            msg = (MasterNodeMessageEvent)MasterNode.this.outstandingMasterNodeMessages.first();
                            if (msg != null) {
                                MasterNode.this.outstandingMasterNodeMessages.remove(msg);
                            }
                        } else {
                            MasterNode.this.outstandingMasterNodeMessages.wait();
                        }
                    }
                    if (msg != null) {
                        MasterNode.this.processNextMessageEvent(msg);
                    }
                    if (!MasterNode.this.isDiscoveryInProgress() && MasterNode.this.isMaster()) continue;
                    Thread.sleep(30L);
                }
                catch (InterruptedException ie) {
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "MasterNode.ProcessOutstandingMessages.run: ignoring exception " + t.getLocalizedMessage(), t);
                }
            }
            LOG.config("Completed processing outstanding master node messages for member:" + MasterNode.this.manager.getInstanceName() + " group:" + MasterNode.this.manager.getGroupName() + " oustandingMessages to process:" + MasterNode.this.outstandingMasterNodeMessages.size());
        }
    }

    public static class MasterNodeMessageEvent
    implements Comparable {
        public final long seqId;
        public final Message msg;
        public final MessageEvent event;

        public MasterNodeMessageEvent(MessageEvent event) {
            this.event = event;
            this.msg = event.getMessage();
            this.seqId = MasterNode.getLongFromMessage(this.msg, MasterNode.NAMESPACE, MasterNode.MASTERVIEWSEQ);
        }

        public int compareTo(Object o) {
            if (o instanceof MasterNodeMessageEvent) {
                MasterNodeMessageEvent e = (MasterNodeMessageEvent)o;
                int peerCompareToResult = this.event.getSourcePeerID().compareTo(e.event.getSourcePeerID());
                return (int)(this.seqId - ((MasterNodeMessageEvent)o).seqId);
            }
            throw new IllegalArgumentException();
        }
    }

    class DelayedSetGroupStartingCompleteTask
    extends TimerTask {
        private final long delay;

        public DelayedSetGroupStartingCompleteTask(long delay) {
            this.delay = delay;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("GroupStartupCompleteTask scheduled in " + delay + " ms");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.delay == 240000L) {
                LOG.warning("missed GroupStartupComplete message. Timed out group startup after 240 secs");
            }
            Timer timer = MasterNode.this.timer;
            synchronized (timer) {
                MasterNode.this.setGroupStarting(false);
                MasterNode.this.groupStartingTask = null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received GroupStartupComplete for group:" + MasterNode.this.manager.getGroupName() + " delay(ms)=" + this.delay);
            }
        }
    }
}

