/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import com.sun.enterprise.security.ssl.SecuritySupportImpl;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.security.AccessControlException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import sun.security.tools.JarSigner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ASJarSigner
implements PostConstruct {
    public static final String USER_SPECIFIED_ALIAS_PROPERTYNAME = "com.sun.aas.jws.signing.alias";
    private static final String JKS_KEYSTORE_TYPE_VALUE = "jks";
    private static final String DEFAULT_ALIAS_VALUE = "s1as";
    private static final StringManager localStrings = StringManager.getManager(ASJarSigner.class);
    private static SecuritySupport securitySupport;
    private Logger logger;

    @Override
    public void postConstruct() {
        this.logger = LogDomains.getLogger(ASJarSigner.class, (String)"javax.enterprise.system.core");
        securitySupport = new SecuritySupportImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long signJar(File unsignedJar, File signedJar, String alias) throws Exception {
        if (alias == null) {
            alias = DEFAULT_ALIAS_VALUE;
        }
        SigningInfo signingInfo = this.createSigningInfo(alias);
        long startTime = System.currentTimeMillis();
        String[] args = signingInfo.getSigningArgs(unsignedJar, signedJar);
        ASJarSigner aSJarSigner = this;
        synchronized (aSJarSigner) {
            SecurityManager mgr = System.getSecurityManager();
            try {
                NoExitSecurityManager noExitMgr = new NoExitSecurityManager(mgr);
                System.setSecurityManager(noExitMgr);
                JarSigner.main((String[])args);
            }
            catch (Throwable t) {
                try {
                    signedJar.delete();
                    throw new Exception(localStrings.getString("jws.sign.errorSigning", (Object)signedJar.getAbsolutePath(), (Object)signingInfo.getAlias()), t);
                }
                catch (Throwable throwable) {
                    System.setSecurityManager(mgr);
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = null;
                    }
                    long duration = System.currentTimeMillis() - startTime;
                    this.logger.fine("Signing " + unsignedJar.getAbsolutePath() + " took " + duration + " ms");
                    throw throwable;
                }
            }
            System.setSecurityManager(mgr);
            for (int i = 0; i < args.length; ++i) {
                args[i] = null;
            }
            long duration = System.currentTimeMillis() - startTime;
            this.logger.fine("Signing " + unsignedJar.getAbsolutePath() + " took " + duration + " ms");
        }
        return System.currentTimeMillis() - startTime;
    }

    private SigningInfo createSigningInfo(String userAlias) throws Exception {
        String[] keystorePWs = securitySupport.getKeyStorePasswords();
        String[] tokenNames = securitySupport.getTokenNames();
        ArrayList<SigningInfo> signingInfoForDefaultAlias = new ArrayList<SigningInfo>();
        ArrayList<SigningInfo> signingInfoForUserAlias = new ArrayList<SigningInfo>();
        int keystoreSlot = 0;
        for (KeyStore ks : securitySupport.getKeyStores()) {
            if (userAlias != null && ks.containsAlias(userAlias)) {
                signingInfoForUserAlias.add(SigningInfo.newInstance(userAlias, keystorePWs[keystoreSlot], ks, tokenNames[keystoreSlot], this.logger));
            }
            if (ks.containsAlias(DEFAULT_ALIAS_VALUE)) {
                signingInfoForDefaultAlias.add(SigningInfo.newInstance(DEFAULT_ALIAS_VALUE, keystorePWs[keystoreSlot], ks, tokenNames[keystoreSlot], this.logger));
            }
            ++keystoreSlot;
        }
        SigningInfo result = this.selectSigningInfo(userAlias, signingInfoForUserAlias, signingInfoForDefaultAlias);
        this.logger.fine("Selected signing info " + result.toString());
        return result;
    }

    private SigningInfo selectSigningInfo(String userAlias, ArrayList<SigningInfo> signingInfoForUserAlias, ArrayList<SigningInfo> signingInfoForDefaultAlias) {
        String aliasOfInterest;
        ArrayList<SigningInfo> signingInfoOfInterest;
        if (userAlias != null) {
            if (signingInfoForUserAlias.size() == 0) {
                this.logger.log(Level.WARNING, "jws.sign.userAliasAbsent", userAlias);
                signingInfoOfInterest = signingInfoForDefaultAlias;
                aliasOfInterest = DEFAULT_ALIAS_VALUE;
            } else {
                signingInfoOfInterest = signingInfoForUserAlias;
                aliasOfInterest = userAlias;
            }
        } else {
            signingInfoOfInterest = signingInfoForDefaultAlias;
            aliasOfInterest = DEFAULT_ALIAS_VALUE;
        }
        if (signingInfoOfInterest.size() == 0) {
            throw new IllegalArgumentException(localStrings.getString("jws.sign.aliasNotFound", (Object)aliasOfInterest));
        }
        if (signingInfoOfInterest.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (SigningInfo si : signingInfoOfInterest) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(si);
            }
            this.logger.log(Level.WARNING, "jws.sign.aliasFoundMult", new Object[]{aliasOfInterest, sb.toString()});
        }
        return signingInfoOfInterest.get(0);
    }

    private class NoExitSecurityManager
    extends SecurityManager {
        private SecurityManager originalManager;

        public NoExitSecurityManager(SecurityManager originalManager) {
            this.originalManager = originalManager;
        }

        public void checkExit(int status) {
            throw new AccessControlException("System.exit");
        }

        public void checkPermission(Permission p) {
            if (this.originalManager != null) {
                this.originalManager.checkPermission(p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SigningInfo {
        private static final String SIGNEDJAR_OPTION = "-signedjar";
        private static final String KEYSTORE_OPTION = "-keystore";
        private static final String STOREPASS_OPTION = "-storepass";
        private static final String STORETYPE_OPTION = "-storetype";
        private KeyStore keystore;
        private String alias;
        private String password;
        private PrivateKey key;
        private String token;
        private Logger logger;

        static SigningInfo newInstance(String alias, String password, KeyStore keystore, String token, Logger logger) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (keystore.getType().equalsIgnoreCase(ASJarSigner.JKS_KEYSTORE_TYPE_VALUE)) {
                return new JKSSigningInfo(alias, password, keystore, token, logger);
            }
            return new PKCS11SigningInfo(alias, password, keystore, token, logger);
        }

        public SigningInfo(String alias, String password, KeyStore keystore, String token, Logger logger) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            this.keystore = keystore;
            this.alias = alias;
            this.password = password;
            this.token = token;
            this.logger = logger;
            this.key = this.validateKey();
        }

        public String getAlias() {
            return this.alias;
        }

        private PrivateKey validateKey() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            Key tempKey = this.keystore.getKey(this.alias, this.password.toCharArray());
            if (tempKey instanceof PrivateKey) {
                return (PrivateKey)tempKey;
            }
            String msg = MessageFormat.format(this.logger.getResourceBundle().getString("jws.sign.keyNotPrivate"), this.alias);
            throw new IllegalArgumentException(msg);
        }

        public String getProviderName() {
            return this.keystore.getProvider().getName();
        }

        public String getToken() {
            return this.token;
        }

        public String getPassword() {
            return this.password;
        }

        public String getStoreType() {
            return this.keystore.getType();
        }

        public X509Certificate[] getCertificateChain() throws KeyStoreException {
            Certificate[] certs = this.keystore.getCertificateChain(this.alias);
            X509Certificate[] X509certs = new X509Certificate[certs.length];
            int slot = 0;
            for (Certificate c : certs) {
                if (!(c instanceof X509Certificate)) {
                    throw new IllegalArgumentException(localStrings.getString("jws.sign.notX509Cert", (Object)this.alias));
                }
                X509certs[slot++] = (X509Certificate)c;
            }
            return X509certs;
        }

        public String toString() {
            return this.getClass().getName() + ": alias=" + this.alias + "; keystore type=" + this.keystore.getType() + "; provider=" + this.keystore.getProvider().getName();
        }

        public KeyStore getKeyStore() {
            return this.keystore;
        }

        public String[] getSigningArgs(File unsignedJar, File signedJar) {
            ArrayList<String> args = new ArrayList<String>();
            this.addKeyStoreTypeSpecificArgs(args);
            args.add(STORETYPE_OPTION);
            args.add(this.getKeyStore().getType());
            args.add(STOREPASS_OPTION);
            int passwordSlot = args.size();
            args.add(this.getPassword());
            args.add(SIGNEDJAR_OPTION);
            args.add(signedJar.getAbsolutePath());
            args.add(unsignedJar.getAbsolutePath());
            args.add(this.getAlias());
            String[] result = args.toArray(new String[args.size()]);
            args.set(passwordSlot, "");
            return result;
        }

        protected abstract void addKeyStoreTypeSpecificArgs(Collection<String> var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class PKCS11SigningInfo
        extends SigningInfo {
            private static final String PKCS11_PROVIDERNAME_OPTION = "-providerName";
            private static final String PKCS11_KEYSTORE_OPTION_VALUE = "NONE";

            public PKCS11SigningInfo(String alias, String password, KeyStore keystore, String token, Logger logger) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
                super(alias, password, keystore, token, logger);
            }

            @Override
            protected void addKeyStoreTypeSpecificArgs(Collection<String> args) {
                args.add(SigningInfo.KEYSTORE_OPTION);
                args.add(PKCS11_KEYSTORE_OPTION_VALUE);
                args.add(PKCS11_PROVIDERNAME_OPTION);
                args.add(this.getKeyStore().getProvider().getName());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class JKSSigningInfo
        extends SigningInfo {
            private static final String KEYSTORE_PATH_PROPERTYNAME = "javax.net.ssl.keyStore";

            private static String getJKSKeystoreAbsolutePath() {
                return System.getProperty(KEYSTORE_PATH_PROPERTYNAME);
            }

            public JKSSigningInfo(String alias, String password, KeyStore keystore, String token, Logger logger) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
                super(alias, password, keystore, token, logger);
            }

            @Override
            protected void addKeyStoreTypeSpecificArgs(Collection<String> args) {
                args.add(SigningInfo.KEYSTORE_OPTION);
                args.add(JKSSigningInfo.getJKSKeystoreAbsolutePath());
            }
        }
    }

    public static class ASJarSignerException
    extends Exception {
        public ASJarSignerException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

