/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.api;

import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreKeyHelper;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.cache.impl.util.ResponseMediator;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.mapper.KeyMapper;

public class DataStoreContext<K, V> {
    private String serviceName;
    private String instanceName;
    private String groupName;
    private DataStoreKeyHelper<K> dataStoreKeyHelper;
    private DataStoreEntryHelper<K, V> dataStoreEntryHelper;
    private CommandManager<K, V> cm;
    private KeyMapper keyMapper;
    private ResponseMediator responseMediator;
    private GroupService groupService;
    private ReplicaStore<K, V> replica;

    public DataStoreContext(String serviceName, GroupService gs, ClassLoader loader) {
        this.serviceName = serviceName;
        this.groupService = gs;
        this.instanceName = gs.getMemberName();
        this.groupName = gs.getGroupName();
        this.cm = new CommandManager(this);
        this.responseMediator = new ResponseMediator();
        this.replica = new ReplicaStore(this);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public DataStoreKeyHelper<K> getDataStoreKeyHelper() {
        return this.dataStoreKeyHelper;
    }

    public void setDataStoreKeyHelper(DataStoreKeyHelper<K> dataStoreKeyHelper) {
        this.dataStoreKeyHelper = dataStoreKeyHelper;
    }

    public DataStoreEntryHelper<K, V> getDataStoreEntryHelper() {
        return this.dataStoreEntryHelper;
    }

    public void setDataStoreEntryHelper(DataStoreEntryHelper<K, V> dataStoreEntryHelper) {
        this.dataStoreEntryHelper = dataStoreEntryHelper;
    }

    public KeyMapper getKeyMapper() {
        return this.keyMapper;
    }

    public void setKeyMapper(KeyMapper keyMapper) {
        this.keyMapper = keyMapper;
    }

    public CommandManager<K, V> getCommandManager() {
        return this.cm;
    }

    public ResponseMediator getResponseMediator() {
        return this.responseMediator;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public ReplicaStore<K, V> getReplicaStore() {
        return this.replica;
    }
}

