/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.api;

import java.io.Serializable;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreKeyHelper;
import org.shoal.ha.cache.api.DefaultObjectInputOutputStreamFactory;
import org.shoal.ha.cache.api.ObjectKeyHelper;
import org.shoal.ha.cache.impl.store.DefaultDataStoreEntryHelper;
import org.shoal.ha.cache.impl.store.ReplicatedDataStore;
import org.shoal.ha.cache.impl.util.DefaultKeyMapper;
import org.shoal.ha.cache.impl.util.StringKeyHelper;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.group.GroupServiceFactory;
import org.shoal.ha.mapper.KeyMapper;

public class DataStoreFactory {
    public static DataStore<String, Serializable> createDataStore(String storeName, String instanceName, String groupName) {
        DefaultDataStoreEntryHelper helper = new DefaultDataStoreEntryHelper(Thread.currentThread().getContextClassLoader());
        StringKeyHelper keyHelper = new StringKeyHelper();
        DefaultKeyMapper keyMapper = new DefaultKeyMapper(instanceName, groupName);
        Class<Serializable> vClazz = Serializable.class;
        DataStoreConfigurator conf = new DataStoreConfigurator();
        conf.setStartGMS(true);
        conf.setStoreName(storeName).setInstanceName(instanceName).setGroupName(groupName).setKeyClazz(String.class).setValueClazz(vClazz).setClassLoader(vClazz.getClassLoader()).setDataStoreEntryHelper(helper).setDataStoreKeyHelper(keyHelper).setKeyMapper(keyMapper).setObjectInputOutputStreamFactory(new DefaultObjectInputOutputStreamFactory());
        return DataStoreFactory.createDataStore(conf);
    }

    public static <K, V> DataStore<K, V> createDataStore(String storeName, String instanceName, String groupName, Class<K> keyClazz, Class<V> vClazz, ClassLoader loader) {
        DefaultObjectInputOutputStreamFactory factory = new DefaultObjectInputOutputStreamFactory();
        DefaultDataStoreEntryHelper helper = new DefaultDataStoreEntryHelper(vClazz.getClassLoader());
        ObjectKeyHelper keyHelper = new ObjectKeyHelper(loader, factory);
        DefaultKeyMapper keyMapper = new DefaultKeyMapper(instanceName, groupName);
        DataStoreConfigurator conf = new DataStoreConfigurator();
        conf.setStartGMS(true);
        conf.setStoreName(storeName).setInstanceName(instanceName).setGroupName(groupName).setKeyClazz(keyClazz).setValueClazz(vClazz).setClassLoader(loader).setDataStoreEntryHelper(helper).setDataStoreKeyHelper(keyHelper).setKeyMapper(keyMapper).setObjectInputOutputStreamFactory(factory);
        return DataStoreFactory.createDataStore(conf);
    }

    public static <K, V> DataStore<K, V> createDataStore(String storeName, String instanceName, String groupName, Class<K> keyClazz, Class<V> vClazz, ClassLoader loader, DataStoreEntryHelper<K, V> helper, DataStoreKeyHelper<K> keyHelper, KeyMapper keyMapper) {
        DataStoreConfigurator conf = new DataStoreConfigurator();
        conf.setStartGMS(true);
        conf.setStoreName(storeName).setInstanceName(instanceName).setGroupName(groupName).setKeyClazz(keyClazz).setValueClazz(vClazz).setClassLoader(loader).setDataStoreEntryHelper(helper).setDataStoreKeyHelper(keyHelper).setKeyMapper(keyMapper).setObjectInputOutputStreamFactory(new DefaultObjectInputOutputStreamFactory());
        return DataStoreFactory.createDataStore(conf);
    }

    public static <K, V> DataStore<K, V> createDataStore(DataStoreConfigurator<K, V> conf) {
        GroupService gs = GroupServiceFactory.getInstance().getGroupService(conf.getInstanceName(), conf.getGroupName(), conf.isStartGMS());
        if (conf.getKeyMapper() == null) {
            conf.setKeyMapper(new DefaultKeyMapper(conf.getInstanceName(), conf.getGroupName()));
        }
        if (conf.getKeyMapper() instanceof GroupMemberEventListener) {
            GroupMemberEventListener groupListener = (GroupMemberEventListener)((Object)conf.getKeyMapper());
            gs.registerGroupMemberEventListener(groupListener);
        }
        if (conf.getDataStoreEntryHelper() == null) {
            conf.setDataStoreEntryHelper(new DefaultDataStoreEntryHelper(conf.getClassLoader()));
        }
        if (conf.getObjectInputOutputStreamFactory() == null) {
            conf.setObjectInputOutputStreamFactory(new DefaultObjectInputOutputStreamFactory());
        }
        if (conf.getDataStoreKeyHelper() == null) {
            conf.setDataStoreKeyHelper(new ObjectKeyHelper(conf.getClassLoader(), conf.getObjectInputOutputStreamFactory()));
        }
        return new ReplicatedDataStore<K, V>(conf.getStoreName(), gs, conf.getClassLoader(), conf.getDataStoreEntryHelper(), conf.getDataStoreKeyHelper(), conf.getKeyMapper());
    }
}

