/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.Utility;

public abstract class Command<K, V> {
    private byte opcode;
    private DataStoreContext<K, V> dsc;
    private CommandManager<K, V> cm;
    private String targetName;
    private boolean markedForResponseRequired;
    private CommandResponse cr;
    private long tokenId;
    protected Object result;
    private static final byte[] RESP_NOT_REQUIRED = new byte[]{0};
    private static final byte[] RESP_REQUIRED = new byte[]{1};

    protected Command(byte opcode) {
        this.opcode = opcode;
    }

    public void initialize(DataStoreContext<K, V> rs) {
        this.dsc = rs;
        this.cm = rs.getCommandManager();
    }

    protected DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    protected CommandManager<K, V> getCommandManager() {
        return this.cm;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    protected void setTargetName(String val) {
        this.targetName = val;
    }

    protected void prepareToTransmit(DataStoreContext<K, V> ctx) {
    }

    public final void writeCommandState(ReplicationOutputStream bos) throws IOException {
        try {
            bos.write(new byte[]{this.getOpcode()});
            bos.write(this.markedForResponseRequired ? RESP_REQUIRED : RESP_NOT_REQUIRED);
            if (this.markedForResponseRequired) {
                bos.write(Utility.longToBytes(this.cr.getTokenId()));
            }
            this.writeCommandPayload(this.dsc, bos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final void readCommandState(byte[] data, int offset) throws IOException, DataStoreException {
        if (data[offset + 1] != 0) {
            this.markedForResponseRequired = true;
            this.tokenId = Utility.bytesToLong(data, offset + 2);
            offset += 10;
            System.out.println("Just received a command that requires a response for: " + this.tokenId);
        } else {
            offset += 2;
        }
        this.readCommandPayload(this.dsc, data, offset);
    }

    protected abstract Command<K, V> createNewInstance();

    protected abstract void writeCommandPayload(DataStoreContext<K, V> var1, ReplicationOutputStream var2) throws IOException;

    protected abstract void readCommandPayload(DataStoreContext<K, V> var1, byte[] var2, int var3) throws IOException, DataStoreException;

    public abstract void execute(DataStoreContext<K, V> var1);
}

