/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import java.util.List;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.ReplicationFrame;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class ReplicationFramePayloadCommand<K, V>
extends Command<K, V> {
    private ReplicationFrame<K, V> frame;

    public ReplicationFramePayloadCommand() {
        super((byte)51);
    }

    public void setReplicationFrame(ReplicationFrame<K, V> frame) {
        this.frame = frame;
    }

    @Override
    protected ReplicationFramePayloadCommand<K, V> createNewInstance() {
        return new ReplicationFramePayloadCommand<K, V>();
    }

    @Override
    public void writeCommandPayload(DataStoreContext<K, V> trans, ReplicationOutputStream bos) throws IOException {
        bos.write(this.frame.getSerializedData());
    }

    @Override
    public void readCommandPayload(DataStoreContext<K, V> trans, byte[] data, int offset) throws DataStoreException {
        ReplicationFrame<K, V> frame = ReplicationFrame.toReplicationFrame(trans, data, offset);
        this.setReplicationFrame(frame);
    }

    @Override
    public void execute(DataStoreContext<K, V> ctx) {
        List<Command<K, V>> commands = this.frame.getCommands();
        for (Command<K, V> cmd : commands) {
            this.getCommandManager().execute(cmd, false, this.frame.getSourceInstanceName());
        }
    }

    public String toString() {
        return "ReplicationFramePayloadCommand: contains " + this.frame.getCommands().size() + " commands";
    }
}

