/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.command;

import java.io.IOException;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.Utility;

public class TouchCommand<K, V>
extends Command<K, V> {
    private K key;
    private long ts;
    private long version;
    private long ttl;

    public TouchCommand() {
        super((byte)38);
    }

    public TouchCommand(K key, long ts, long version, long ttl) {
        this();
        this.key = key;
        this.ts = ts;
        this.version = version;
        this.ttl = ttl;
    }

    @Override
    protected TouchCommand<K, V> createNewInstance() {
        return new TouchCommand<K, V>();
    }

    @Override
    protected void prepareToTransmit(DataStoreContext<K, V> ctx) {
        this.setTargetName(ctx.getKeyMapper().getMappedInstance(ctx.getGroupName(), this.key));
    }

    @Override
    public void writeCommandPayload(DataStoreContext<K, V> trans, ReplicationOutputStream ros) throws IOException {
        ros.write(Utility.longToBytes(this.ts));
        ros.write(Utility.longToBytes(this.version));
        ros.write(Utility.longToBytes(this.ttl));
        trans.getDataStoreKeyHelper().writeKey(ros, this.key);
    }

    @Override
    public void readCommandPayload(DataStoreContext<K, V> trans, byte[] data, int offset) throws DataStoreException {
        this.ts = Utility.bytesToLong(data, offset);
        this.version = Utility.bytesToLong(data, offset + 8);
        this.ttl = Utility.bytesToLong(data, offset + 16);
        this.key = trans.getDataStoreKeyHelper().readKey(data, offset + 24);
    }

    @Override
    public void execute(DataStoreContext<K, V> ctx) {
        ctx.getReplicaStore().touch(this.key, this.version, this.ts, this.ttl);
    }
}

