/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.CommandManager;

public abstract class ExecutionInterceptor<K, V> {
    private DataStoreContext<K, V> dsc;
    private CommandManager<K, V> cm;
    private ExecutionInterceptor<K, V> next;
    private ExecutionInterceptor<K, V> prev;

    public final void initialize(DataStoreContext<K, V> dsc) {
        this.dsc = dsc;
        this.cm = dsc.getCommandManager();
    }

    public final DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    public CommandManager getCm() {
        return this.cm;
    }

    public final void setNext(ExecutionInterceptor<K, V> next) {
        this.next = next;
    }

    public final void setPrev(ExecutionInterceptor<K, V> prev) {
        this.prev = prev;
    }

    public final ExecutionInterceptor<K, V> getNext() {
        return this.next;
    }

    public final ExecutionInterceptor<K, V> getPrev() {
        return this.prev;
    }

    public void onTransmit(Command<K, V> cmd) {
        ExecutionInterceptor<K, V> n = this.getNext();
        if (n != null) {
            n.onTransmit(cmd);
        }
    }

    public void onReceive(Command<K, V> cmd) {
        ExecutionInterceptor<K, V> p = this.getPrev();
        if (p != null) {
            p.onReceive(cmd);
        } else {
            cmd.execute(this.dsc);
        }
    }
}

