/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.util;

import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.mapper.KeyMapper;

public class DefaultKeyMapper
implements KeyMapper,
GroupMemberEventListener {
    private String myName;
    private String groupName;
    private boolean includeMe;
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock rLock;
    private ReentrantReadWriteLock.WriteLock wLock;
    private volatile TreeSet<String> currentMemberSet = new TreeSet();
    private volatile TreeSet<String> currentMemberSetMinusMe = new TreeSet();
    private volatile String[] currentView = new String[0];
    private volatile String[] previousView = new String[0];
    private volatile String[] currentViewMinusMe = new String[0];
    private volatile String currentViewCausedBy = "";
    private static final String UNMAPPED = "UNMAPPED__" + DefaultKeyMapper.class.getName();
    private boolean debug;

    public DefaultKeyMapper(String myName, String groupName) {
        this.myName = myName;
        this.groupName = groupName;
        this.currentViewCausedBy = myName;
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
        this.registerInstance(myName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMappedInstance(String groupName, Object key1) {
        this.rLock.lock();
        try {
            if (this.currentView.length == 0) {
                String string = UNMAPPED;
                return string;
            }
            int hc = Math.abs(this.getHashCode(key1));
            String mappedInstance = this.currentView[hc % this.currentView.length];
            if (mappedInstance.equals(this.myName)) {
                if (this.currentViewMinusMe.length == 0) {
                    String string = UNMAPPED;
                    return string;
                }
                mappedInstance = this.currentViewMinusMe[hc % this.currentViewMinusMe.length];
            }
            String string = mappedInstance;
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findReplicaInstance(String groupName, Object key1) {
        this.rLock.lock();
        try {
            if (this.currentViewCausedBy.equals(this.myName)) {
                String string = this.getMappedInstance(groupName, key1);
                return string;
            }
            if (this.previousView.length == 0) {
                String string = UNMAPPED;
                return string;
            }
            int hc = Math.abs(this.getHashCode(key1));
            String mappedInstance = this.previousView[hc % this.previousView.length];
            if (this.debug) {
                this.printMemberStates();
            }
            if (mappedInstance.equals(this.currentViewCausedBy)) {
                mappedInstance = this.currentView[hc % this.currentView.length];
                if (this.debug) {
                    System.out.println("REPLICA(*) Key: " + key1 + " => " + hc + ";   " + mappedInstance);
                }
            } else if (this.debug) {
                System.out.println("REPLICA Key: " + key1 + " => " + hc + ";   " + mappedInstance);
            }
            String string = mappedInstance;
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public void memberReady(String instanceName, String groupName) {
        if (this.groupName.equals(groupName)) {
            this.registerInstance(instanceName);
        }
    }

    @Override
    public void memberLeft(String instanceName, String groupName, boolean isShutdown) {
        if (this.groupName.equals(groupName)) {
            this.removeInstance(instanceName);
        }
    }

    private int getHashCode(Object val) {
        int hc = val.hashCode();
        return hc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInstance(String inst) {
        this.wLock.lock();
        try {
            if (!this.currentMemberSet.contains(inst)) {
                this.previousView = this.currentView;
                this.currentMemberSet.add(inst);
                this.currentView = this.currentMemberSet.toArray(new String[0]);
                this.currentViewCausedBy = inst;
                if (!this.currentMemberSetMinusMe.contains(inst) && !inst.equals(this.myName)) {
                    this.currentMemberSetMinusMe.add(inst);
                    this.currentViewMinusMe = this.currentMemberSetMinusMe.toArray(new String[0]);
                }
            }
            this.printMemberStates();
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeInstance(String inst) {
        this.wLock.lock();
        try {
            if (this.currentMemberSet.contains(inst)) {
                this.previousView = this.currentView;
                this.currentViewCausedBy = inst;
                this.currentMemberSet.remove(inst);
                this.currentView = this.currentMemberSet.toArray(new String[0]);
                if (this.currentMemberSetMinusMe.contains(inst) && !inst.equals(this.myName)) {
                    this.currentMemberSetMinusMe.remove(inst);
                    this.currentViewMinusMe = this.currentMemberSetMinusMe.toArray(new String[0]);
                }
            }
            this.printMemberStates();
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void setDebug(boolean val) {
        this.debug = val;
    }

    public void printMemberStates() {
        StringBuilder sbuf = new StringBuilder("**DefaultKeyMapper:: Members[");
        for (String st : this.currentView) {
            sbuf.append("<" + st + "> ");
        }
        sbuf.append("];  PreviousMembers[");
        for (String st : this.previousView) {
            sbuf.append("<" + st + "> ");
        }
        sbuf.append("];  currentViewCausedBy: " + this.currentViewCausedBy);
        System.out.println(sbuf.toString());
    }

    private static class ReplicaState
    implements Comparable<ReplicaState> {
        String name;
        boolean active;

        ReplicaState(String name, boolean b) {
            this.name = name;
            this.active = b;
        }

        @Override
        public int compareTo(ReplicaState s) {
            return this.name.compareTo(s.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            ReplicaState st = (ReplicaState)other;
            return st.name.equals(this.name);
        }

        public String toString() {
            return "<" + this.name + ":" + this.active + ">";
        }
    }
}

