/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.group.gms;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.shoal.ha.cache.impl.util.MessageReceiver;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.group.GroupService;

public class GroupServiceProvider
implements GroupService,
CallBack {
    private static final Logger logger = GMSLogDomain.getLogger((String)"ShoalLogger");
    private String myName;
    private String groupName;
    private Properties configProps = new Properties();
    private GroupManagementService gms;
    private GroupHandle groupHandle;
    private ConcurrentHashMap<String, String> aliveInstances = new ConcurrentHashMap();
    private List<GroupMemberEventListener> listeners = new ArrayList<GroupMemberEventListener>();
    private boolean createdAndJoinedGMSGroup;

    public GroupServiceProvider(String myName, String groupName, boolean startGMS) {
        this.init(myName, groupName, startGMS);
    }

    public void processNotification(Signal notification) {
        block10: {
            block11: {
                block9: {
                    if (!(notification instanceof JoinedAndReadyNotificationSignal)) break block9;
                    JoinedAndReadyNotificationSignal readySignal = (JoinedAndReadyNotificationSignal)notification;
                    String aliveInstanceName = readySignal.getMemberToken();
                    if (this.aliveInstances.putIfAbsent(aliveInstanceName, aliveInstanceName) == null) {
                        this.notifyOnMemberReady(aliveInstanceName);
                    }
                    List currentCoreMembers = readySignal.getCurrentCoreMembers();
                    MemberStates[] states = new MemberStates[currentCoreMembers.size()];
                    int i = 0;
                    for (String instanceName : currentCoreMembers) {
                        states[i] = this.gms.getGroupHandle().getMemberState(instanceName, 6000L, 0L);
                        switch (states[i]) {
                            case READY: 
                            case ALIVEANDREADY: {
                                if (this.aliveInstances.putIfAbsent(aliveInstanceName, aliveInstanceName) != null) break;
                                this.notifyOnMemberReady(aliveInstanceName);
                            }
                        }
                    }
                    break block10;
                }
                if (!(notification instanceof FailureNotificationSignal)) break block11;
                String instanceName = notification.getMemberToken();
                this.aliveInstances.remove(instanceName);
                if (this.myName.equals(instanceName)) break block10;
                for (GroupMemberEventListener listener : this.listeners) {
                    listener.memberLeft(instanceName, this.groupName, false);
                }
                break block10;
            }
            if (notification instanceof PlannedShutdownSignal) {
                String instanceName = notification.getMemberToken();
                PlannedShutdownSignal pss = (PlannedShutdownSignal)notification;
                GMSConstants.shutdownType shutType = pss.getEventSubType();
                this.aliveInstances.remove(instanceName);
                if (!this.myName.equals(instanceName)) {
                    for (GroupMemberEventListener listener : this.listeners) {
                        listener.memberLeft(instanceName, this.groupName, shutType == GMSConstants.shutdownType.GROUP_SHUTDOWN);
                    }
                }
            }
        }
    }

    private void notifyOnMemberReady(String eventCausedBy) {
        for (GroupMemberEventListener listener : this.listeners) {
            listener.memberReady(eventCausedBy, this.groupName);
        }
    }

    private void notifyCurrentAliveMembers() {
        List members = this.gms.getGroupHandle().getCurrentCoreMembers();
        for (String instanceName : members) {
            MemberStates state = this.gms.getGroupHandle().getMemberState(instanceName, 6000L, 0L);
            switch (state) {
                case READY: 
                case ALIVEANDREADY: {
                    if (this.aliveInstances.putIfAbsent(instanceName, instanceName) != null) break;
                    this.notifyOnMemberReady(instanceName);
                }
            }
        }
    }

    private void init(String myName, String groupName, boolean startGMS) {
        try {
            this.gms = GMSFactory.getGMSModule((String)groupName);
        }
        catch (Exception e) {
            logger.severe("GMS module for group " + groupName + " not enabled");
        }
        if (this.gms == null) {
            if (startGMS) {
                logger.info("GroupServiceProvider *CREATING* gms module for group " + groupName);
                GroupManagementService.MemberType memberType = myName.equals("DAS") ? GroupManagementService.MemberType.SPECTATOR : GroupManagementService.MemberType.CORE;
                this.configProps.put(ServiceProviderConfigurationKeys.MULTICASTADDRESS.toString(), System.getProperty("MULTICASTADDRESS", "229.9.1.1"));
                this.configProps.put(ServiceProviderConfigurationKeys.MULTICASTPORT.toString(), (Object)2299);
                logger.info("Is initial host=" + System.getProperty("IS_INITIAL_HOST"));
                this.configProps.put(ServiceProviderConfigurationKeys.IS_BOOTSTRAPPING_NODE.toString(), System.getProperty("IS_INITIAL_HOST", "false"));
                if (System.getProperty("INITIAL_HOST_LIST") != null) {
                    this.configProps.put(ServiceProviderConfigurationKeys.VIRTUAL_MULTICAST_URI_LIST.toString(), (Object)myName.equals("DAS"));
                }
                this.configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_RETRIES.toString(), System.getProperty("MAX_MISSED_HEARTBEATS", "3"));
                this.configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_TIMEOUT.toString(), System.getProperty("HEARTBEAT_FREQUENCY", "2000"));
                String bindInterfaceAddress = System.getProperty("BIND_INTERFACE_ADDRESS");
                if (bindInterfaceAddress != null) {
                    this.configProps.put(ServiceProviderConfigurationKeys.BIND_INTERFACE_ADDRESS.toString(), bindInterfaceAddress);
                }
                this.gms = (GroupManagementService)GMSFactory.startGMSModule((String)myName, (String)groupName, (GroupManagementService.MemberType)memberType, (Properties)this.configProps);
                this.createdAndJoinedGMSGroup = true;
            } else {
                logger.severe("**GroupServiceProvider:: Will not start GMS module for group " + groupName + ". It should have been started by now. But GMS: " + this.gms);
            }
        } else {
            logger.severe("**GroupServiceProvider:: GMS module for group " + groupName + " should have been started by now GMS: " + this.gms);
        }
        if (this.gms == null) {
            throw new IllegalStateException("GMS has not been started yet for group name: " + groupName);
        }
        this.groupHandle = this.gms.getGroupHandle();
        this.myName = myName;
        this.groupName = groupName;
        this.gms.addActionFactory((JoinNotificationActionFactory)new JoinNotificationActionFactoryImpl((CallBack)this));
        this.gms.addActionFactory((JoinedAndReadyNotificationActionFactory)new JoinedAndReadyNotificationActionFactoryImpl((CallBack)this));
        this.gms.addActionFactory((FailureNotificationActionFactory)new FailureNotificationActionFactoryImpl((CallBack)this));
        this.gms.addActionFactory((PlannedShutdownActionFactory)new PlannedShutdownActionFactoryImpl((CallBack)this));
        logger.info("**GroupServiceProvider:: REGISTERED member event listeners for <group, instance> => <" + groupName + ", " + myName + ">");
        if (this.createdAndJoinedGMSGroup) {
            try {
                this.gms.join();
                Thread.sleep(3000L);
                this.gms.reportJoinedAndReadyState(groupName);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public List<String> getCurrentCoreMembers() {
        return this.groupHandle.getCurrentCoreMembers();
    }

    public void shutdown() {
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getMemberName() {
        return this.myName;
    }

    @Override
    public boolean sendMessage(String targetMemberName, String token, byte[] data) {
        try {
            this.groupHandle.sendMessage(targetMemberName, token, data);
            return true;
        }
        catch (GMSException gmsEx) {
            return false;
        }
    }

    @Override
    public void registerGroupMessageReceiver(String messageToken, MessageReceiver receiver) {
        logger.fine("[GroupServiceProvider]:  REGISTERED A MESSAGE LISTENER: " + receiver + "; for token: " + messageToken);
        this.gms.addActionFactory((MessageActionFactory)new MessageActionFactoryImpl((CallBack)receiver), messageToken);
    }

    @Override
    public void registerGroupMemberEventListener(GroupMemberEventListener listener) {
        this.listeners.add(listener);
        this.notifyCurrentAliveMembers();
    }

    @Override
    public void removeGroupMemberEventListener(GroupMemberEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() {
        if (this.createdAndJoinedGMSGroup) {
            this.shutdown();
        }
    }
}

