/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.backup.LoggerHelper;
import com.sun.enterprise.backup.Status;
import com.sun.enterprise.backup.ZipFilenameFilter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

class BackupFilenameManager {
    private File dir;
    private String domainName;
    private String desc;
    private ZipFileAndNumber[] zipsAndNumbers;
    private ZipFileAndNumber latestVersion;

    BackupFilenameManager(File backupDir, String domainName) throws BackupException {
        this.dir = backupDir;
        this.domainName = domainName;
        this.findZips();
        this.findLatest();
    }

    File next() throws BackupException {
        int newVersionNum = 1;
        if (this.latestVersion != null) {
            newVersionNum = this.latestVersion.num + 1;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy_MM_dd");
        Date date = new Date();
        String fname = this.domainName + "_" + formatter.format(date) + "_v";
        String suffix = this.padWithLeadingZeroes(newVersionNum);
        this.desc = this.domainName + " backup created on " + formatter.format(date) + " by user " + System.getProperty("user.name");
        return new File(this.dir, fname + suffix + ".zip");
    }

    File latest() throws BackupWarningException {
        if (this.latestVersion == null) {
            throw new BackupWarningException("backup-res.NoBackupFiles", this.dir);
        }
        return this.latestVersion.zip;
    }

    private void findZips() throws BackupWarningException {
        File[] zips = this.dir.listFiles(new ZipFilenameFilter());
        int len = 0;
        if (zips != null) {
            len = zips.length;
        }
        this.zipsAndNumbers = new ZipFileAndNumber[len];
        for (int i = 0; i < len; ++i) {
            this.zipsAndNumbers[i] = new ZipFileAndNumber(zips[i]);
        }
    }

    private void findLatest() throws BackupWarningException {
        int biggest = 0;
        for (int i = 0; i < this.zipsAndNumbers.length; ++i) {
            int curr = this.zipsAndNumbers[i].num;
            if (curr <= biggest) continue;
            biggest = curr;
            this.latestVersion = this.zipsAndNumbers[i];
            LoggerHelper.fine(this.zipsAndNumbers[i].zip.toString() + " newest backup so far...");
        }
    }

    private String padWithLeadingZeroes(int num) throws BackupException {
        if (num < 10) {
            return "0000" + num;
        }
        if (num < 100) {
            return "000" + num;
        }
        if (num < 1000) {
            return "00" + num;
        }
        if (num < 10000) {
            return "0" + num;
        }
        if (num < 100000) {
            return "" + num;
        }
        throw new BackupException("Latest version >= 100,000.  Delete some backup files.");
    }

    public String getCustomizedDescription() {
        return this.desc;
    }

    public static void main(String[] args) {
        try {
            File f = new File("c:/tmp/test");
            BackupFilenameManager mgr = new BackupFilenameManager(f, "foo");
            File fnew = mgr.next();
            System.out.println("Next backup file: " + fnew);
            File fold = mgr.latest();
            System.out.println("Latest backup file: " + fold);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ZipFileAndNumber {
        private File zip;
        private int num = -1;

        private ZipFileAndNumber(File zip) {
            this.zip = zip;
            String fname = zip.getName();
            if (this.isValid()) {
                fname = fname.substring(fname.lastIndexOf("_v") + 2, fname.length() - 4);
                try {
                    this.num = Integer.parseInt(fname);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private boolean isValid() {
            Status status = new Status();
            long time = status.getInternalTimestamp(this.zip);
            return time > 0L;
        }
    }
}

