/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.security.Principal;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.session.StandardSession;

public class SingleSignOnEntry {
    private static final Logger log = Logger.getLogger(SingleSignOnEntry.class.getName());
    public String id = null;
    public String authType = null;
    public char[] password = null;
    public Principal principal = null;
    public Session[] sessions = new Session[0];
    public String username = null;
    public String realmName = null;
    public long lastAccessTime;

    public SingleSignOnEntry(String id, Principal principal, String authType, String username, char[] password, String realmName) {
        this.id = id;
        this.principal = principal;
        this.authType = authType;
        this.username = username;
        this.password = password != null ? (char[])password.clone() : null;
        this.realmName = realmName;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public synchronized boolean addSession(SingleSignOn sso, Session session) {
        for (int i = 0; i < this.sessions.length; ++i) {
            if (session != this.sessions[i]) continue;
            return false;
        }
        Session[] results = new Session[this.sessions.length + 1];
        System.arraycopy(this.sessions, 0, results, 0, this.sessions.length);
        results[this.sessions.length] = session;
        this.sessions = results;
        session.addSessionListener(sso);
        return true;
    }

    public synchronized void removeSession(Session session) {
        Session[] nsessions = new Session[this.sessions.length - 1];
        int j = 0;
        for (int i = 0; i < this.sessions.length; ++i) {
            if (session == this.sessions[i]) continue;
            nsessions[j++] = this.sessions[i];
        }
        this.sessions = nsessions;
    }

    public synchronized boolean isEmpty() {
        return this.sessions.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void expireSessions(HashMap reverse) {
        for (int i = 0; i < this.sessions.length; ++i) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(" Invalidating session " + this.sessions[i]);
            }
            HashMap hashMap = reverse;
            synchronized (hashMap) {
                reverse.remove(this.sessions[i]);
            }
            if (!((StandardSession)this.sessions[i]).getIsValid()) continue;
            this.sessions[i].expire();
        }
    }
}

