/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.FileCache;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.DataStructures;
import java.net.InetAddress;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCacheFactory {
    public int secondsMaxAge = -1;
    public int maxCacheEntries = 1024;
    public long minEntrySize = 2048L;
    public long maxEntrySize = 537600L;
    public long maxLargeFileCacheSize = 0xA00000L;
    public long maxSmallFileCacheSize = 0x100000L;
    public boolean isEnabled = true;
    public boolean isLargeFileCacheEnabled = true;
    public int port = 8080;
    public InetAddress address;
    protected static final ConcurrentHashMap<Integer, FileCacheFactory> cache = new ConcurrentHashMap();
    protected Queue<FileCache.FileCacheEntry> cacheManager;
    protected boolean isMonitoringEnabled = false;
    protected FileCache fileCache;
    private int headerBBSize = 4096;
    private static Class<? extends FileCache> fileCacheClass = FileCache.class;

    protected FileCacheFactory() {
    }

    public static FileCacheFactory newInstance(InetAddress currentAddress, int currentPort, Class<? extends FileCache> fcc) {
        FileCacheFactory fileCacheFactory = new FileCacheFactory();
        fileCacheFactory.port = currentPort;
        fileCacheFactory.address = currentAddress;
        int addressHash = FileCacheFactory.getAddressHash(currentAddress);
        cache.put(addressHash + currentPort, fileCacheFactory);
        Queue cacheManager = DataStructures.getCLQinstance(FileCache.FileCacheEntry.class);
        fileCacheFactory.setCacheManager(cacheManager);
        fileCacheClass = fcc;
        return fileCacheFactory;
    }

    public static FileCacheFactory getFactory(InetAddress currentAddress, int currentPort) {
        return FileCacheFactory.getFactory(currentAddress, currentPort, fileCacheClass);
    }

    public static FileCacheFactory getFactory(InetAddress currentAddress, int currentPort, Class<? extends FileCache> fcc) {
        int addressHash = FileCacheFactory.getAddressHash(currentAddress);
        FileCacheFactory fileCacheFactory = cache.get(addressHash + currentPort);
        if (fileCacheFactory == null) {
            fileCacheFactory = FileCacheFactory.newInstance(currentAddress, currentPort, fcc);
        }
        return fileCacheFactory;
    }

    public FileCache getFileCache() {
        if (this.fileCache == null) {
            this.fileCache = this.createFileCache();
            this.configureFileCache();
        }
        return this.fileCache;
    }

    protected FileCache createFileCache() {
        try {
            this.fileCache = fileCacheClass.newInstance();
        }
        catch (InstantiationException ex) {
            SelectorThread.logger().severe(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            SelectorThread.logger().severe(ex.getMessage());
        }
        return this.fileCache;
    }

    protected void configureFileCache() {
        this.fileCache.setIsEnabled(this.isEnabled);
        this.fileCache.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
        this.fileCache.setSecondsMaxAge(this.secondsMaxAge);
        this.fileCache.setMaxCacheEntries(this.maxCacheEntries);
        this.fileCache.setMinEntrySize(this.minEntrySize);
        this.fileCache.setMaxEntrySize(this.maxEntrySize);
        this.fileCache.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
        this.fileCache.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
        this.fileCache.setCacheManager(this.cacheManager);
        this.fileCache.setIsMonitoringEnabled(this.isMonitoringEnabled);
        this.fileCache.setHeaderBBSize(this.headerBBSize);
        this.fileCache.setPort(this.port);
        this.fileCache.setAddress(this.address);
    }

    public void setCacheManager(Queue<FileCache.FileCacheEntry> cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Map<String, FileCache.FileCacheEntry> getCache() {
        if (this.fileCache != null) {
            return this.fileCache.getCache();
        }
        return null;
    }

    public int getFlagEnabled() {
        return this.isEnabled ? 1 : 0;
    }

    public int getSecondsMaxAge() {
        return this.secondsMaxAge;
    }

    public long getCountEntries() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountEntries();
    }

    public long getMaxEntries() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.maxCacheEntries;
    }

    public long getCountOpenEntries() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountOpenEntries();
    }

    public long getMaxOpenEntries() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getMaxOpenEntries();
    }

    public long getSizeHeapCache() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getSizeHeapCache();
    }

    public long getMaxHeapCacheSize() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getMaxHeapCacheSize();
    }

    public long getSizeMmapCache() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getSizeMmapCache();
    }

    public long getMaxMmapCacheSize() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getMaxMmapCacheSize();
    }

    public long getCountHits() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountHits();
    }

    public long getCountMisses() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountMisses();
    }

    public long getCountInfoHits() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountInfoHits();
    }

    public long getCountInfoMisses() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountInfoMisses();
    }

    public long getCountContentHits() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountContentHits();
    }

    public long getCountContentMisses() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountContentMisses();
    }

    public void setIsMonitoringEnabled(boolean isMonitoringEnabled) {
        this.isMonitoringEnabled = isMonitoringEnabled;
        if (this.fileCache != null) {
            this.fileCache.setIsMonitoringEnabled(isMonitoringEnabled);
        }
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isE) {
        this.isEnabled = isE;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public int getHeaderBBSize() {
        return this.headerBBSize;
    }

    public void setHeaderBBSize(int headerBBSize) {
        this.headerBBSize = headerBBSize;
    }

    private static int getAddressHash(InetAddress currentAddress) {
        return currentAddress != null ? currentAddress.hashCode() : 0;
    }
}

