/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.ws;

import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class WLWebServiceEndpointNode
extends DeploymentDescriptorNode {
    private WebServiceEndpoint descriptor = null;
    private static final XMLElement tag = new XMLElement("port-component");

    public WLWebServiceEndpointNode() {
        this.registerElementHandler(new XMLElement("wsdl"), WSDLNode.class);
    }

    protected XMLElement getXMLRootTag() {
        return tag;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("stream-attachments", "setStreamAttachments");
        table.put("validate-request", "setValidateRequest");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        String elementName = element.getQName();
        if ("port-component-name".equals(elementName)) {
            WebService webservice = (WebService)this.getParentNode().getDescriptor();
            this.descriptor = webservice.getEndpointByName(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public XMLNode getHandlerFor(XMLElement element) {
        String elementName = element.getQName();
        WSDLNode node = null;
        if ("wsdl".equals(elementName)) {
            node = new WSDLNode(this.descriptor);
            node.setParentNode(this);
        }
        return node;
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    public Node writeDescriptor(Node parent, String nodeName, WebServiceEndpoint descriptor) {
        Node wseNode = super.writeDescriptor(parent, nodeName, descriptor);
        WLWebServiceEndpointNode.appendTextChild(wseNode, "port-component-name", descriptor.getEndpointName());
        if (descriptor.getWsdlExposed() != null) {
            new WSDLNode(descriptor).writeDescriptor(wseNode, descriptor);
        }
        if (descriptor.getStreamAttachments() != null) {
            WLWebServiceEndpointNode.appendTextChild(wseNode, "stream-attachments", descriptor.getStreamAttachments());
        }
        if (descriptor.getValidateRequest() != null) {
            WLWebServiceEndpointNode.appendTextChild(wseNode, "validate-request", descriptor.getValidateRequest());
        }
        return wseNode;
    }

    public static class WSDLNode
    extends DeploymentDescriptorNode {
        private final XMLElement tag = new XMLElement("wsdl");
        WebServiceEndpoint descriptor;

        public WSDLNode(WebServiceEndpoint descriptor) {
            this.descriptor = descriptor;
        }

        protected XMLElement getXMLRootTag() {
            return this.tag;
        }

        public Object getDescriptor() {
            return this.descriptor;
        }

        protected Map getDispatchTable() {
            Map table = super.getDispatchTable();
            table.put("exposed", "setWsdlExposed");
            return table;
        }

        public Node writeDescriptor(Node parent, WebServiceEndpoint descriptor) {
            if (descriptor.getWsdlExposed() != null) {
                Document doc = WSDLNode.getOwnerDocument(parent);
                Element wsdl = doc.createElement("wsdl");
                Element exposed = doc.createElement("exposed");
                exposed.appendChild(doc.createTextNode(descriptor.getWsdlExposed()));
                wsdl.appendChild(exposed);
                parent.appendChild(wsdl);
                return wsdl;
            }
            return null;
        }
    }
}

