/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web;

import com.sun.enterprise.security.web.SingleSignOnMBean;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.SingleSignOnEntry;

public class GlassFishSingleSignOn
extends SingleSignOn
implements SessionListener,
Runnable,
SingleSignOnMBean {
    private static final Logger logger = LogDomains.getLogger(GlassFishSingleSignOn.class, (String)"javax.enterprise.system.container.web");
    private Thread thread = null;
    private boolean threadDone = false;
    private int ssoReapInterval = 60;
    private int ssoMaxInactive = 300;
    private AtomicInteger hitCount = new AtomicInteger(0);
    private AtomicInteger missCount = new AtomicInteger(0);

    public int getReapInterval() {
        return this.ssoReapInterval;
    }

    public void setReapInterval(int t) {
        this.ssoReapInterval = t;
    }

    public int getMaxInactive() {
        return this.ssoMaxInactive;
    }

    public void setMaxInactive(int t) {
        this.ssoMaxInactive = t;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        super.start();
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.threadStop();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Process session destroyed on " + session);
        }
        String ssoId = null;
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            return;
        }
        if (session.hasExpired()) {
            this.removeSession(ssoId, session);
        } else {
            this.deregister(ssoId);
        }
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        Cookie[] cookies;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        request.removeNote("org.apache.catalina.request.SSOID");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Process request for '" + hreq.getRequestURI() + "'");
        }
        if (hreq.getUserPrincipal() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Principal '" + hreq.getUserPrincipal().getName() + "' has already been authenticated");
            }
            return 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Checking for SSO cookie");
        }
        if ((cookies = hreq.getCookies()) == null) {
            return 1;
        }
        Cookie cookie = null;
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" SSO cookie is not present");
            }
            return 1;
        }
        Realm realm = request.getContext().getRealm();
        if (realm == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        String realmName = realm.getRealmName();
        if (realmName == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" No realm configured for this application, SSO does not apply.");
            }
            return 1;
        }
        if (this.debug >= 1 && logger.isLoggable(Level.FINE)) {
            logger.fine("This application uses realm '" + realmName + "'");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Checking for cached principal for " + cookie.getValue());
        }
        if ((entry = this.lookupEntry(cookie.getValue())) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "' in realm '" + entry.realmName + "'");
            }
            if (entry.realmName.equals(realmName)) {
                request.setNote("org.apache.catalina.request.SSOID", (Object)cookie.getValue());
                ((HttpRequest)request).setAuthType(entry.authType);
                ((HttpRequest)request).setUserPrincipal(entry.principal);
                entry.lastAccessTime = System.currentTimeMillis();
                this.hitCount.incrementAndGet();
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Ignoring SSO entry which does not match application realm '" + realmName + "'");
                }
                this.missCount.incrementAndGet();
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            hres.addCookie(cookie);
            this.missCount.incrementAndGet();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String ssoId, Session session) {
        boolean wasAdded;
        SingleSignOnEntry sso;
        if (!this.started) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Associate sso id " + ssoId + " with session " + session);
        }
        if ((sso = this.lookupEntry(ssoId)) != null && (wasAdded = sso.addSession((SingleSignOn)this, session))) {
            HashMap hashMap = this.reverse;
            synchronized (hashMap) {
                this.reverse.put(session, ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.lookupEntry(ssoId);
        if (sso == null) {
            return;
        }
        sso.removeSession(session);
        if (sso.isEmpty()) {
            HashMap hashMap2 = this.cache;
            synchronized (hashMap2) {
                sso = (SingleSignOnEntry)this.cache.remove(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deregistering sso id '" + ssoId + "'");
        }
        SingleSignOnEntry sso = null;
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        sso.expireSessions(this.reverse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, char[] password, String realmName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Registering sso id '" + ssoId + "' for user '" + principal.getName() + " in realm " + realmName + "' with auth type '" + authType + "'");
        }
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, new SingleSignOnEntry(ssoId, principal, authType, username, password, realmName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookupEntry(String ssoId) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            return (SingleSignOnEntry)this.cache.get(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpires() {
        if (this.ssoMaxInactive < 0) {
            return;
        }
        long tooOld = System.currentTimeMillis() - (long)this.ssoMaxInactive * 1000L;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SSO expiration started. Current entries: " + this.cache.size());
        }
        ArrayList<String> removals = new ArrayList<String>(this.cache.size() / 2);
        try {
            HashMap hashMap = this.cache;
            synchronized (hashMap) {
                for (String key : this.cache.keySet()) {
                    SingleSignOnEntry sso = (SingleSignOnEntry)this.cache.get(key);
                    if (sso.sessions.length != 0 || sso.lastAccessTime >= tooOld) continue;
                    removals.add(key);
                }
            }
            int removalCount = removals.size();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SSO cache will expire " + removalCount + " entries.");
            }
            for (int i = 0; i < removalCount; ++i) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("SSO expiration removing entry: " + removals.get(i));
                }
                this.deregister((String)removals.get(i));
            }
        }
        catch (Throwable e) {
            logger.warning("Caught exception during SingleSignOn expiration: " + e);
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.ssoReapInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "SingleSignOnExpiration";
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing session " + session.toString() + " from sso id " + ssoId);
        }
        if ((entry = this.lookupEntry(ssoId)) == null) {
            return;
        }
        entry.removeSession(session);
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.remove(session);
        }
        if (entry.isEmpty()) {
            this.deregister(ssoId);
        }
    }

    public int getActiveSessionCount() {
        return this.cache.size();
    }

    public int getHitCount() {
        return this.hitCount.intValue();
    }

    public int getMissCount() {
        return this.missCount.intValue();
    }
}

