/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.BTraceRuntime;
import com.sun.btrace.annotations.Export;
import com.sun.btrace.annotations.Property;
import com.sun.btrace.annotations.TLS;
import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.Attribute;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.FieldVisitor;
import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.ClassRenamer;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import com.sun.btrace.util.NullVisitor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Preprocessor
extends ClassAdapter {
    public static final String JAVA_LANG_THREAD_LOCAL_DESC = "Ljava/lang/ThreadLocal;";
    public static final String BTRACE_EXPORT_DESC = Type.getDescriptor(Export.class);
    public static final String BTRACE_TLS_DESC = Type.getDescriptor(TLS.class);
    public static final String BTRACE_PROPERTY_DESC = Type.getDescriptor(Property.class);
    public static final String BTRACE_PROPERTY_NAME = "name";
    public static final String BTRACE_PROPERTY_DESCRIPTION = "description";
    public static final String BTRACE_RUNTIME = Type.getInternalName(BTraceRuntime.class);
    public static final String BTRACE_RUNTIME_DESC = Type.getDescriptor(BTraceRuntime.class);
    public static final String BTRACE_RUNTIME_FIELD_NAME = "runtime";
    public static final String BTRACE_FIELD_PREFIX = "$";
    public static final String BTRACE_RUNTIME_HANDLE_EXCEPTION;
    public static final String BTRACE_RUNTIME_HANDLE_EXCEPTION_DESC;
    public static final String BTRACE_RUNTIME_ENTER;
    public static final String BTRACE_RUNTIME_ENTER_DESC;
    public static final String BTRACE_RUNTIME_LEAVE;
    public static final String BTRACE_RUNTIME_LEAVE_DESC;
    public static final String BTRACE_RUNTIME_START;
    public static final String BTRACE_RUNTIME_START_DESC;
    public static final String BTRACE_RUNTIME_FOR_CLASS;
    public static final String BTRACE_RUNTIME_FOR_CLASS_DESC;
    public static final String BTRACE_RUNTIME_NEW_THREAD_LOCAL;
    public static final String BTRACE_RUNTIME_NEW_THREAD_LOCAL_DESC;
    public static final String BTRACE_RUNTIME_NEW_PERFCOUNTER;
    public static final String BTRACE_RUNTIME_NEW_PERFCOUNTER_DESC;
    public static final String BTRACE_RUNTIME_GET_PERFSTRING;
    public static final String BTRACE_RUNTIME_GET_PERFSTRING_DESC;
    public static final String BTRACE_RUNTIME_GET_PERFINT;
    public static final String BTRACE_RUNTIME_GET_PERFINT_DESC;
    public static final String BTRACE_RUNTIME_GET_PERFLONG;
    public static final String BTRACE_RUNTIME_GET_PERFLONG_DESC;
    public static final String BTRACE_RUNTIME_GET_PERFFLOAT;
    public static final String BTRACE_RUNTIME_GET_PERFFLOAT_DESC;
    public static final String BTRACE_RUNTIME_GET_PERFDOUBLE;
    public static final String BTRACE_RUNTIME_GET_PERFDOUBLE_DESC;
    public static final String BTRACE_RUNTIME_PUT_PERFSTRING;
    public static final String BTRACE_RUNTIME_PUT_PERFSTRING_DESC;
    public static final String BTRACE_RUNTIME_PUT_PERFINT;
    public static final String BTRACE_RUNTIME_PUT_PERFINT_DESC;
    public static final String BTRACE_RUNTIME_PUT_PERFLONG;
    public static final String BTRACE_RUNTIME_PUT_PERFLONG_DESC;
    public static final String BTRACE_RUNTIME_PUT_PERFFLOAT;
    public static final String BTRACE_RUNTIME_PUT_PERFFLOAT_DESC;
    public static final String BTRACE_RUNTIME_PUT_PERFDOUBLE;
    public static final String BTRACE_RUNTIME_PUT_PERFDOUBLE_DESC;
    private String className;
    private String externalClassName;
    private Type classType;
    private List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
    private Map<String, FieldDescriptor> threadLocalFields = new HashMap<String, FieldDescriptor>();
    private Map<String, FieldDescriptor> exportFields = new HashMap<String, FieldDescriptor>();
    private boolean classInitializerFound;
    private static final String BTRACE_COUNTER_PREFIX = "btrace.";

    public Preprocessor(ClassVisitor cv) {
        super(cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.classType = Type.getObjectType(this.className);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return super.visitAnnotation(desc, visible);
    }

    private String externalClassName() {
        if (this.externalClassName == null) {
            this.externalClassName = this.className.replace('/', '.');
        }
        return this.externalClassName;
    }

    private String perfCounterName(String fieldName) {
        return BTRACE_COUNTER_PREFIX + this.externalClassName() + "." + fieldName;
    }

    @Override
    public FieldVisitor visitField(final int access, final String name, final String desc, final String signature, final Object value) {
        final ArrayList attrs = new ArrayList();
        return new FieldVisitor(){
            boolean isExport;
            boolean isThreadLocal;
            boolean isProperty;
            String propName = "";
            String propDescription = "";

            @Override
            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                if (desc2.equals(BTRACE_TLS_DESC)) {
                    this.isThreadLocal = true;
                } else if (desc2.equals(BTRACE_EXPORT_DESC)) {
                    this.isExport = true;
                } else if (desc2.equals(BTRACE_PROPERTY_DESC)) {
                    this.isProperty = true;
                    return new NullVisitor(){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals(Preprocessor.BTRACE_PROPERTY_NAME)) {
                                propName = value.toString();
                            } else if (name.equals(Preprocessor.BTRACE_PROPERTY_DESCRIPTION)) {
                                propDescription = value.toString();
                            }
                        }
                    };
                }
                return new NullVisitor();
            }

            @Override
            public void visitAttribute(Attribute attr) {
                attrs.add(attr);
            }

            @Override
            public void visitEnd() {
                FieldDescriptor fd = new FieldDescriptor(access, name, desc, signature, value, attrs, this.isThreadLocal, this.isExport, this.isProperty, this.propName, this.propDescription);
                Preprocessor.this.fields.add(fd);
                if (this.isThreadLocal) {
                    Preprocessor.this.threadLocalFields.put(name, fd);
                } else if (this.isExport) {
                    Preprocessor.this.exportFields.put(name, fd);
                }
            }
        };
    }

    @Override
    public void visitEnd() {
        if (!this.classInitializerFound) {
            MethodVisitor clinit = this.visitMethod(9, "<clinit>", "()V", null, null);
            clinit.visitCode();
            clinit.visitInsn(177);
            clinit.visitMaxs(0, 0);
            clinit.visitEnd();
        }
        this.addFields();
        super.visitEnd();
    }

    private void addFields() {
        for (FieldDescriptor fd : this.fields) {
            AnnotationVisitor av;
            String fieldName = fd.name;
            if (fd.isExport) continue;
            int fieldAccess = fd.access;
            String fieldDesc = fd.desc;
            String fieldSignature = fd.signature;
            Object fieldValue = fd.value;
            if (fd.isThreadLocal) {
                fieldAccess &= 0xFFFFFFEF;
                fieldDesc = JAVA_LANG_THREAD_LOCAL_DESC;
                fieldSignature = null;
                fieldValue = null;
            }
            fieldAccess &= 0xFFFFFFFD;
            fieldAccess &= 0xFFFFFFFB;
            FieldVisitor fv = super.visitField(fieldAccess |= 1, BTRACE_FIELD_PREFIX + fieldName, fieldDesc, fieldSignature, fieldValue);
            if (fd.isProperty && (av = fv.visitAnnotation(BTRACE_PROPERTY_DESC, true)) != null) {
                av.visit(BTRACE_PROPERTY_NAME, fd.propertyName);
                av.visit(BTRACE_PROPERTY_DESCRIPTION, fd.propertyDescription);
            }
            for (Attribute attr : fd.attributes) {
                fv.visitAttribute(attr);
            }
            fv.visitEnd();
        }
        super.visitField(9, BTRACE_RUNTIME_FIELD_NAME, BTRACE_RUNTIME_DESC, null, null);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean isClassInitializer;
        if (name.equals("<init>")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodVisitor adaptee = super.visitMethod(access, name, desc, signature, exceptions);
        this.classInitializerFound = isClassInitializer = name.equals("<clinit>");
        return new MethodInstrumentor(adaptee, access, name, desc){
            private Label start;
            private Label handler;
            private int nextVar;
            {
                super(x0, x1, x2, x3);
                this.start = new Label();
                this.handler = new Label();
                this.nextVar = 0;
            }

            private void generateExportGet(String name, String desc) {
                char typeCode = desc.charAt(0);
                switch (typeCode) {
                    case '[': {
                        this.visitInsn(1);
                        break;
                    }
                    case 'L': {
                        if (desc.equals(JAVA_LANG_STRING_DESC)) {
                            this.visitLdcInsn(name);
                            this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_GET_PERFSTRING, BTRACE_RUNTIME_GET_PERFSTRING_DESC);
                            break;
                        }
                        this.visitInsn(1);
                        break;
                    }
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        this.visitLdcInsn(name);
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_GET_PERFINT, BTRACE_RUNTIME_GET_PERFINT_DESC);
                        break;
                    }
                    case 'J': {
                        this.visitLdcInsn(name);
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_GET_PERFLONG, BTRACE_RUNTIME_GET_PERFLONG_DESC);
                        break;
                    }
                    case 'F': {
                        this.visitLdcInsn(name);
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_GET_PERFFLOAT, BTRACE_RUNTIME_GET_PERFFLOAT_DESC);
                        break;
                    }
                    case 'D': {
                        this.visitLdcInsn(name);
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_GET_PERFDOUBLE, BTRACE_RUNTIME_GET_PERFDOUBLE_DESC);
                    }
                }
            }

            private void generateExportPut(String name, String desc) {
                char typeCode = desc.charAt(0);
                switch (typeCode) {
                    case '[': {
                        this.visitInsn(87);
                        break;
                    }
                    case 'L': {
                        if (desc.equals(JAVA_LANG_STRING_DESC)) {
                            this.visitLdcInsn(name);
                            this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_PUT_PERFSTRING, BTRACE_RUNTIME_PUT_PERFSTRING_DESC);
                            break;
                        }
                        this.visitInsn(87);
                        break;
                    }
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        this.visitLdcInsn(name);
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_PUT_PERFINT, BTRACE_RUNTIME_PUT_PERFINT_DESC);
                        break;
                    }
                    case 'J': {
                        this.visitLdcInsn(name);
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_PUT_PERFLONG, BTRACE_RUNTIME_PUT_PERFLONG_DESC);
                        break;
                    }
                    case 'F': {
                        this.visitLdcInsn(name);
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_PUT_PERFFLOAT, BTRACE_RUNTIME_PUT_PERFFLOAT_DESC);
                        break;
                    }
                    case 'D': {
                        this.visitLdcInsn(name);
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_PUT_PERFDOUBLE, BTRACE_RUNTIME_PUT_PERFDOUBLE_DESC);
                    }
                }
            }

            private void generateThreadLocalGet(FieldDescriptor fd) {
                if (isClassInitializer) {
                    if (fd.initialized) {
                        super.visitVarInsn(Type.getType(fd.desc).getOpcode(21), fd.var);
                    } else if (fd.value != null) {
                        this.visitLdcInsn(fd.value);
                    } else {
                        this.defaultValue(fd.desc);
                    }
                } else {
                    String fieldName = Preprocessor.BTRACE_FIELD_PREFIX + fd.name;
                    super.visitFieldInsn(178, Preprocessor.this.className, fieldName, Preprocessor.JAVA_LANG_THREAD_LOCAL_DESC);
                    this.visitMethodInsn(182, JAVA_LANG_THREAD_LOCAL, "get", "()Ljava/lang/Object;");
                    this.unbox(fd.desc);
                }
            }

            private void generateThreadLocalPut(FieldDescriptor fd) {
                if (isClassInitializer) {
                    super.visitVarInsn(Type.getType(fd.desc).getOpcode(54), fd.var);
                    fd.initialized = true;
                } else {
                    String fieldName = Preprocessor.BTRACE_FIELD_PREFIX + fd.name;
                    this.box(fd.desc);
                    super.visitFieldInsn(178, Preprocessor.this.className, fieldName, Preprocessor.JAVA_LANG_THREAD_LOCAL_DESC);
                    this.visitInsn(95);
                    this.visitMethodInsn(182, JAVA_LANG_THREAD_LOCAL, "set", "(Ljava/lang/Object;)V");
                }
            }

            @Override
            public void visitCode() {
                this.visitTryCatchBlock(this.start, this.handler, this.handler, Constants.JAVA_LANG_THROWABLE);
                if (isClassInitializer) {
                    this.visitLdcInsn(Preprocessor.this.classType);
                    this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_FOR_CLASS, BTRACE_RUNTIME_FOR_CLASS_DESC);
                    super.visitFieldInsn(179, Preprocessor.this.className, Preprocessor.BTRACE_RUNTIME_FIELD_NAME, BTRACE_RUNTIME_DESC);
                }
                this.visitFieldInsn(178, Preprocessor.this.className, Preprocessor.BTRACE_RUNTIME_FIELD_NAME, BTRACE_RUNTIME_DESC);
                this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_ENTER, BTRACE_RUNTIME_ENTER_DESC);
                if (isClassInitializer) {
                    for (FieldDescriptor fd : Preprocessor.this.threadLocalFields.values()) {
                        fd.var = this.nextVar;
                        this.nextVar += Type.getType(fd.desc).getSize();
                    }
                    for (FieldDescriptor fd : Preprocessor.this.exportFields.values()) {
                        this.visitLdcInsn(Preprocessor.this.perfCounterName(fd.name));
                        this.visitLdcInsn(fd.desc);
                        if (fd.value == null) {
                            this.visitInsn(1);
                        } else {
                            this.visitLdcInsn(fd.value);
                            this.box(fd.desc);
                        }
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_NEW_PERFCOUNTER, BTRACE_RUNTIME_NEW_PERFCOUNTER_DESC);
                    }
                }
                this.visitJumpInsn(154, this.start);
                super.visitInsn(177);
                this.visitLabel(this.start);
                super.visitCode();
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                String fieldName = name;
                if (owner.equals(Preprocessor.this.className)) {
                    FieldDescriptor fd;
                    if (Preprocessor.this.exportFields.get(name) != null) {
                        if (opcode == 178) {
                            this.generateExportGet(Preprocessor.this.perfCounterName(name), desc);
                        } else {
                            this.generateExportPut(Preprocessor.this.perfCounterName(name), desc);
                        }
                        return;
                    }
                    if (!name.equals(Preprocessor.BTRACE_RUNTIME_FIELD_NAME)) {
                        fieldName = Preprocessor.BTRACE_FIELD_PREFIX + name;
                    }
                    if ((fd = (FieldDescriptor)Preprocessor.this.threadLocalFields.get(name)) != null) {
                        if (opcode == 178) {
                            this.generateThreadLocalGet(fd);
                        } else {
                            this.generateThreadLocalPut(fd);
                        }
                        return;
                    }
                }
                super.visitFieldInsn(opcode, owner, fieldName, desc);
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, var + this.nextVar);
            }

            @Override
            public void visitInsn(int opcode) {
                if (opcode == 177) {
                    if (isClassInitializer) {
                        for (FieldDescriptor fd : Preprocessor.this.threadLocalFields.values()) {
                            this.generateThreadLocalGet(fd);
                            this.box(fd.desc);
                            this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_NEW_THREAD_LOCAL, BTRACE_RUNTIME_NEW_THREAD_LOCAL_DESC);
                            super.visitFieldInsn(179, Preprocessor.this.className, Preprocessor.BTRACE_FIELD_PREFIX + fd.name, Preprocessor.JAVA_LANG_THREAD_LOCAL_DESC);
                        }
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_START, BTRACE_RUNTIME_START_DESC);
                    } else {
                        this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_LEAVE, BTRACE_RUNTIME_LEAVE_DESC);
                    }
                }
                super.visitInsn(opcode);
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                this.visitLabel(this.handler);
                this.visitMethodInsn(184, BTRACE_RUNTIME, BTRACE_RUNTIME_HANDLE_EXCEPTION, BTRACE_RUNTIME_HANDLE_EXCEPTION_DESC);
                super.visitInsn(177);
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }

    public static void main(String[] args) throws Exception {
        String className;
        if (args.length == 0 || args.length > 2) {
            System.err.println("Usage: java com.sun.btrace.runtime.Preprocessor <class> [<new-class-name>]");
            System.exit(1);
        }
        boolean renamed = args.length == 2;
        String newName = className = args[0].replace('.', '/');
        if (renamed) {
            newName = args[1].replace('.', '/');
        }
        FileInputStream fis = new FileInputStream(className + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(newName + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        ClassAdapter cv = renamed ? new ClassRenamer(args[1], new Preprocessor(writer)) : new Preprocessor(writer);
        InstrumentUtils.accept(reader, cv);
        fos.write(writer.toByteArray());
    }

    static {
        try {
            Method handleException = BTraceRuntime.class.getMethod("handleException", Throwable.class);
            BTRACE_RUNTIME_HANDLE_EXCEPTION = handleException.getName();
            BTRACE_RUNTIME_HANDLE_EXCEPTION_DESC = Type.getMethodDescriptor(handleException);
            Method enter = BTraceRuntime.class.getMethod("enter", BTraceRuntime.class);
            BTRACE_RUNTIME_ENTER = enter.getName();
            BTRACE_RUNTIME_ENTER_DESC = Type.getMethodDescriptor(enter);
            Method leave = BTraceRuntime.class.getMethod("leave", new Class[0]);
            BTRACE_RUNTIME_LEAVE = leave.getName();
            BTRACE_RUNTIME_LEAVE_DESC = Type.getMethodDescriptor(leave);
            Method start = BTraceRuntime.class.getMethod("start", new Class[0]);
            BTRACE_RUNTIME_START = start.getName();
            BTRACE_RUNTIME_START_DESC = Type.getMethodDescriptor(start);
            Method forClass = BTraceRuntime.class.getMethod("forClass", Class.class);
            BTRACE_RUNTIME_FOR_CLASS = forClass.getName();
            BTRACE_RUNTIME_FOR_CLASS_DESC = Type.getMethodDescriptor(forClass);
            Method newThreadLocal = BTraceRuntime.class.getMethod("newThreadLocal", Object.class);
            BTRACE_RUNTIME_NEW_THREAD_LOCAL = newThreadLocal.getName();
            BTRACE_RUNTIME_NEW_THREAD_LOCAL_DESC = Type.getMethodDescriptor(newThreadLocal);
            Method newPerfCounter = BTraceRuntime.class.getMethod("newPerfCounter", String.class, String.class, Object.class);
            BTRACE_RUNTIME_NEW_PERFCOUNTER = newPerfCounter.getName();
            BTRACE_RUNTIME_NEW_PERFCOUNTER_DESC = Type.getMethodDescriptor(newPerfCounter);
            Method getPerfString = BTraceRuntime.class.getMethod("getPerfString", String.class);
            BTRACE_RUNTIME_GET_PERFSTRING = getPerfString.getName();
            BTRACE_RUNTIME_GET_PERFSTRING_DESC = Type.getMethodDescriptor(getPerfString);
            Method getPerfInt = BTraceRuntime.class.getMethod("getPerfInt", String.class);
            BTRACE_RUNTIME_GET_PERFINT = getPerfInt.getName();
            BTRACE_RUNTIME_GET_PERFINT_DESC = Type.getMethodDescriptor(getPerfInt);
            Method getPerfLong = BTraceRuntime.class.getMethod("getPerfLong", String.class);
            BTRACE_RUNTIME_GET_PERFLONG = getPerfLong.getName();
            BTRACE_RUNTIME_GET_PERFLONG_DESC = Type.getMethodDescriptor(getPerfLong);
            Method getPerfFloat = BTraceRuntime.class.getMethod("getPerfFloat", String.class);
            BTRACE_RUNTIME_GET_PERFFLOAT = getPerfFloat.getName();
            BTRACE_RUNTIME_GET_PERFFLOAT_DESC = Type.getMethodDescriptor(getPerfFloat);
            Method getPerfDouble = BTraceRuntime.class.getMethod("getPerfDouble", String.class);
            BTRACE_RUNTIME_GET_PERFDOUBLE = getPerfDouble.getName();
            BTRACE_RUNTIME_GET_PERFDOUBLE_DESC = Type.getMethodDescriptor(getPerfDouble);
            Method putPerfString = BTraceRuntime.class.getMethod("putPerfString", String.class, String.class);
            BTRACE_RUNTIME_PUT_PERFSTRING = putPerfString.getName();
            BTRACE_RUNTIME_PUT_PERFSTRING_DESC = Type.getMethodDescriptor(putPerfString);
            Method putPerfInt = BTraceRuntime.class.getMethod("putPerfInt", Integer.TYPE, String.class);
            BTRACE_RUNTIME_PUT_PERFINT = putPerfInt.getName();
            BTRACE_RUNTIME_PUT_PERFINT_DESC = Type.getMethodDescriptor(putPerfInt);
            Method putPerfLong = BTraceRuntime.class.getMethod("putPerfLong", Long.TYPE, String.class);
            BTRACE_RUNTIME_PUT_PERFLONG = putPerfLong.getName();
            BTRACE_RUNTIME_PUT_PERFLONG_DESC = Type.getMethodDescriptor(putPerfLong);
            Method putPerfFloat = BTraceRuntime.class.getMethod("putPerfFloat", Float.TYPE, String.class);
            BTRACE_RUNTIME_PUT_PERFFLOAT = putPerfFloat.getName();
            BTRACE_RUNTIME_PUT_PERFFLOAT_DESC = Type.getMethodDescriptor(putPerfFloat);
            Method putPerfDouble = BTraceRuntime.class.getMethod("putPerfDouble", Double.TYPE, String.class);
            BTRACE_RUNTIME_PUT_PERFDOUBLE = putPerfDouble.getName();
            BTRACE_RUNTIME_PUT_PERFDOUBLE_DESC = Type.getMethodDescriptor(putPerfDouble);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    private static class FieldDescriptor {
        int access;
        String name;
        String desc;
        String signature;
        Object value;
        List<Attribute> attributes;
        boolean isThreadLocal;
        boolean isExport;
        boolean isProperty;
        String propertyName;
        String propertyDescription;
        int var = -1;
        boolean initialized;

        FieldDescriptor(int acc, String n, String d, String sig, Object val, List<Attribute> attrs, boolean tls, boolean isExp, boolean isProp, String propName, String propDescription) {
            this.access = acc;
            this.name = n;
            this.desc = d;
            this.signature = sig;
            this.value = val;
            this.attributes = attrs;
            this.isThreadLocal = tls;
            this.isExport = isExp;
            this.isProperty = isProp;
            this.propertyName = propName;
            this.propertyDescription = propDescription;
        }
    }
}

