/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.util.cluster.Strings;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceInfo {
    private String host;
    private int port;
    private String name;
    private String state;
    private Logger logger;
    private final int timeoutInMsec;
    private boolean running;
    private static final String NOT_RUNNING = Strings.get("ListInstances.NotRunning");
    private static final String NAME = Strings.get("ListInstances.name");
    private static final String HOST = Strings.get("ListInstances.host");
    private static final String PORT = Strings.get("ListInstances.port");
    private static final String STATE = Strings.get("ListInstances.state");

    public InstanceInfo(String name0, int port0, String host0, Logger logger0, int timeout0) {
        if (name0 == null || host0 == null) {
            throw new NullPointerException("null arguments");
        }
        this.name = name0;
        this.port = port0;
        this.host = host0;
        this.logger = logger0;
        this.state = this.pingInstance();
        this.timeoutInMsec = timeout0;
    }

    public final String toString() {
        return "name: " + this.getName() + ", host: " + this.getHost() + ", port: " + this.getPort() + ", state: " + this.state;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public boolean isRunning() {
        return this.running;
    }

    public static String format(List<InstanceInfo> infos) {
        int i;
        int longestName = NAME.length();
        int longestHost = HOST.length();
        int longestState = STATE.length();
        int longestPort = PORT.length();
        for (InstanceInfo info : infos) {
            int namel = info.getName().length();
            int hostl = info.getHost().length();
            int statel = info.getState().length();
            if (namel > longestName) {
                longestName = namel;
            }
            if (hostl > longestHost) {
                longestHost = hostl;
            }
            if (statel <= longestState) continue;
            longestState = statel;
        }
        StringBuilder sb = new StringBuilder();
        String formattedLine = "%-" + (longestName += 2) + "s %-" + (longestHost += 2) + "s %-" + (longestPort += 2) + "s %-" + (longestState += 2) + "s";
        sb.append(String.format(formattedLine, NAME, HOST, PORT, STATE));
        sb.append('\n');
        for (i = 0; i < longestName; ++i) {
            sb.append('-');
        }
        sb.append('|');
        for (i = 0; i < longestHost; ++i) {
            sb.append('-');
        }
        sb.append('|');
        for (i = 0; i < longestPort; ++i) {
            sb.append('-');
        }
        sb.append('|');
        for (i = 0; i < longestState; ++i) {
            sb.append('-');
        }
        sb.append('|');
        sb.append('\n');
        boolean first = true;
        for (InstanceInfo info : infos) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            String portString = "   " + info.getPort();
            sb.append(String.format(formattedLine, info.getName(), info.getHost(), portString, info.getState()));
        }
        return sb.toString();
    }

    private String pingInstance() {
        if (this.i9()) {
            return this.getUptime();
        }
        return NOT_RUNNING;
    }

    private String getUptime() {
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand("uptime", this.host, this.port, false, "admin", null, this.logger);
            rac.setConnectTimeout(this.timeoutInMsec);
            ParameterMap map = new ParameterMap();
            map.set((Object)"type", (Object)"terse");
            this.running = true;
            return rac.executeCommand(map).trim();
        }
        catch (CommandException ex) {
            return NOT_RUNNING;
        }
    }

    private boolean i9() {
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand("__locations", this.host, this.port, false, "admin", null, this.logger);
            rac.setConnectTimeout(this.timeoutInMsec);
            ParameterMap map = new ParameterMap();
            map.set((Object)"type", (Object)"terse");
            String ret = rac.executeCommand(map).trim();
            if (ret != null && ret.endsWith("/" + this.name)) {
                return true;
            }
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return false;
    }

    private static String prepareFormatString() {
        return null;
    }
}

