/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;

public class DeploymentUtils {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentUtils.class);
    private static final String V2_COMPATIBILITY = "v2";
    private static final String WEB_INF = "WEB-INF";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String RA_XML = "META-INF/ra.xml";
    private static final String APPLICATION_XML = "META-INF/application.xml";
    private static final String SUN_APPLICATION_XML = "META-INF/sun-application.xml";
    private static final String GF_APPLICATION_XML = "META-INF/glassfish-application.xml";
    private static final String EAR_EXTENSION = ".ear";
    private static final String WAR_EXTENSION = ".war";
    private static final String RAR_EXTENSION = ".rar";
    private static final String EXPANDED_WAR_SUFFIX = "_war";
    private static final String EXPANDED_RAR_SUFFIX = "_rar";
    private static final String EXPANDED_JAR_SUFFIX = "_jar";
    private static final String INSTANCE_ROOT_URI_PROPERTY_NAME = "com.sun.aas.instanceRootURI";

    public static boolean isWebArchive(ReadableArchive archive) {
        try {
            if (Util.getURIName(archive.getURI()).endsWith(WAR_EXTENSION)) {
                return true;
            }
            if (archive.exists(WEB_INF)) {
                return true;
            }
            Enumeration entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(JSP_SUFFIX)) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getDefaultEEName(String pathName) {
        if (pathName == null) {
            return null;
        }
        if ((pathName = pathName.replace('\\', '/')).endsWith("/")) {
            pathName = pathName.substring(0, pathName.length() - 1);
        }
        if (pathName.lastIndexOf("/") != -1) {
            pathName = pathName.substring(pathName.lastIndexOf("/") + 1);
        }
        if (pathName.endsWith(".jar") || pathName.endsWith(WAR_EXTENSION) || pathName.endsWith(RAR_EXTENSION) || pathName.endsWith(EAR_EXTENSION)) {
            return pathName.substring(0, pathName.length() - 4);
        }
        return pathName;
    }

    public static boolean isRAR(ReadableArchive archive) {
        boolean isRar = false;
        try {
            if (Util.getURIName(archive.getURI()).endsWith(RAR_EXTENSION)) {
                return true;
            }
            isRar = archive.exists(RA_XML);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isRar;
    }

    public static boolean isEAR(ReadableArchive archive) {
        boolean isEar = false;
        try {
            if (Util.getURIName(archive.getURI()).endsWith(EAR_EXTENSION)) {
                return true;
            }
            boolean bl = isEar = archive.exists(APPLICATION_XML) || archive.exists(SUN_APPLICATION_XML) || archive.exists(GF_APPLICATION_XML);
            if (!isEar) {
                isEar = DeploymentUtils.isEARFromIntrospecting(archive);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isEar;
    }

    private static boolean isEARFromIntrospecting(ReadableArchive archive) throws IOException {
        for (String entryName : archive.getDirectories()) {
            if (!entryName.endsWith(EXPANDED_WAR_SUFFIX) && !entryName.endsWith(EXPANDED_RAR_SUFFIX) && !entryName.endsWith(EXPANDED_JAR_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public static String getRelativeEmbeddedModulePath(String appRootPath, String moduleUri) {
        if (FileUtils.safeIsDirectory((File)new File(appRootPath, moduleUri = FileUtils.makeLegalNoBlankFileName((String)moduleUri)))) {
            return moduleUri;
        }
        return FileUtils.makeFriendlyFilenameExtension((String)moduleUri);
    }

    public static String getEmbeddedModulePath(String appRootPath, String moduleUri) {
        return appRootPath + File.separator + DeploymentUtils.getRelativeEmbeddedModulePath(appRootPath, moduleUri);
    }

    public static boolean useV2Compatibility(DeploymentContext context) {
        return V2_COMPATIBILITY.equals(context.getAppProps().getProperty("compatibility"));
    }

    public static String relativizeWithinDomainIfPossible(URI absURI) throws URISyntaxException {
        URI instanceRootURI = new URI(System.getProperty(INSTANCE_ROOT_URI_PROPERTY_NAME));
        URI appURI = instanceRootURI.relativize(absURI);
        String appLocation = appURI.isAbsolute() ? appURI.toString() : "${com.sun.aas.instanceRootURI}/" + appURI.toString();
        return appLocation;
    }

    public static void validateApplicationName(String name) {
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", new Object[]{"/", name}));
        }
        if (name.indexOf(35) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", new Object[]{"#", name}));
        }
        if (name.indexOf(59) != -1) {
            throw new IllegalArgumentException(localStrings.getLocalString("illegal_char_in_name", "Illegal character [{0}] in the name [{1}].", new Object[]{";", name}));
        }
    }
}

