/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.matcher;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.matcher.WildcardMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLdapMatcher {
    private static final char LEFT = '(';
    private static final char RIGHT = ')';
    private static final char AND = '&';
    private static final char OR = '|';
    private static final char EQ = '=';
    private static final char NOT = '!';
    private static final int UNKNOWN_TYPE = -1;
    private static final int BASE_TYPE = 0;
    private static final int AND_TYPE = 1;
    private static final int OR_TYPE = 2;
    private static final int NEST_TYPE = 3;
    private static final int FALSE_TYPE = 4;
    private final String originalLDAP;
    private final Node topNode;

    SimpleLdapMatcher(String paramOriginalLDAP) {
        this.originalLDAP = paramOriginalLDAP;
        if (this.originalLDAP != null) {
            ActiveString workString = new ActiveString(paramOriginalLDAP);
            this.topNode = SimpleLdapMatcher.parse(workString);
            workString.finish();
        } else {
            this.topNode = new Node();
            this.topNode.setType(4);
        }
    }

    SimpleLdapMatcher(Node node) {
        this.originalLDAP = null;
        this.topNode = node;
    }

    public static SimpleLdapMatcher create(String ldapFilter) {
        return new SimpleLdapMatcher(ldapFilter);
    }

    public static SimpleLdapMatcher create(Map<String, Object> props) {
        Node node = new Node();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            Node child = new Node(entry.getKey(), true, SimpleLdapMatcher.stringOf(entry.getValue()));
            node.addChild(child);
        }
        return new SimpleLdapMatcher(node);
    }

    public static SimpleLdapMatcher createClassFilter(String clazzName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("objectclass", clazzName);
        return SimpleLdapMatcher.create(props);
    }

    private static String stringOf(Object obj) {
        return null == obj ? null : obj.toString();
    }

    String getOriginalFilterString() {
        return this.originalLDAP;
    }

    public boolean matches(MultiMap<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Set<String>> matchingMap = this.getMatchingMap(properties);
        return this.matches(matchingMap);
    }

    public boolean matches(Map<String, Set<String>> toMatch) {
        return this.topNode.doesMatch(toMatch);
    }

    public Set<String> getTheAndSetFor(String propName, boolean removeIt) {
        HashSet<String> andSet = new HashSet<String>();
        this.getTheAndSetFor(andSet, propName.toLowerCase(), removeIt, this.topNode);
        return andSet;
    }

    protected boolean getTheAndSetFor(Set<String> result, String propName, boolean removeIt, Node node) {
        boolean hadMatch;
        block3: {
            block2: {
                hadMatch = false;
                if (node.type != 0) break block2;
                if (!node.leftHandSide.equals(propName)) break block3;
                result.add(node.rightHandSide);
                hadMatch = true;
                if (!removeIt) break block3;
                node.leftHandSide = "";
                break block3;
            }
            if (node.type == 1) {
                Iterator iter = node.children.iterator();
                while (iter.hasNext()) {
                    Node andNode = (Node)iter.next();
                    boolean matched = this.getTheAndSetFor(result, propName, removeIt, andNode);
                    hadMatch |= matched;
                    if (!matched || !removeIt) continue;
                    iter.remove();
                }
            }
        }
        return hadMatch;
    }

    private Map<String, Set<String>> getMatchingMap(MultiMap<String, String> props) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, List<String>> entry : props.entrySet()) {
            HashSet set = new HashSet();
            set.addAll(entry.getValue());
            result.put(entry.getKey(), set);
        }
        return result;
    }

    static boolean filterMatch(String filter, Map<String, Object> properties) {
        if (filter == null || properties == null) {
            throw new IllegalArgumentException();
        }
        ActiveString workString = new ActiveString(filter);
        Node topNode = SimpleLdapMatcher.parse(workString);
        Map<String, Set<String>> matchingMap = SimpleLdapMatcher.getMatchingMap(properties);
        return topNode.doesMatch(matchingMap);
    }

    static Map<String, Set<String>> getMatchingMap(Map<String, Object> paramProperties) {
        HashMap<String, Set<String>> retVal = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Object> entry : paramProperties.entrySet()) {
            String key = entry.getKey();
            if (key == null) {
                throw new RuntimeException("Null key in property map");
            }
            Object value = entry.getValue();
            if (value == null) {
                throw new RuntimeException("Null value in property map for " + key);
            }
            String toLowerKey = key.toLowerCase();
            HashSet<String> valueSet = new HashSet<String>();
            Class<?> valueClass = value.getClass();
            if (valueClass.isArray()) {
                int valueLength = Array.getLength(value);
                for (int lcv = 0; lcv < valueLength; ++lcv) {
                    Object arrayValue = Array.get(value, lcv);
                    if (arrayValue == null) {
                        throw new RuntimeException("Null value in array for " + key + " at index " + lcv);
                    }
                    String arrayValueString = arrayValue.toString();
                    valueSet.add(arrayValueString);
                }
            } else {
                String valueString = value.toString();
                valueSet.add(valueString);
            }
            retVal.put(toLowerKey, valueSet);
        }
        return retVal;
    }

    private static Node parse(ActiveString workString) {
        Node retVal = new Node();
        workString.toStatementStart();
        int type = workString.getStatementType();
        switch (type) {
            case 0: {
                retVal.setType(0);
                String lhs = workString.getLeftHandSide();
                boolean isEquals = workString.getEqualsOrNotEquals();
                String rhs = workString.getRightHandSide();
                retVal.setLeftHandSide(lhs);
                retVal.setIsEquals(isEquals);
                retVal.setRightHandSide(rhs);
                break;
            }
            case 1: 
            case 2: {
                retVal.setType(type);
                while (workString.finishedOrNewStatement()) {
                    Node child = SimpleLdapMatcher.parse(workString);
                    retVal.addChild(child);
                }
                if (retVal.getNumChildren() > 1) break;
                throw new RuntimeException("There was zero or one children of an AND or OR construct");
            }
            case 3: {
                Node lastNode = SimpleLdapMatcher.parse(workString);
                retVal.copyNode(lastNode);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown node type " + type));
            }
        }
        return retVal;
    }

    public String toString() {
        return "Filter(" + this.originalLDAP + "," + System.identityHashCode(this) + ")";
    }

    public String getLdapExpression() {
        return this.originalLDAP;
    }

    private static class ActiveString {
        final String original;
        int dot = 0;
        char[] data;

        private ActiveString(String fullString) {
            this.original = fullString;
            this.data = fullString.toCharArray();
        }

        private boolean incrementDot(boolean doThrow) {
            if (this.dot + 1 >= this.data.length) {
                if (doThrow) {
                    throw new RuntimeException("Invalid end of string reached in " + this.original + " at character " + this.dot);
                }
                return false;
            }
            ++this.dot;
            return true;
        }

        private boolean skipWhiteSpace(boolean doThrow) {
            boolean retVal = false;
            while (Character.isWhitespace(this.data[this.dot])) {
                retVal = this.incrementDot(doThrow);
            }
            return retVal;
        }

        private void toStatementStart() {
            this.skipWhiteSpace(true);
            if (this.data[this.dot] != '(') {
                throw new RuntimeException("Statement did not start with '(', found " + this.data[this.dot] + " at character " + this.dot);
            }
            this.incrementDot(true);
        }

        private int getStatementType() {
            this.skipWhiteSpace(true);
            if (this.data[this.dot] == '&') {
                this.incrementDot(true);
                return 1;
            }
            if (this.data[this.dot] == '|') {
                this.incrementDot(true);
                return 2;
            }
            if (this.data[this.dot] == '(') {
                return 3;
            }
            return 0;
        }

        private boolean finishedOrNewStatement() {
            this.skipWhiteSpace(true);
            if (this.data[this.dot] == ')') {
                this.incrementDot(false);
                return false;
            }
            return true;
        }

        private String getLeftHandSide() {
            int startIndex = this.dot;
            int count = 0;
            while (this.data[this.dot] != '=') {
                if (this.data[this.dot] == '!' && this.dot + 1 < this.data.length && this.data[this.dot + 1] == '=') {
                    return new String(this.data, startIndex, count);
                }
                ++count;
                this.incrementDot(true);
            }
            return new String(this.data, startIndex, count);
        }

        private boolean getEqualsOrNotEquals() {
            if (this.data[this.dot] == '=') {
                this.incrementDot(true);
                return true;
            }
            if (this.data[this.dot] == '!') {
                this.incrementDot(true);
                if (this.data[this.dot] != '=') {
                    throw new AssertionError((Object)("Invalid not equals at character " + this.dot));
                }
                this.incrementDot(true);
                return false;
            }
            throw new AssertionError((Object)("Was looking for equals or not equals but found " + this.data[this.dot] + " at character " + this.dot));
        }

        private String getRightHandSide() {
            int startIndex = this.dot;
            int count = 0;
            while (this.data[this.dot] != ')') {
                ++count;
                this.incrementDot(true);
            }
            this.incrementDot(false);
            return new String(this.data, startIndex, count);
        }

        private void finish() {
            if (this.skipWhiteSpace(false)) {
                throw new RuntimeException("Found extra characters at end of LDAP string " + this.original + " at character " + this.dot);
            }
        }

        public String toString() {
            char dataDot = this.dot < this.data.length ? this.data[this.dot] : (char)' ';
            return "ActiveString(" + this.original + "," + this.dot + "," + dataDot + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        private int type = -1;
        private String leftHandSide;
        private boolean equals;
        private String rightHandSide;
        private final List<Node> children = new LinkedList<Node>();

        private Node() {
            this.type = 1;
        }

        private Node(String lhs, boolean equals, String rhs) {
            this.type = 0;
            this.leftHandSide = lhs;
            this.equals = equals;
            this.rightHandSide = rhs;
        }

        private void setType(int paramType) {
            this.type = paramType;
        }

        private void setLeftHandSide(String lhs) {
            this.leftHandSide = lhs.toLowerCase();
        }

        private void setRightHandSide(String rhs) {
            this.rightHandSide = rhs;
        }

        private void setIsEquals(boolean isEquals) {
            this.equals = isEquals;
        }

        private void addChild(Node child) {
            this.children.add(child);
        }

        private int getNumChildren() {
            return this.children.size();
        }

        private void copyNode(Node copyNode) {
            this.type = copyNode.type;
            this.leftHandSide = copyNode.leftHandSide;
            this.equals = copyNode.equals;
            this.rightHandSide = copyNode.rightHandSide;
            this.children.clear();
            this.children.addAll(copyNode.children);
        }

        private boolean doesMatch(Map<String, Set<String>> toMatch) {
            if (this.type == 0) {
                Set<String> valueSet = toMatch.get(this.leftHandSide);
                if (valueSet == null) {
                    if (this.equals) {
                        return null == this.leftHandSide || this.leftHandSide.length() == 0;
                    }
                    return true;
                }
                WildcardMatcher matcher = new WildcardMatcher(this.rightHandSide);
                for (String val : valueSet) {
                    if (!matcher.matches(val)) continue;
                    return this.equals;
                }
                return !this.equals;
            }
            if (this.type == 1) {
                for (Node andNode : this.children) {
                    if (andNode.doesMatch(toMatch)) continue;
                    return false;
                }
                return true;
            }
            if (this.type == 2) {
                for (Node orNode : this.children) {
                    if (!orNode.doesMatch(toMatch)) continue;
                    return true;
                }
                return false;
            }
            if (this.type == 4) {
                return false;
            }
            throw new AssertionError((Object)("Unknown node type " + this.type));
        }

        public String toString() {
            String typeString;
            switch (this.type) {
                case 0: {
                    typeString = "BASE_TYPE";
                    break;
                }
                case 1: {
                    typeString = "AND_TYPE";
                    break;
                }
                case 2: {
                    typeString = "OR_TYPE";
                    break;
                }
                case 4: {
                    typeString = "FALSE_TYPE";
                    break;
                }
                default: {
                    typeString = "Unknown_TYPE(" + this.type + ")";
                }
            }
            return "Node(" + typeString + "," + "lhs=" + this.leftHandSide + "," + "equals=" + this.equals + "," + "rhs=" + this.rightHandSide + "," + System.identityHashCode(this) + ")";
        }
    }
}

