/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-application-ref")
@I18n(value="delete.application.ref.command")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class DeleteApplicationRefCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteApplicationRefCommand.class);
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false")
    public Boolean cascade;
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject(name="default-instance-name")
    protected Server server;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        Application application = this.applications.getApplication(this.name);
        if (application == null) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ApplicationRef applicationRef = this.domain.getApplicationRefInTarget(this.name, this.target);
        if (applicationRef == null) {
            report.setMessage(localStrings.getLocalString("appref.not.exists", "Target {1} does not have a reference to application {0}.", new Object[]{this.name, this.target}));
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
            return;
        }
        try {
            ReadableArchive source = null;
            ApplicationInfo appInfo = this.deployment.get(this.name);
            if (appInfo != null) {
                source = appInfo.getSource();
            } else {
                File location = new File(new URI(application.getLocation()));
                source = this.archiveFactory.openArchive(location);
            }
            UndeployCommandParameters commandParams = new UndeployCommandParameters();
            commandParams.origin = this.server.isDas() ? OpsParams.Origin.unload : OpsParams.Origin.undeploy;
            commandParams.name = this.name;
            commandParams.cascade = this.cascade;
            ExtendedDeploymentContext deploymentContext = this.deployment.getBuilder(logger, (OpsParams)commandParams, report).source(source).build();
            deploymentContext.getAppProps().putAll((Map<?, ?>)application.getDeployProperties());
            deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
            if (this.domain.isCurrentInstanceMatchingTarget(this.target, this.server.getName()) && appInfo != null) {
                appInfo.stop(deploymentContext, deploymentContext.getLogger());
                appInfo.unload(deploymentContext);
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                try {
                    if (this.server.isInstance()) {
                        this.deployment.undeploy(this.name, deploymentContext);
                        deploymentContext.clean();
                        if (!Boolean.valueOf(application.getDirectoryDeployed()).booleanValue() && source.exists()) {
                            FileUtils.whack((File)new File(source.getURI()));
                        }
                    }
                    this.deployment.unregisterAppFromDomainXML(this.name, this.target, true);
                }
                catch (TransactionFailure e) {
                    logger.warning("failed to delete application ref for " + this.name);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during deleteing application ref ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

