/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Service(name="set-log-level")
@Scoped(value=PerLookup.class)
@I18n(value="set.log.level")
public class SetLogLevel
implements AdminCommand {
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    Domain domain;
    String[] validLevels = new String[]{"SEVERE", "WARNING", "INFO", "FINE", "FINER", "FINEST"};
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetLogLevel.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean isCluster = false;
        boolean isDas = false;
        boolean isInstance = false;
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            for (Object key : this.properties.keySet()) {
                String logger_name = (String)key;
                String level = (String)this.properties.get(logger_name);
                boolean vlvl = false;
                for (String s : this.validLevels) {
                    if (!s.equals(level)) continue;
                    m.put(logger_name + ".level", level);
                    vlvl = true;
                    break;
                }
                if (vlvl) continue;
                report.setMessage(localStrings.getLocalString("set.log.level.invalid", "Invalid logger level found {0}.  Valid levels are: SEVERE, WARNING, INFO, FINE, FINER, FINEST", new Object[]{level}));
            }
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null && targetServer.isDas()) {
                isDas = true;
            } else {
                com.sun.enterprise.config.serverbeans.Cluster cluster = this.domain.getClusterNamed(this.target);
                if (cluster != null) {
                    isCluster = true;
                } else {
                    isInstance = true;
                }
            }
            if (isCluster || isInstance) {
                this.loggingConfig.updateLoggingProperties(m, this.target);
            } else if (isDas) {
                this.loggingConfig.updateLoggingProperties(m);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String clusterName = "";
                String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", new Object[]{this.target});
                if (targetServer != null && targetServer.isInstance()) {
                    clusterName = targetServer.getCluster().getName();
                    msg = localStrings.getLocalString("invalid.target.sys.props", "Instance {0} is part of the Cluster so valid target value is '" + clusterName + "'.", new Object[]{this.target});
                }
                report.setMessage(msg);
                return;
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (IOException e) {
            report.setMessage("Could not set logger levels ");
            report.setMessage(localStrings.getLocalString("set.log.level.failed", "Could not set logger levels."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private static int trueLastIndexOf(String target, char ch) {
        int i = target.lastIndexOf(ch);
        while (i > 0 && target.charAt(i - 1) == '\\') {
            i = target.lastIndexOf(ch, i - 1);
        }
        return i;
    }

    private static void fail(AdminCommandContext context, String msg, Exception ex) {
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
        if (ex != null) {
            context.getActionReport().setFailureCause(ex);
        }
        context.getActionReport().setMessage(msg);
    }

    private static void fail(AdminCommandContext context, String msg) {
        SetLogLevel.fail(context, msg, null);
    }
}

