/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.model.UploadedFile;
import com.sun.webui.jsf.util.ThemeUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.apache.commons.fileupload.FileItem;

public class Upload
extends Field
implements Serializable {
    public static final String INPUT_ID = "_com.sun.webui.jsf.upload";
    public static final String INPUT_PARAM_ID = "_com.sun.webui.jsf.uploadParam";
    public static final String SCRIPT_ID = "_script";
    public static final String SCRIPT_FACET = "script";
    public static final String TEXT_ID = "_text";
    public static final String LENGTH_EXCEEDED = "length_exceeded";
    public static final String UPLOAD_ERROR_KEY = "upload_error_key";
    public static final String FILE_SIZE_KEY = "file_size_key";
    private static final boolean DEBUG = false;
    private int columns = Integer.MIN_VALUE;
    private boolean columns_set = false;

    public Upload() {
        this.setRendererType("com.sun.webui.jsf.Upload");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Upload";
    }

    protected void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }

    public Object getConvertedValue(FacesContext context, Object value) {
        String name;
        UploadedFileImpl uf = new UploadedFileImpl(value, context);
        if (this.isRequired() && uf.getSize() == 0L && ((name = uf.getOriginalName()) == null || name.trim().length() == 0)) {
            this.setValue("");
            return "";
        }
        return uf;
    }

    public String getValueAsString(FacesContext context) {
        return null;
    }

    public String getReadOnlyValueString(FacesContext context) {
        String valueString = null;
        Object value = this.getValue();
        if (value != null & value instanceof UploadedFile) {
            try {
                valueString = ((UploadedFile)value).getOriginalName();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (valueString == null) {
            valueString = ThemeUtilities.getTheme(context).getMessage("FileUpload.noFile");
        }
        return valueString;
    }

    public String getType() {
        return "file";
    }

    private Object _getText() {
        return null;
    }

    public void setText(Object text) {
    }

    public int getColumns() {
        int columns = this._getColumns();
        if (columns < 1) {
            columns = 40;
            this.setColumns(40);
        }
        return columns;
    }

    public String getPrimaryElementID(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent labelComp = this.getLabelComponent(context, null);
        if (labelComp == null) {
            return clntId;
        }
        return clntId.concat(INPUT_ID);
    }

    public String getLabeledElementId(FacesContext context) {
        if (this.isReadOnly()) {
            return null;
        }
        String clntId = this.getClientId(context);
        UIComponent labelComp = this.getLabelComponent(context, null);
        if (labelComp == null) {
            return clntId;
        }
        return clntId.concat(INPUT_ID);
    }

    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("uploadedFile")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("uploadedFile")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public Converter getConverter() {
        return super.getConverter();
    }

    public int getMaxLength() {
        return super.getMaxLength();
    }

    public boolean isTrim() {
        return super.isTrim();
    }

    public Object getText() {
        return this._getText();
    }

    private int _getColumns() {
        if (this.columns_set) {
            return this.columns;
        }
        ValueExpression _vb = this.getValueExpression("columns");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return 40;
    }

    public void setColumns(int columns) {
        this.columns = columns;
        this.columns_set = true;
    }

    public UploadedFile getUploadedFile() {
        return (UploadedFile)this.getValue();
    }

    public void setUploadedFile(UploadedFile uploadedFile) {
        this.setValue(uploadedFile);
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this.columns = (Integer)_values[1];
        this.columns_set = (Boolean)_values[2];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), new Integer(this.columns), this.columns_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }

    class UploadedFileImpl
    implements UploadedFile {
        transient FileItem fileItemObject = null;

        UploadedFileImpl(Object attribute, FacesContext context) {
            try {
                this.fileItemObject = (FileItem)context.getExternalContext().getRequestMap().get(attribute);
            }
            catch (Exception e) {
                String message = "File not uploaded. Is the upload filter installed ?";
                throw new FacesException(message, (Throwable)e);
            }
        }

        public void write(File file) throws Exception {
            if (this.fileItemObject != null) {
                this.fileItemObject.write(file);
            }
        }

        public long getSize() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getSize();
            }
            return 0L;
        }

        public String getOriginalName() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getName();
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getInputStream();
            }
            return null;
        }

        public String getContentType() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getContentType();
            }
            return null;
        }

        public byte[] getBytes() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.get();
            }
            return null;
        }

        public String getAsString() {
            if (this.fileItemObject != null) {
                return this.fileItemObject.getString();
            }
            return null;
        }

        public void dispose() {
            if (this.fileItemObject != null) {
                this.fileItemObject.delete();
            }
        }
    }
}

