/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.connectioncache.client;

import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultConnectorHandlerPool;
import com.sun.grizzly.connectioncache.client.CacheableConnectorHandler;
import com.sun.grizzly.connectioncache.client.OutboundConnectionFactory;
import com.sun.grizzly.connectioncache.spi.transport.ConnectionCacheFactory;
import com.sun.grizzly.connectioncache.spi.transport.ConnectionFinder;
import com.sun.grizzly.connectioncache.spi.transport.OutboundConnectionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableConnectorHandlerPool
implements ConnectorHandlerPool<CacheableConnectorHandler> {
    private final Controller controller;
    private final ConnectorHandlerPool protocolConnectorHandlerPool;
    private final ConnectorInstanceHandler<CacheableConnectorHandler> connectorInstanceHandler;
    private final OutboundConnectionCache<ConnectorHandler> outboundConnectionCache;
    private final ConnectionFinder<ConnectorHandler> connectionFinder;

    public CacheableConnectorHandlerPool(Controller controller, int highWaterMark, int numberToReclaim, int maxParallel) {
        this(controller, highWaterMark, numberToReclaim, maxParallel, null);
    }

    public CacheableConnectorHandlerPool(Controller controller, int highWaterMark, int numberToReclaim, int maxParallel, ConnectionFinder<ConnectorHandler> connectionFinder) {
        this(controller, highWaterMark, numberToReclaim, maxParallel, connectionFinder, null);
    }

    public CacheableConnectorHandlerPool(Controller controller, int highWaterMark, int numberToReclaim, int maxParallel, ConnectionFinder<ConnectorHandler> connectionFinder, OutboundConnectionFactory<ConnectorHandler> factory) {
        this.controller = controller;
        this.outboundConnectionCache = factory == null ? ConnectionCacheFactory.makeBlockingOutboundConnectionCache("Grizzly outbound connection cache", highWaterMark, numberToReclaim, maxParallel, Controller.logger()) : factory.makeBlockingOutboundConnectionCache(highWaterMark, numberToReclaim, maxParallel, Controller.logger());
        this.connectionFinder = connectionFinder;
        this.protocolConnectorHandlerPool = new DefaultConnectorHandlerPool(controller);
        this.connectorInstanceHandler = new CacheableConnectorInstanceHandler();
    }

    @Override
    public CacheableConnectorHandler acquireConnectorHandler(Controller.Protocol protocol) {
        CacheableConnectorHandler connectorHandler = this.connectorInstanceHandler.acquire();
        connectorHandler.protocol(protocol);
        return connectorHandler;
    }

    @Override
    public void releaseConnectorHandler(CacheableConnectorHandler connectorHandler) {
        this.connectorInstanceHandler.release(connectorHandler);
    }

    OutboundConnectionCache<ConnectorHandler> getOutboundConnectionCache() {
        return this.outboundConnectionCache;
    }

    ConnectionFinder getConnectionFinder() {
        return this.connectionFinder;
    }

    Controller getController() {
        return this.controller;
    }

    ConnectorHandlerPool getProtocolConnectorHandlerPool() {
        return this.protocolConnectorHandlerPool;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheableConnectorInstanceHandler
    extends ConnectorInstanceHandler.ConcurrentQueueConnectorInstanceHandler<CacheableConnectorHandler> {
        private CacheableConnectorInstanceHandler() {
        }

        @Override
        public CacheableConnectorHandler newInstance() {
            return new CacheableConnectorHandler(CacheableConnectorHandlerPool.this);
        }
    }
}

