/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferencerImpl;
import com.sun.enterprise.deployment.types.MessageDestinationReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class MessageDestinationReferenceDescriptor
extends EnvironmentProperty
implements MessageDestinationReference {
    public static final String CONSUMES = "Consumes";
    public static final String PRODUCES = "Produces";
    public static final String CONSUMES_PRODUCES = "ConsumesProduces";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MessageDestinationReferenceDescriptor.class);
    private BundleDescriptor referringBundle;
    private String usage;
    private String destinationType;
    private String jndiName;
    private MessageDestinationReferencerImpl referencer;

    public MessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor other) {
        super(other);
        this.referringBundle = other.referringBundle;
        this.usage = other.usage;
        this.destinationType = other.destinationType;
        this.referencer = new MessageDestinationReferencerImpl(other.referencer);
    }

    public MessageDestinationReferenceDescriptor(String name, String desc) {
        super(name, "", desc);
        this.referencer = new MessageDestinationReferencerImpl(this);
    }

    public MessageDestinationReferenceDescriptor() {
        this.referencer = new MessageDestinationReferencerImpl(this);
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String destUsage) {
        this.usage = destUsage;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String type) {
        this.destinationType = type;
    }

    public String getJndiName() {
        if (this.jndiName != null && !this.jndiName.equals("")) {
            return this.jndiName;
        }
        if (this.mappedName != null && !this.mappedName.equals("")) {
            return this.mappedName;
        }
        return this.lookupName;
    }

    public void setJndiName(String physicalDestinationName) {
        this.jndiName = physicalDestinationName;
    }

    public String getInjectResourceType() {
        return this.getDestinationType();
    }

    public void setInjectResourceType(String resourceType) {
        this.setDestinationType(resourceType);
    }

    public void setReferringBundleDescriptor(BundleDescriptor referringBundle) {
        this.referringBundle = referringBundle;
    }

    public BundleDescriptor getReferringBundleDescriptor() {
        return this.referringBundle;
    }

    public boolean isLinkedToMessageDestination() {
        return this.referencer.isLinkedToMessageDestination();
    }

    public String getMessageDestinationLinkName() {
        return this.referencer.getMessageDestinationLinkName();
    }

    public void setMessageDestinationLinkName(String linkName) {
        this.referencer.setMessageDestinationLinkName(linkName);
    }

    public MessageDestinationDescriptor setMessageDestinationLinkName(String linkName, boolean resolveLink) {
        return this.referencer.setMessageDestinationLinkName(linkName, resolveLink);
    }

    public MessageDestinationDescriptor resolveLinkName() {
        return this.referencer.resolveLinkName();
    }

    public boolean ownedByMessageDestinationRef() {
        return true;
    }

    public MessageDestinationReferenceDescriptor getMessageDestinationRefOwner() {
        return this;
    }

    public boolean ownedByMessageBean() {
        return false;
    }

    public EjbMessageBeanDescriptor getMessageBeanOwner() {
        return null;
    }

    public MessageDestinationDescriptor getMessageDestination() {
        return this.referencer.getMessageDestination();
    }

    public void setMessageDestination(MessageDestinationDescriptor newMsgDest) {
        this.referencer.setMessageDestination(newMsgDest);
    }

    public void print(StringBuffer toStringBuffer) {
        if (this.isLinkedToMessageDestination()) {
            toStringBuffer.append("Resolved Message-Destination-Ref ").append(this.getName()).append("points to logical message destination ").append(this.getMessageDestination().getName());
        } else {
            toStringBuffer.append("Unresolved Message-Destination-Ref ").append(this.getName()).append("@").append(this.getType()).append("@").append(this.usage);
        }
    }

    boolean isConflict(MessageDestinationReferenceDescriptor other) {
        return !this.getName().equals(other.getName()) || !DOLUtils.equals(this.getDestinationType(), other.getDestinationType()) || !DOLUtils.equals(this.getUsage(), other.getUsage()) || !DOLUtils.equals(this.getMessageDestinationLinkName(), other.getMessageDestinationLinkName()) || this.isConflictResourceGroup(other);
    }

    public boolean equals(Object object) {
        if (object instanceof MessageDestinationReference) {
            MessageDestinationReference reference = (MessageDestinationReference)object;
            return reference.getName().equals(this.getName());
        }
        return false;
    }
}

