/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.web;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.runtime.web.ClassLoader;
import com.sun.enterprise.deployment.web.InitializationParameter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WLContainerDescriptorNode
extends RuntimeDescriptorNode {
    public void setElementValue(XMLElement element, String value) {
        String name = element.getQName();
        if (name.equals("index-directory-enabled")) {
            this.setDefaultServletInitParam("listings", value);
        } else if (name.equals("index-directory-sort-by")) {
            this.setDefaultServletInitParam("sortedBy", value);
        } else if (name.equals("save-sessions-enabled")) {
            WebBundleDescriptor descriptor = (WebBundleDescriptor)this.getParentNode().getDescriptor();
            descriptor.setKeepState(value);
        } else if (name.equals("prefer-web-inf-classes")) {
            WebBundleDescriptor descriptor = (WebBundleDescriptor)this.getParentNode().getDescriptor();
            ClassLoader clBean = descriptor.getSunDescriptor().getClassLoader();
            if (clBean == null) {
                clBean = new ClassLoader();
                descriptor.getSunDescriptor().setClassLoader(clBean);
            }
            clBean.setAttributeValue("Delegate", Boolean.toString(!Boolean.parseBoolean(value)));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Object getDescriptor() {
        return null;
    }

    public Node writeDescriptor(Element root, WebBundleDescriptor webBundleDescriptor) {
        Element containerDescriptorNode = null;
        WebComponentDescriptor defaultServletDesc = webBundleDescriptor.getWebComponentByCanonicalName("default");
        InitializationParameter listingsParam = this.getDefaultServletInitParam(defaultServletDesc, "listings", false);
        InitializationParameter sortedByParam = this.getDefaultServletInitParam(defaultServletDesc, "sortedBy", false);
        ClassLoader clBean = webBundleDescriptor.getSunDescriptor().getClassLoader();
        containerDescriptorNode = WLContainerDescriptorNode.appendChild(root, "container-descriptor");
        if (listingsParam != null) {
            WLContainerDescriptorNode.appendTextChild((Node)containerDescriptorNode, "index-directory-enabled", listingsParam.getValue());
        }
        if (sortedByParam != null) {
            WLContainerDescriptorNode.appendTextChild((Node)containerDescriptorNode, "index-directory-sort-by", sortedByParam.getValue());
        }
        WLContainerDescriptorNode.appendTextChild((Node)containerDescriptorNode, "save-sessions-enabled", Boolean.toString(webBundleDescriptor.getKeepState()));
        if (clBean != null) {
            WLContainerDescriptorNode.appendTextChild((Node)containerDescriptorNode, "prefer-web-inf-classes", clBean.getAttributeValue("Delegate"));
        }
        return containerDescriptorNode;
    }

    private void setDefaultServletInitParam(String name, String value) {
        WebBundleDescriptor descriptor = (WebBundleDescriptor)this.getParentNode().getDescriptor();
        WebComponentDescriptor defaultServletDesc = descriptor.getWebComponentByCanonicalName("default");
        InitializationParameter initParam = this.getDefaultServletInitParam(defaultServletDesc, name, true);
        initParam.setValue(value);
    }

    private InitializationParameter getDefaultServletInitParam(WebComponentDescriptor defaultServletDesc, String name, boolean create) {
        if (defaultServletDesc == null) {
            throw new RuntimeException("Default servlet is missing in web descriptors.");
        }
        InitializationParameter initParam = defaultServletDesc.getInitializationParameterByName(name);
        if (initParam == null && create) {
            initParam = new EnvironmentProperty();
            defaultServletDesc.addInitializationParameter(initParam);
            initParam.setName(name);
        }
        return initParam;
    }
}

