/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http")
@Scoped(value=PerLookup.class)
@I18n(value="create.http")
@Cluster(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateHttp
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttp.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="request-timeout-seconds", optional=true)
    String requestTimeoutSeconds;
    @Param(name="timeout-seconds", defaultValue="30", optional=true)
    String timeoutSeconds;
    @Param(name="max-connection", defaultValue="256", optional=true)
    String maxConnections;
    @Param(name="default-virtual-server")
    String defaultVirtualServer;
    @Param(name="dns-lookup-enabled", defaultValue="false", optional=true)
    Boolean dnsLookupEnabled = false;
    @Param(name="servername", optional=true)
    String serverName;
    @Param(name="xpowered", optional=true, defaultValue="true")
    Boolean xPoweredBy = false;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject(name="default-instance-name")
    Config config;
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.habitat.getComponent(Target.class);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        Protocols protocols = this.config.getNetworkConfig().getProtocols();
        Protocol protocol = null;
        for (Protocol p : protocols.getProtocol()) {
            if (!this.protocolName.equals(p.getName())) continue;
            protocol = p;
        }
        if (protocol == null) {
            report.setMessage(localStrings.getLocalString("create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured. Please create one", new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (protocol.getHttp() != null) {
            report.setMessage(localStrings.getLocalString("create.http.fail.duplicate", "An http element for {0} already exists. Cannot add duplicate http", new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) throws TransactionFailure {
                    Http http = (Http)param.createChild(Http.class);
                    FileCache cache = (FileCache)http.createChild(FileCache.class);
                    cache.setEnabled("false");
                    http.setFileCache(cache);
                    http.setDefaultVirtualServer(CreateHttp.this.defaultVirtualServer);
                    http.setDnsLookupEnabled(CreateHttp.this.dnsLookupEnabled == null ? null : CreateHttp.this.dnsLookupEnabled.toString());
                    http.setMaxConnections(CreateHttp.this.maxConnections);
                    http.setRequestTimeoutSeconds(CreateHttp.this.requestTimeoutSeconds);
                    http.setTimeoutSeconds(CreateHttp.this.timeoutSeconds);
                    http.setXpoweredBy(CreateHttp.this.xPoweredBy == null ? null : CreateHttp.this.xPoweredBy.toString());
                    http.setServerName(CreateHttp.this.serverName);
                    param.setHttp(http);
                    return http;
                }
            }, protocol);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.http.redirect.fail", "Failed to create http-redirect for {0}: {1}", new Object[]{this.protocolName, e.getMessage() == null ? "No reason given." : e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

