/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ConnectorService;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorsUtil {
    private static Logger _logger = LogDomains.getLogger(ConnectorsUtil.class, (String)"javax.enterprise.resource.resourceadapter");

    public static boolean belongsToSystemRA(String raName) {
        boolean result = false;
        for (String systemRarName : ConnectorConstants.systemRarNames) {
            if (!systemRarName.equals(raName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean getPingDuringPoolCreation(String poolName, Resources allResources) {
        boolean pingOn = false;
        ResourcePool pool = ConnectorsUtil.getConnectionPoolConfig(poolName, allResources);
        if (pool instanceof JdbcConnectionPool) {
            JdbcConnectionPool jdbcPool = (JdbcConnectionPool)pool;
            pingOn = Boolean.parseBoolean(jdbcPool.getPing());
        } else if (pool instanceof ConnectorConnectionPool) {
            ConnectorConnectionPool ccPool = (ConnectorConnectionPool)pool;
            pingOn = Boolean.parseBoolean(ccPool.getPing());
        }
        return pingOn;
    }

    public static String getSystemModuleLocation(String moduleName) {
        String j2eeModuleDirName = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "install" + File.separator + "applications" + File.separator + moduleName;
        return j2eeModuleDirName;
    }

    public static String getLocation(String moduleName) {
        return ConfigBeansUtilities.getLocation((String)moduleName);
    }

    public static String getPMJndiName(String jndiName) {
        return jndiName + "__pm";
    }

    public static String getValidSuffix(String name) {
        if (name != null) {
            for (String validSuffix : ConnectorConstants.JNDI_SUFFIX_VALUES) {
                if (!name.endsWith(validSuffix)) continue;
                return validSuffix;
            }
        }
        return null;
    }

    public static boolean isValidJndiSuffix(String suffix) {
        if (suffix != null) {
            for (String validSuffix : ConnectorConstants.JNDI_SUFFIX_VALUES) {
                if (!validSuffix.equals(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static String deriveJndiName(String name, Hashtable env) {
        String suffix = (String)env.get("com.sun.enterprise.connectors.jndisuffix");
        if (ConnectorsUtil.isValidJndiSuffix(suffix)) {
            return name + suffix;
        }
        return name;
    }

    public static boolean isValidEventType(Object instance) {
        return instance instanceof JdbcConnectionPool || instance instanceof JdbcResource || instance instanceof ConnectorConnectionPool || instance instanceof ConnectorResource || instance instanceof MailResource || instance instanceof ExternalJndiResource || instance instanceof CustomResource || instance instanceof AdminObjectResource || instance instanceof WorkSecurityMap || instance instanceof ResourceAdapterConfig;
    }

    public static ResourcePool getConnectionPoolConfig(String poolName, Resources allResources) {
        ResourcePool pool = null;
        for (Resource configuredResource : allResources.getResources()) {
            ResourcePool resourcePool;
            if (!(configuredResource instanceof ResourcePool) || !(resourcePool = (ResourcePool)configuredResource).getName().equalsIgnoreCase(poolName)) continue;
            pool = resourcePool;
            break;
        }
        return pool;
    }

    public static Collection<Resource> getAllResources(Collection<String> poolNames, Resources allResources) {
        ArrayList<Resource> connectorResources = new ArrayList<Resource>();
        for (Resource resource : allResources.getResources()) {
            ConnectorResource connectorResource;
            if (!(resource instanceof ConnectorResource) || !poolNames.contains((connectorResource = (ConnectorResource)resource).getPoolName())) continue;
            connectorResources.add((Resource)connectorResource);
        }
        return connectorResources;
    }

    public static Collection<String> getAllPoolNames(Collection<ConnectorConnectionPool> connectionPools) {
        HashSet<String> poolNames = new HashSet<String>();
        for (ConnectorConnectionPool pool : connectionPools) {
            poolNames.add(pool.getName());
        }
        return poolNames;
    }

    public static Collection<WorkSecurityMap> getAllWorkSecurityMaps(Resources resources, String moduleName) {
        ArrayList<WorkSecurityMap> workSecurityMaps = new ArrayList<WorkSecurityMap>();
        for (WorkSecurityMap resource : resources.getResources(WorkSecurityMap.class)) {
            if (!resource.getResourceAdapterName().equals(moduleName)) continue;
            workSecurityMaps.add(resource);
        }
        return workSecurityMaps;
    }

    public static Collection<ConnectorConnectionPool> getAllPoolsOfModule(String moduleName, Resources allResources) {
        ArrayList<ConnectorConnectionPool> connectorConnectionPools = new ArrayList<ConnectorConnectionPool>();
        for (Resource resource : allResources.getResources()) {
            ConnectorConnectionPool connectorConnectionPool;
            if (!(resource instanceof ConnectorConnectionPool) || !(connectorConnectionPool = (ConnectorConnectionPool)resource).getResourceAdapterName().equals(moduleName)) continue;
            connectorConnectionPools.add(connectorConnectionPool);
        }
        return connectorConnectionPools;
    }

    public static Collection<Resource> getAllSystemRAResourcesAndPools(Resources allResources) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ArrayList<Resource> pools = new ArrayList<Resource>();
        for (Resource resource : allResources.getResources()) {
            String raName;
            if (resource instanceof JdbcConnectionPool) {
                pools.add(resource);
                continue;
            }
            if (resource instanceof ConnectorConnectionPool) {
                raName = ((ConnectorConnectionPool)resource).getResourceAdapterName();
                if (!ConnectorsUtil.belongsToSystemRA(raName)) continue;
                pools.add(resource);
                continue;
            }
            if (resource instanceof JdbcResource) {
                resources.add(resource);
                continue;
            }
            if (resource instanceof ConnectorResource) {
                String poolName = ((ConnectorResource)resource).getPoolName();
                String raName2 = ConnectorsUtil.getResourceAdapterNameOfPool(poolName, allResources);
                if (!ConnectorsUtil.belongsToSystemRA(raName2)) continue;
                resources.add(resource);
                continue;
            }
            if (!(resource instanceof AdminObjectResource) || !ConnectorsUtil.belongsToSystemRA(raName = ((AdminObjectResource)resource).getResAdapter())) continue;
            resources.add(resource);
        }
        resources.addAll(pools);
        return resources;
    }

    public static String getResourceAdapterNameOfPool(String poolName, Resources allResources) {
        String raName = null;
        for (Resource resource : allResources.getResources()) {
            ConnectorConnectionPool ccp;
            String name;
            if (!(resource instanceof ConnectorConnectionPool) || !(name = (ccp = (ConnectorConnectionPool)resource).getName()).equalsIgnoreCase(poolName)) continue;
            raName = ccp.getResourceAdapterName();
            break;
        }
        return raName;
    }

    public static ResourceAdapterConfig getRAConfig(String raName, Resources allResources) {
        Collection raConfigs = allResources.getResources(ResourceAdapterConfig.class);
        for (ResourceAdapterConfig rac : raConfigs) {
            if (!rac.getResourceAdapterName().equals(raName)) continue;
            return rac;
        }
        return null;
    }

    public static List<WorkSecurityMap> getWorkSecurityMaps(String raName, Resources allResources) {
        List resourcesList = allResources.getResources();
        ArrayList<WorkSecurityMap> workSecurityMaps = new ArrayList<WorkSecurityMap>();
        for (Resource resource : resourcesList) {
            WorkSecurityMap wsm;
            if (!(resource instanceof WorkSecurityMap) || !(wsm = (WorkSecurityMap)resource).getResourceAdapterName().equals(raName)) continue;
            workSecurityMaps.add(wsm);
        }
        return workSecurityMaps;
    }

    public static boolean isDynamicReconfigurationEnabled(ResourcePool pool) {
        PropertyBag properties;
        Property property;
        boolean enabled = false;
        if (pool instanceof PropertyBag && (property = (properties = (PropertyBag)pool).getProperty("dynamic-reconfiguration-wait-timeout-in-seconds")) != null) {
            try {
                if (Long.parseLong(property.getValue()) > 0L) {
                    enabled = true;
                }
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "invalid.dynamic-reconfig.value", property.getValue());
            }
        }
        return enabled;
    }

    public static String getResourceType(Resource resource) throws ConnectorRuntimeException {
        if (resource instanceof JdbcResource) {
            return "jdbc";
        }
        if (resource instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (resource instanceof ConnectorResource) {
            return "cr";
        }
        if (resource instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (resource instanceof MailResource) {
            return "mail";
        }
        if (resource instanceof ExternalJndiResource) {
            return "external-jndi";
        }
        if (resource instanceof CustomResource) {
            return "custom";
        }
        if (resource instanceof AdminObjectResource) {
            return "aor";
        }
        if (resource instanceof ResourceAdapterConfig) {
            return "rac";
        }
        if (resource instanceof WorkSecurityMap) {
            return "cwsm";
        }
        throw new ConnectorRuntimeException("Unknown resource type [ " + resource + " ]");
    }

    public static Object loadObject(String className) {
        Object obj = null;
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
            obj = c.newInstance();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "classloader.load_class_fail", className);
            _logger.log(Level.SEVERE, "classloader.load_class_fail_excp", ex.getMessage());
        }
        return obj;
    }

    public static Set getMergedActivationConfigProperties(EjbMessageBeanDescriptor msgDesc) {
        Set standardProps;
        HashSet<EnvironmentProperty> mergedProps = new HashSet<EnvironmentProperty>();
        HashSet<String> runtimePropNames = new HashSet<String>();
        Set runtimeProps = msgDesc.getRuntimeActivationConfigProperties();
        if (runtimeProps != null) {
            for (EnvironmentProperty entry : runtimeProps) {
                mergedProps.add(entry);
                String propName = entry.getName();
                runtimePropNames.add(propName);
            }
        }
        if ((standardProps = msgDesc.getActivationConfigProperties()) != null) {
            for (EnvironmentProperty entry : standardProps) {
                String propName = entry.getName();
                if (runtimePropNames.contains(propName)) continue;
                mergedProps.add(entry);
            }
        }
        return mergedProps;
    }

    public static boolean isJMSRA(String moduleName) {
        return "jmsra".equals(moduleName);
    }

    public static boolean parseBoolean(String enabled) {
        return Boolean.parseBoolean(enabled.toString());
    }

    public static String getResourceName(Resource resource) {
        if (resource instanceof BindableResource) {
            return ((BindableResource)resource).getJndiName();
        }
        if (resource instanceof ResourcePool) {
            return ((ResourcePool)resource).getName();
        }
        if (resource instanceof ResourceAdapterConfig) {
            return ((ResourceAdapterConfig)resource).getName();
        }
        if (resource instanceof WorkSecurityMap) {
            WorkSecurityMap wsm = (WorkSecurityMap)resource;
            return "resource-adapter name : " + wsm.getResourceAdapterName() + " : security map name : " + wsm.getName();
        }
        return null;
    }

    public static long getShutdownTimeout(ConnectorService connectorService) {
        int shutdownTimeout;
        try {
            if (connectorService == null) {
                shutdownTimeout = 30;
                _logger.log(Level.FINE, "Shutdown timeout set to " + shutdownTimeout + " through default");
            } else {
                shutdownTimeout = Integer.parseInt(connectorService.getShutdownTimeoutInSeconds());
                _logger.log(Level.FINE, "Shutdown timeout set to " + shutdownTimeout + " from domain.xml");
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "error_reading_connectorservice_elt", e);
            shutdownTimeout = 30;
        }
        return (long)shutdownTimeout * 1000L;
    }

    public static Map<String, String> getBuiltInCustomResources() {
        HashMap<String, String> resourcesMap = new HashMap<String, String>();
        resourcesMap.put("java.lang.Integer", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Long", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Double", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Float", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Character", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Short", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Byte", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.Boolean", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.lang.String", "org.glassfish.resources.custom.factory.PrimitivesAndStringFactory");
        resourcesMap.put("java.net.URL", "org.glassfish.resources.custom.factory.URLObjectFactory");
        resourcesMap.put("java.util.Properties", "org.glassfish.resources.custom.factory.PropertiesFactory");
        return resourcesMap;
    }

    public static String getTransactionIsolationInt(int tranIsolation) {
        if (tranIsolation == 1) {
            return "read-uncommited";
        }
        if (tranIsolation == 2) {
            return "read-committed";
        }
        if (tranIsolation == 4) {
            return "repeatable-read";
        }
        if (tranIsolation == 8) {
            return "serializable";
        }
        throw new RuntimeException("Invalid transaction isolation; the transaction isolation level can be empty or any of the following: read-uncommitted, read-committed, repeatable-read, serializable");
    }

    public static String deriveDataSourceDefinitionResourceName(String compId, String name) {
        String derivedName = name;
        return ConnectorsUtil.getReservePrefixedJNDINameForDataSourceDefinitionResource(compId, derivedName);
    }

    public static String deriveDataSourceDefinitionPoolName(String compId, String name) {
        String derivedName = name;
        return ConnectorsUtil.getReservePrefixedJNDINameForDataSourceDefinitionPool(compId, derivedName);
    }

    private static String escapeJavaName(String name) {
        if (name != null) {
            name = name.replace("-", "--");
            name = (name = name.replace("/", "-")).contains("java:") || name.contains(":") ? name.replace(":", "-") : "java-" + name;
        }
        return name;
    }

    public static Map<String, String> convertPropertiesToMap(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        return new TreeMap<Object, Object>(properties);
    }

    public static String getReservePrefixedJNDINameForDataSourceDefinitionPool(String compId, String poolName) {
        String prefix = null;
        prefix = compId == null || compId.equals("") ? "__SYSTEM/pools/__datasource_definition/" : "__SYSTEM/pools/__datasource_definition/" + compId + "/";
        return ConnectorsUtil.getReservePrefixedJNDIName(prefix, poolName);
    }

    private static String getReservePrefixedJNDIName(String prefix, String resourceName) {
        return prefix + resourceName;
    }

    public static String getReservePrefixedJNDINameForDataSourceDefinitionResource(String compId, String resourceName) {
        String prefix = null;
        prefix = compId == null || compId.equals("") ? "__SYSTEM/resource/__datasource_definition/" : "__SYSTEM/resource/__datasource_definition/" + compId + "/";
        return ConnectorsUtil.getReservePrefixedJNDIName(prefix, resourceName);
    }

    public static String getEmbeddedRarModuleName(String applicationName, String moduleName) {
        String embeddedRarName = moduleName.substring(0, moduleName.indexOf("_rar"));
        moduleName = applicationName + "#" + embeddedRarName;
        return moduleName;
    }

    public static boolean isEmbedded(DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        return archive != null && archive.getParentArchive() != null;
    }

    public static String getApplicationName(DeploymentContext context) {
        String applicationName = null;
        ReadableArchive parentArchive = context.getSource().getParentArchive();
        if (parentArchive != null) {
            applicationName = parentArchive.getName();
        }
        return applicationName;
    }

    public static List<URI> getInstalledLibrariesFromManifest(String moduleDirectory, ServerEnvironment env) throws ConnectorRuntimeException {
        ArrayList<URI> libURIs = new ArrayList<URI>();
        try {
            URL[] extensionListLibraries;
            File module = new File(moduleDirectory);
            FileArchive fileArchive = new FileArchive();
            fileArchive.open(module.toURI());
            Set extensionList = InstalledLibrariesResolver.getInstalledLibraries((ReadableArchive)fileArchive);
            for (URL url : extensionListLibraries = ASClassLoaderUtil.getLibrariesAsURLs((Set)extensionList, (ServerEnvironment)env)) {
                libURIs.add(url.toURI());
                _logger.log(Level.FINEST, "adding URL [ " + url + " ] to installedLibraries");
            }
        }
        catch (IOException ioe) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ioe.getMessage());
            cre.initCause(ioe);
            throw cre;
        }
        catch (URISyntaxException e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
        return libURIs;
    }

    public static String getReservePrefixedJNDINameForDescriptor(String moduleName) {
        return ConnectorsUtil.getReservePrefixedJNDIName("__SYSTEM/descriptors/", moduleName);
    }

    public static boolean isStandAloneRA(String moduleName) {
        return ConfigBeansUtilities.getModule((String)moduleName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean extractRar(String fileName, String rarName, String destDir) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(rarName);
        if (is != null) {
            File file;
            block21: {
                IOException ioe2;
                OutputStream os;
                FileArchive fa;
                block20: {
                    fa = new FileArchive();
                    os = null;
                    os = fa.putNextEntry(fileName);
                    FileUtils.copy((InputStream)is, (OutputStream)os, (long)0L);
                    Object var10_6 = null;
                    try {
                        if (os != null) {
                            fa.closeEntry();
                        }
                    }
                    catch (IOException ioe2) {
                        if (!_logger.isLoggable(Level.FINEST)) break block20;
                        _logger.log(Level.FINEST, "Exception while closing archive [ " + fileName + " ]", ioe2);
                    }
                }
                try {
                    is.close();
                }
                catch (IOException ioe2) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Exception while closing archive [ " + rarName + " ]", ioe2);
                    }
                    break block21;
                }
                {
                    catch (IOException e) {
                        boolean bl;
                        block23: {
                            block22: {
                                Object[] args = new Object[]{rarName, e};
                                _logger.log(Level.WARNING, "error.extracting.archive", args);
                                bl = false;
                                Object var10_7 = null;
                                try {
                                    if (os != null) {
                                        fa.closeEntry();
                                    }
                                }
                                catch (IOException ioe2) {
                                    if (!_logger.isLoggable(Level.FINEST)) break block22;
                                    _logger.log(Level.FINEST, "Exception while closing archive [ " + fileName + " ]", ioe2);
                                }
                            }
                            try {
                                is.close();
                            }
                            catch (IOException ioe2) {
                                if (!_logger.isLoggable(Level.FINEST)) break block23;
                                _logger.log(Level.FINEST, "Exception while closing archive [ " + rarName + " ]", ioe2);
                            }
                        }
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    block25: {
                        block24: {
                            Object var10_8 = null;
                            try {
                                if (os != null) {
                                    fa.closeEntry();
                                }
                            }
                            catch (IOException ioe2) {
                                if (!_logger.isLoggable(Level.FINEST)) break block24;
                                _logger.log(Level.FINEST, "Exception while closing archive [ " + fileName + " ]", ioe2);
                            }
                        }
                        try {
                            is.close();
                        }
                        catch (IOException ioe2) {
                            if (!_logger.isLoggable(Level.FINEST)) break block25;
                            _logger.log(Level.FINEST, "Exception while closing archive [ " + rarName + " ]", ioe2);
                        }
                    }
                    throw throwable;
                }
            }
            if ((file = new File(fileName)).exists()) {
                try {
                    ConnectorsUtil.extractJar(file, destDir);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            _logger.log(Level.INFO, "could not find RAR [ " + rarName + " ] location [ " + fileName + " ] " + "after extraction");
            return false;
        }
        _logger.log(Level.INFO, "could not find RAR [ " + rarName + " ] in the archive, skipping .rar extraction");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJar(File jarFile, String destDir) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enum1 = jar.entries();
        while (enum1.hasMoreElements()) {
            Exception e2;
            InputStream is;
            JarEntry file;
            block14: {
                Object var9_8;
                file = enum1.nextElement();
                File f = new File(destDir + File.separator + file.getName());
                if (file.isDirectory()) {
                    f.mkdir();
                    continue;
                }
                is = null;
                FileOutputStream fos = null;
                try {
                    is = jar.getInputStream(file);
                    fos = new FileOutputStream(f);
                    while (is.available() > 0) {
                        fos.write(is.read());
                    }
                    var9_8 = null;
                }
                catch (Throwable throwable) {
                    block16: {
                        block15: {
                            var9_8 = null;
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (Exception e2) {
                                if (!_logger.isLoggable(Level.FINEST)) break block15;
                                _logger.log(Level.FINEST, "exception while closing archive [ " + f.getName() + " ]", e2);
                            }
                        }
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception e2) {
                            if (!_logger.isLoggable(Level.FINEST)) break block16;
                            _logger.log(Level.FINEST, "exception while closing archive [ " + file.getName() + " ]", e2);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e2) {
                    if (!_logger.isLoggable(Level.FINEST)) break block14;
                    _logger.log(Level.FINEST, "exception while closing archive [ " + f.getName() + " ]", e2);
                }
            }
            try {
                if (is == null) continue;
                is.close();
            }
            catch (Exception e2) {
                if (!_logger.isLoggable(Level.FINEST)) continue;
                _logger.log(Level.FINEST, "exception while closing archive [ " + file.getName() + " ]", e2);
            }
        }
    }
}

