/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Cluster(value={RuntimeType.ALL})
@Service(name="delete-connector-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="delete.connector.connection.pool")
public class DeleteConnectorConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteConnectorConnectionPool.class);
    @Param(optional=true)
    private String target = "server";
    @Param(optional=true, defaultValue="false")
    private Boolean cascade;
    @Param(name="poolname", primary=true)
    private String poolname;
    @Inject
    private Resources resources;
    @Inject
    private Server[] servers;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.poolname == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.noJndiName", "No id defined for connector connection pool."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.resources.getResourceByName(ConnectorConnectionPool.class, this.poolname) == null) {
            report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.notfound", "A connector connection pool named {0} does not exist.", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            Object obj = this.deleteAssociatedResources(this.servers, this.resources, this.cascade, this.poolname);
            if (obj instanceof Integer && (Integer)obj == 1) {
                report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.pool_in_use", "Some connector resources are referencing connection pool {0}. Use 'cascade' option to delete them as well.", new Object[]{this.poolname}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    ConnectorConnectionPool cp = (ConnectorConnectionPool)DeleteConnectorConnectionPool.this.resources.getResourceByName(ConnectorConnectionPool.class, DeleteConnectorConnectionPool.this.poolname);
                    if (cp != null) {
                        return param.getResources().remove(cp);
                    }
                    return null;
                }
            }, this.resources) == null) {
                report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.notfound", "A connector connection pool named {0} does not exist.", new Object[]{this.poolname}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (TransactionFailure tfe) {
            Logger.getLogger(DeleteConnectorConnectionPool.class.getName()).log(Level.SEVERE, "Something went wrong in delete-connector-connection-pool", tfe);
            report.setMessage(tfe.getMessage() != null ? tfe.getLocalizedMessage() : localStrings.getLocalString("delete.connector.connection.pool.fail", "Connector connection pool {0} delete failed ", new Object[]{this.poolname}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("delete.connector.connection.pool.success", "Connector connection pool {0} deleted successfully", new Object[]{this.poolname}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private Object deleteAssociatedResources(final Server[] servers, Resources resources, final boolean cascade, final String connPoolId) throws TransactionFailure {
        return ConfigSupport.apply(new SingleConfigCode<Resources>(){

            @Override
            public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                Resource res = null;
                for (Resource resource : param.getResources()) {
                    if (!(resource instanceof ConnectorResource) || !((ConnectorResource)resource).getPoolName().equals(connPoolId)) continue;
                    if (cascade) {
                        DeleteConnectorConnectionPool.this.deleteResourceRefs(servers, ((ConnectorResource)resource).getJndiName());
                        res = resource;
                        break;
                    }
                    return 1;
                }
                if (res != null) {
                    param.getResources().remove(res);
                }
                return null;
            }
        }, resources);
    }

    private void deleteResourceRefs(Server[] servers, String refName) throws TransactionFailure {
        for (Server server : servers) {
            server.deleteResourceRef(refName);
        }
    }
}

