/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.validation.ValidationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.resources.TemplateResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.GetResultList;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBagResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    protected List<Dom> entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PropertiesBagResource.class);

    @Path(value="{Name}/")
    public PropertyResource getProperty(@PathParam(value="Name") String id) {
        PropertyResource resource = (PropertyResource)this.resourceContext.getResource(PropertyResource.class);
        resource.setBeanByKey(this.getEntity(), id);
        return resource;
    }

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public Object get() {
        List<Dom> entities = this.getEntity();
        if (entities == null) {
            return new GetResultList(new ArrayList<Dom>(), "", new String[0][], new OptionsResult(Util.getResourceName(this.uriInfo)));
        }
        String resultType = ResourceUtil.getResultType(this.requestHeaders);
        ActionReport ar = RestService.getHabitat().getComponent(ActionReport.class, resultType);
        ar.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ArrayList properties = new ArrayList();
        for (Dom child : entities) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", child.attribute("name"));
            entry.put("value", child.attribute("value"));
            String description = child.attribute("description");
            if (description != null) {
                entry.put("description", description);
            }
            properties.add(entry);
        }
        Properties extraProperties = new Properties();
        extraProperties.put("properties", properties);
        ar.setExtraProperties(extraProperties);
        return new ActionReportResult("properties", ar, new OptionsResult(Util.getResourceName(this.uriInfo)));
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public Response createProperties(List<Map<String, String>> data) {
        return this.clearThenSaveProperties(data);
    }

    @PUT
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public Response replaceProperties(List<Map<String, String>> data) {
        return this.clearThenSaveProperties(data);
    }

    @DELETE
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded", "application/octet-stream"})
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public Response delete() {
        try {
            this.deleteExistingProperties();
            String successMessage = localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
            return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return ResourceUtil.getResponse(400, ex.getMessage(), this.requestHeaders, this.uriInfo);
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected Response clearThenSaveProperties(List<Map<String, String>> properties) {
        try {
            this.deleteExistingProperties();
            for (Map<String, String> property : properties) {
                ConfigSupport.createAndSet((ConfigBean)this.parent, Property.class, property);
            }
            String successMessage = localStrings.getLocalString("rest.resource.update.message", "\"{0}\" updated successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
            return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return ResourceUtil.getResponse(400, ex.getMessage(), this.requestHeaders, this.uriInfo);
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected void deleteExistingProperties() throws TransactionFailure {
        for (Dom existingProp : this.parent.nodeElements(this.tagName)) {
            ConfigSupport.deleteChild((ConfigBean)this.parent, (ConfigBean)existingProp);
        }
    }

    public void setEntity(List<Dom> p) {
        this.entity = p;
    }

    public List<Dom> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        this.entity = parent.nodeElements(tagName);
    }

    public static class PropertyResource
    extends TemplateResource {
        public String getDeleteCommand() {
            return "GENERIC-DELETE";
        }
    }
}

