/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.CliFailureException;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExecCommand {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateExecCommand.class);
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    protected String resourceName;
    protected String commandName;
    protected String commandDisplayName;
    protected String commandMethod;
    protected String commandAction;
    protected boolean isLinkedToParent = false;
    protected int parameterType;

    public TemplateExecCommand(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, boolean isLinkedToParent) {
        this.resourceName = resourceName;
        this.commandName = commandName;
        this.commandMethod = commandMethod;
        this.commandAction = commandAction;
        this.commandDisplayName = commandDisplayName;
        this.isLinkedToParent = isLinkedToParent;
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html;qs=2", "application/xml"})
    public OptionsResult options() {
        OptionsResult optionsResult = new OptionsResult(this.resourceName);
        try {
            MethodMetaData methodMetaData = ResourceUtil.getMethodMetaData(this.commandName, this.getCommandParams(), this.parameterType, RestService.getHabitat(), RestService.logger);
            optionsResult.putMethodMetaData(this.commandMethod, methodMetaData);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return optionsResult;
    }

    protected ActionReportResult executeCommand(ParameterMap data) {
        ActionReport actionReport = ResourceUtil.runCommand(this.commandName, data, RestService.getHabitat(), ResourceUtil.getResultType(this.requestHeaders));
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, this.options());
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            Throwable ex = actionReport.getFailureCause();
            throw ex == null ? new CliFailureException(actionReport.getMessage()) : new CliFailureException(actionReport.getMessage(), ex);
        }
        results.setStatusCode(200);
        return results;
    }

    protected HashMap<String, String> getCommandParams() {
        return null;
    }

    protected void processCommandParams(ParameterMap data) {
        HashMap<String, String> commandParams = this.getCommandParams();
        if (commandParams != null) {
            if (this.isLinkedToParent) {
                ResourceUtil.resolveParentParamValue(commandParams, this.uriInfo);
            }
            for (Map.Entry<String, String> entry : commandParams.entrySet()) {
                data.add((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    protected void addQueryString(MultivaluedMap<String, String> qs, ParameterMap data) {
        for (Map.Entry entry : qs.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                data.add((Object)key, (Object)value);
            }
        }
    }

    protected void adjustParameters(ParameterMap data) {
        boolean isRenamed;
        if (data != null && !data.containsKey((Object)"DEFAULT") && !(isRenamed = this.renameParameter(data, "name", "DEFAULT"))) {
            this.renameParameter(data, "id", "DEFAULT");
        }
    }

    protected boolean renameParameter(ParameterMap data, String parameterToRename, String newName) {
        if (data.containsKey((Object)parameterToRename)) {
            List value = data.get((Object)parameterToRename);
            data.remove((Object)parameterToRename);
            data.set((Object)newName, (Collection)value);
            return true;
        }
        return false;
    }

    protected void purgeEmptyEntries(ParameterMap data) {
        Set entries = data.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getValue() != null && !((List)entry.getValue()).isEmpty()) continue;
            data.remove(entry.getKey());
        }
    }
}

