/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.resources.TemplateListOfResource;
import org.glassfish.admin.rest.results.GetResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.RestRedirect;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    protected Dom entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateResource.class);
    private static final List<String> attributesToSkip = new ArrayList<String>(){
        {
            this.add("parent");
            this.add("name");
            this.add("children");
            this.add("submit");
        }
    };

    public void setEntity(Dom p) {
        this.entity = p;
    }

    public Dom getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        this.entity = parent.nodeElement(tagName);
        if (this.entity == null) {
            try {
                Class<? extends ConfigBeanProxy> proxy = TemplateListOfResource.getElementTypeByName(parent, tagName);
                HashMap<String, String> data = new HashMap<String, String>();
                ConfigSupport.createAndSet((ConfigBean)parent, proxy, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.entity = parent.nodeElement(tagName);
        }
    }

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public GetResult getEntity(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.getEntity() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return new GetResult(this.getEntity(), this.getDeleteCommand(), this.getCommandResourcesPaths(), this.options());
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public Response createEntity(HashMap<String, String> data) {
        try {
            this.removeAttributesToBeSkipped(data);
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            ResourceUtil.purgeEmptyEntries(data);
            if ("__deleteoperation".equals(data.get("operation"))) {
                data.remove("operation");
                return this.delete(data);
            }
            HashMap<ConfigBean, Map<String, String>> mapOfChanges = new HashMap<ConfigBean, Map<String, String>>();
            data = ResourceUtil.translateCamelCasedNamesToXMLNames(data);
            mapOfChanges.put((ConfigBean)this.getEntity(), data);
            RestService.getConfigSupport().apply(mapOfChanges);
            String successMessage = localStrings.getLocalString("rest.resource.update.message", "\"{0}\" updated successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
            return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return ResourceUtil.getResponse(400, ex.getMessage(), this.requestHeaders, this.uriInfo);
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected void removeAttributesToBeSkipped(Map<String, String> data) {
        for (String item : attributesToSkip) {
            data.remove(item);
        }
    }

    @DELETE
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded", "application/octet-stream"})
    public Response delete(HashMap<String, String> data) {
        if (this.entity == null) {
            String errorMessage = localStrings.getLocalString("rest.resource.erromessage.noentity", "Resource not found.");
            return ResourceUtil.getResponse(404, errorMessage, this.requestHeaders, this.uriInfo);
        }
        if (this.getDeleteCommand() == null) {
            String message = localStrings.getLocalString("rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.", new Object[]{this.uriInfo.getAbsolutePath()});
            return ResourceUtil.getResponse(403, message, this.requestHeaders, this.uriInfo);
        }
        if (this.getDeleteCommand().equals("GENERIC-DELETE")) {
            try {
                ConfigBean p = (ConfigBean)this.parent;
                if (this.parent == null) {
                    p = (ConfigBean)this.entity.parent();
                }
                ConfigSupport.deleteChild(p, (ConfigBean)this.entity);
                String successMessage = localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
                return ResourceUtil.getDeleteResponse(200, successMessage, this.requestHeaders, this.uriInfo);
            }
            catch (TransactionFailure ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            ResourceUtil.addQueryString((MultivaluedMap<String, String>)this.uriInfo.getQueryParameters(), data);
            ResourceUtil.purgeEmptyEntries(data);
            ResourceUtil.adjustParameters(data);
            if (data.get("DEFAULT") == null) {
                this.addDefaultParameter(data);
            } else {
                String resourceName = this.getResourceName(this.uriInfo.getAbsolutePath().getPath(), "/");
                if (!data.get("DEFAULT").equals(resourceName)) {
                    String errorMessage = localStrings.getLocalString("rest.resource.not.deleted", "Resource not deleted. Value of \"name\" should be the name of this resource.");
                    return ResourceUtil.getResponse(403, errorMessage, this.requestHeaders, this.uriInfo);
                }
            }
            ActionReport actionReport = this.runCommand(this.getDeleteCommand(), data);
            if (actionReport != null) {
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    String successMessage = localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", new Object[]{this.uriInfo.getAbsolutePath()});
                    return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
                }
                String errorMessage = actionReport.getMessage();
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            String message = localStrings.getLocalString("rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.", new Object[]{this.uriInfo.getAbsolutePath()});
            return ResourceUtil.getResponse(403, message, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html;qs=2", "application/xml"})
    public OptionsResult options() {
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        try {
            optionsResult.putMethodMetaData("GET", new MethodMetaData());
            MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData((ConfigBean)this.getEntity());
            postMethodMetaData.setDescription("Update");
            optionsResult.putMethodMetaData("POST", postMethodMetaData);
            String command = this.getDeleteCommand();
            if (command != null) {
                MethodMetaData deleteMethodMetaData;
                if (command.equals("GENERIC-DELETE")) {
                    deleteMethodMetaData = new MethodMetaData();
                } else {
                    deleteMethodMetaData = ResourceUtil.getMethodMetaData(command, RestService.getHabitat(), RestService.logger);
                    deleteMethodMetaData.removeParamMetaData("id");
                }
                optionsResult.putMethodMetaData("DELETE", deleteMethodMetaData);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return optionsResult;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public void post(FormDataMultiPart formData) {
        HashMap<String, String> data = TemplateResource.createDataBasedOnForm(formData);
        this.createEntity(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> createDataBasedOnForm(FormDataMultiPart formData) {
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            Map m1 = formData.getFields();
            Set ss = m1.keySet();
            for (String fieldName : ss) {
                FormDataBodyPart n = formData.getField(fieldName);
                Logger.getLogger(TemplateResource.class.getName()).log(Level.INFO, "fieldName=" + fieldName);
                if (n.getContentDisposition().getFileName() != null) {
                    InputStream fileStream = (InputStream)n.getValueAs(InputStream.class);
                    String mimeType = n.getMediaType().toString();
                    String fileName = n.getContentDisposition().getFileName();
                    if (fileName.contains("/")) {
                        fileName = Util.getName(fileName, '/');
                    } else if (fileName.contains("\\")) {
                        fileName = Util.getName(fileName, '\\');
                    }
                    File f = TemplateResource.saveFile(fileName, mimeType, fileStream);
                    f.deleteOnExit();
                    data.put(fieldName, f.getAbsolutePath());
                    continue;
                }
                try {
                    Logger.getLogger(TemplateResource.class.getName()).log(Level.INFO, "Values=" + fieldName + " === " + n.getValue());
                    data.put(fieldName, n.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            formData.cleanup();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File saveFile(String fileName, String mimeType, InputStream fileStream) {
        FilterOutputStream out = null;
        File f = null;
        try {
            if (fileName.contains(".")) {
                String prefix = fileName.substring(0, fileName.indexOf("."));
                String suffix = fileName.substring(fileName.indexOf("."), fileName.length());
                if (prefix.length() < 3) {
                    prefix = "glassfish" + prefix;
                }
                f = File.createTempFile(prefix, suffix);
            }
            out = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buffer = new byte[32768];
            int bytesRead = 0;
            while ((bytesRead = fileStream.read(buffer)) != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, bytesRead);
            }
            File file = f;
            return file;
        }
        catch (IOException ex) {
            Logger.getLogger(TemplateResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(TemplateResource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public String[][] getCommandResourcesPaths() {
        return new String[0][];
    }

    public String getDeleteCommand() {
        return ResourceUtil.getCommand(RestRedirect.OpType.DELETE, this.getEntity());
    }

    private ActionReport runCommand(String commandName, HashMap<String, String> data) {
        if (commandName != null) {
            String typeOfResult = ResourceUtil.getResultType(this.requestHeaders);
            return ResourceUtil.runCommand(commandName, data, RestService.getHabitat(), typeOfResult);
        }
        return null;
    }

    private void addDefaultParameter(HashMap<String, String> data) {
        int index = this.uriInfo.getAbsolutePath().getPath().lastIndexOf(47);
        String defaultParameterValue = this.getEntity().getKey();
        data.put("DEFAULT", defaultParameterValue);
    }

    private String getResourceName(String absoluteName, String delimiter) {
        if (null == absoluteName) {
            return absoluteName;
        }
        int index = absoluteName.lastIndexOf(delimiter);
        if (index != -1) {
            return absoluteName.substring(index += delimiter.length());
        }
        return absoluteName;
    }

    public void setBeanByKey(List<Dom> parentList, String id) {
        for (Dom c : parentList) {
            String keyvalue;
            String keyAttributeName = null;
            ConfigModel model = c.model;
            if (model.key == null) {
                try {
                    for (String s : model.getAttributeNames()) {
                        if (!s.equals("name")) continue;
                        keyAttributeName = s;
                    }
                    if (keyAttributeName == null) {
                        keyAttributeName = model.getAttributeNames().iterator().next();
                    }
                }
                catch (Exception e) {
                    keyAttributeName = "ThisIsAModelBug:NoKeyAttr";
                }
            } else {
                keyAttributeName = model.key.substring(1, model.key.length());
            }
            if (!(keyvalue = c.attribute(keyAttributeName.toLowerCase())).equals(id)) continue;
            this.setEntity((ConfigBean)c);
        }
    }
}

