/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils.xml;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.admin.rest.utils.xml.XmlEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlObject {
    private String name;
    private Object value;
    private Map<String, Object> children = new HashMap<String, Object>();

    public XmlObject(String name) {
        this(name, null);
    }

    public XmlObject(String name, Object value) {
        this.name = name.toLowerCase();
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    protected Document getDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public XmlObject put(String key, Object child) {
        if (child instanceof String) {
            this.children.put(key, child);
        } else if (child instanceof Number) {
            this.children.put(key, new XmlObject("Number", (Number)child));
        } else if (child instanceof XmlObject) {
            this.children.put(key, (XmlObject)child);
        }
        return this;
    }

    public Object remove(String key) {
        this.children.remove(key);
        return this;
    }

    public int childCount() {
        return this.children.size();
    }

    Node createNode(Document document) {
        Element node = document.createElement(this.getName());
        if (this.value != null) {
            node.setTextContent(this.value.toString());
        }
        Element element = node;
        for (Map.Entry<String, Object> child : this.children.entrySet()) {
            String key = child.getKey();
            Object value = child.getValue();
            if (value instanceof String) {
                element.setAttribute(key, value.toString());
                continue;
            }
            XmlObject obj = (XmlObject)value;
            Element entryNode = document.createElement("entry");
            entryNode.setAttribute("name", obj.getName());
            entryNode.appendChild(obj.createNode(document));
            node.appendChild(entryNode);
        }
        return node;
    }

    public String toString() {
        Document document = this.getDocument();
        document.appendChild(this.createNode(document));
        try {
            DOMSource source = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception ex) {
            Logger.getLogger(XmlEntity.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

