/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.PoolMetaData;
import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectionDefinitionUtils;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ConnectionPoolReconfigHelper;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.connectors.util.SecurityMapUtils;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.resource.listener.UnpooledConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorConnectionPoolAdminServiceImpl
extends ConnectorService {
    private static StringManager localStrings = StringManager.getManager(ConnectorConnectionPoolAdminServiceImpl.class);

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, ConnectionDefDescriptor cdd, String rarName) throws ConnectorRuntimeException {
        if (ccp == null || cdd == null || rarName == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        ConnectorDescriptor connectorDescriptor = _registry.getDescriptor(rarName);
        if (connectorDescriptor == null) {
            String i18nMsg = localStrings.getString("ccp_adm.no_conn_pool_obj", (Object)rarName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound_registry", rarName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        cdi.setRarName(rarName);
        cdi.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        cdi.setConnectionDefinitionName(cdd.getConnectionFactoryIntf());
        cdi.setManagedConnectionFactoryClass(cdd.getManagedConnectionFactoryImpl());
        cdi.setConnectionFactoryClass(cdd.getConnectionFactoryImpl());
        cdi.setConnectionFactoryInterface(cdd.getConnectionFactoryIntf());
        cdi.setConnectionClass(cdd.getConnectionImpl());
        cdi.setConnectionInterface(cdd.getConnectionIntf());
        cdi.setMCFConfigProperties(cdd.getConfigProperties());
        cdi.setResourceAdapterConfigProperties(connectorDescriptor.getConfigProperties());
        this.createConnectorConnectionPool(ccp, cdi);
    }

    private void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj, ConnectorDescriptorInfo connectorDescInfo) throws ConnectorRuntimeException {
        connectorPoolObj.setConnectorDescriptorInfo(connectorDescInfo);
        this.createConnectorConnectionPool(connectorPoolObj);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj) throws ConnectorRuntimeException {
        String poolName = connectorPoolObj.getName();
        if (connectorPoolObj == null || poolName == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
        try {
            this._runtime.getNamingManager().publishObject(jndiNameForPool, (Object)connectorPoolObj, true);
            ManagedConnectionFactory mcf = this.obtainManagedConnectionFactory(poolName);
            if (mcf == null) {
                Context ic = this._runtime.getNamingManager().getInitialContext();
                ic.unbind(jndiNameForPool);
                String i18nMsg = localStrings.getString("ccp_adm.failed_to_create_mcf", (Object)poolName);
                ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
                _logger.log(Level.SEVERE, "rardeployment.mcf_creation_failure", poolName);
                _logger.log(Level.SEVERE, "", cre);
                throw cre;
            }
        }
        catch (NamingException ex) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_publish_in_jndi", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ex);
            _logger.log(Level.SEVERE, "rardeployment.pool_jndi_bind_failure", poolName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (NullPointerException ex) {
            try {
                Context ic = this._runtime.getNamingManager().getInitialContext();
                ic.unbind(jndiNameForPool);
            }
            catch (NamingException ne) {
                _logger.log(Level.FINE, "Failed to unbind connection pool object  ", poolName);
            }
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_register_mcf", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ex);
            _logger.log(Level.SEVERE, "rardeployment.mcf_registration_failure", poolName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj, String security, Set configProperties) throws ConnectorRuntimeException {
        if (connectorPoolObj == null || configProperties == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        String poolName = connectorPoolObj.getName();
        String moduleName = connectorPoolObj.getConnectorDescriptorInfo().getRarName();
        String connectionDefinitionName = connectorPoolObj.getConnectorDescriptorInfo().getConnectionDefinitionName();
        ConnectorDescriptor connectorDescriptor = _registry.getDescriptor(moduleName);
        if (connectorDescriptor == null) {
            String i18nMsg = localStrings.getString("ccp_adm.null_connector_desc", (Object)moduleName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.null_mcf_in_registry", moduleName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        Set connectionDefs = connectorDescriptor.getOutboundResourceAdapter().getConnectionDefs();
        Iterator iterator = connectionDefs.iterator();
        ConnectionDefDescriptor connectionDefDescriptor = null;
        while (iterator.hasNext() && !connectionDefinitionName.equals((connectionDefDescriptor = (ConnectionDefDescriptor)iterator.next()).getConnectionFactoryIntf())) {
        }
        ConnectorDescriptorInfo connectorDescInfo = ConnectorDDTransformUtils.getConnectorDescriptorInfo(connectionDefDescriptor);
        connectorDescInfo.setMCFConfigProperties(configProperties);
        connectorDescInfo.setRarName(moduleName);
        connectorDescInfo.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        this.createConnectorConnectionPool(connectorPoolObj, connectorDescInfo);
    }

    public void deleteConnectorConnectionPool(String poolName) throws ConnectorRuntimeException {
        this.deleteConnectorConnectionPool(poolName, false);
    }

    public void deleteConnectorConnectionPool(String poolName, boolean cascade) throws ConnectorRuntimeException {
        if (poolName == null) {
            _logger.log(Level.WARNING, "ccp_adm.null_pool_name");
            String i18nMsg = localStrings.getString("ccp_adm.null_pool_name");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        boolean errorOccured = false;
        this.killPool(poolName);
        boolean result = _registry.removeManagedConnectionFactory(poolName);
        if (!result) {
            _logger.log(Level.FINE, "rardeployment.mcf_removal_failure", poolName);
            return;
        }
        try {
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            Context ic = this._runtime.getNamingManager().getInitialContext();
            ic.unbind(jndiNameForPool);
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_removal_from_jndi_error", poolName);
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_remove_from_jndi", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        if (errorOccured) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_delete_conn_res", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.all_resources_removal_error", poolName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
    }

    public void killPool(String poolName) {
        this._runtime.getPoolManager().killPool(poolName);
    }

    public static Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName, String resType) {
        return ConnectionDefinitionUtils.getConnectionDefinitionPropertiesAndDefaults(connectionDefinitionClassName, resType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testConnectionPool(String poolName) throws ResourceException {
        Object con = null;
        try {
            try {
                con = this.getUnpooledConnection(poolName, null, false);
            }
            catch (Exception re) {
                Object[] params = new Object[]{poolName, re.getMessage()};
                _logger.log(Level.WARNING, "test.connection.pool.failed", params);
                ResourceException e = new ResourceException("Ping failed Exception - " + re.getMessage() + " Please check the server.log for more details.");
                e.initCause((Throwable)re);
                throw e;
            }
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            try {
                ((ManagedConnection)con).destroy();
                throw throwable;
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable e) {}
        ((ManagedConnection)con).destroy();
        return true;
    }

    protected Subject getDefaultSubject(String poolName, ManagedConnectionFactory mcf, ResourcePrincipal prin) throws ResourceException {
        ResourcePrincipal resourcePrincipal = null;
        if (prin == null) {
            try {
                resourcePrincipal = this.getDefaultResourcePrincipal(poolName, mcf);
            }
            catch (NamingException ne) {
                _logger.log(Level.WARNING, "jdbc.pool_not_reachable", ne.getMessage());
                String l10nMsg = localStrings.getString("pingpool.name_not_bound", (Object)poolName);
                ResourceException e = new ResourceException(l10nMsg + poolName);
                e.initCause((Throwable)ne);
                throw e;
            }
        } else {
            resourcePrincipal = prin;
        }
        Subject defaultSubject = ConnectionPoolObjectsUtils.createSubject(mcf, resourcePrincipal);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("using subject: " + defaultSubject);
        }
        return defaultSubject;
    }

    protected ManagedConnection getManagedConnection(ManagedConnectionFactory mcf, Subject defaultSubject, ConnectionRequestInfo cReqInfo) throws ResourceException {
        ManagedConnection mc = null;
        mc = mcf.createManagedConnection(defaultSubject, cReqInfo);
        return mc;
    }

    public Object getUnpooledConnection(String poolName, ResourcePrincipal principal, boolean returnConnectionHandle) throws ResourceException {
        ManagedConnectionFactory mcf = null;
        ResourcePool poolToDeploy = null;
        boolean needToUndeployPool = false;
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        try {
            if (!this.isPoolReferredByDatabaseResource(poolName) && _registry.isMCFCreated(poolName)) {
                this.unloadAndKillPool(poolName);
            }
            mcf = this.obtainManagedConnectionFactory(poolName, new Hashtable());
        }
        catch (ConnectorRuntimeException re) {
            this.logFine("getUnpooledConnection :: obtainManagedConnectionFactory threw exception. So doing checkAndLoadPoolResource");
            if (this.checkAndLoadPool(poolName)) {
                this.logFine("getUnpooledConnection:: checkAndLoadPoolResource is true");
                try {
                    if (!this.isConnectorConnectionPoolDeployed(poolName)) {
                        this.logFine("getUnpooledConnection :: isConnectorConnectionPoolDeployed is false");
                        try {
                            poolToDeploy = (ResourcePool)runtime.getResources().getResourceByName(ResourcePool.class, poolName);
                            runtime.getResourceDeployer(poolToDeploy).deployResource((Object)poolToDeploy);
                            this.logFine("getUnpooledConnection :: force deployed the ConnectionPool : " + poolName);
                            needToUndeployPool = true;
                        }
                        catch (Exception e) {
                            _logger.log(Level.SEVERE, "jdbc.could_not_do_actual_deploy for : ", poolName);
                            throw new ResourceException((Throwable)e);
                        }
                    }
                    this.logFine("getUnpooledConnection :: Now calling obtainManagedConnectionFactory again");
                    mcf = this.obtainManagedConnectionFactory(poolName);
                    this.logFine("getUnpooledConnection:: done obtainManagedConnectionFactory again");
                }
                catch (ConnectorRuntimeException creAgain) {
                    String l10nMsg = localStrings.getString("pingpool.cannot_obtain_mcf", (Object)poolName);
                    _logger.log(Level.WARNING, "jdbc.pool_not_reachable", l10nMsg);
                    ResourceException e = new ResourceException(l10nMsg);
                    e.initCause((Throwable)creAgain);
                    throw e;
                }
            }
            _logger.log(Level.WARNING, "jdbc.pool_not_reachable", re.getMessage());
            String l10nMsg = localStrings.getString("pingpool.cannot_obtain_mcf", (Object)poolName);
            ResourceException e = new ResourceException(l10nMsg);
            e.initCause((Throwable)re);
            throw e;
        }
        ResourcePrincipal resourcePrincipal = null;
        if (principal == null) {
            try {
                resourcePrincipal = this.getDefaultResourcePrincipal(poolName, mcf);
            }
            catch (NamingException ne) {
                _logger.log(Level.WARNING, "jdbc.pool_not_reachable", ne.getMessage());
                String l10nMsg = localStrings.getString("pingpool.name_not_bound", (Object)poolName);
                ResourceException e = new ResourceException(l10nMsg + poolName);
                e.initCause((Throwable)ne);
                throw e;
            }
        } else {
            resourcePrincipal = principal;
        }
        Subject defaultSubject = ConnectionPoolObjectsUtils.createSubject(mcf, resourcePrincipal);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("using subject: " + defaultSubject);
        }
        ManagedConnection mc = mcf.createManagedConnection(defaultSubject, null);
        if (needToUndeployPool && poolToDeploy != null) {
            this.logFine("getUnpooledConnection :: need to force undeploy pool");
            try {
                runtime.getResourceDeployer(poolToDeploy).undeployResource((Object)poolToDeploy);
            }
            catch (Exception e) {
                _logger.fine("getUnpooledConnection: error undeploying pool");
            }
            this.logFine("getUnpooledConnection :: done.. force undeploy of pool");
        }
        mc.addConnectionEventListener((ConnectionEventListener)new UnpooledConnectionEventListener());
        return returnConnectionHandle ? mc.getConnection(defaultSubject, null) : mc;
    }

    private boolean isPoolReferredByDatabaseResource(String poolName) {
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        return resUtil.isJdbcPoolReferredInServerInstance(poolName);
    }

    protected String getPropertyValue(String prop, ConnectorConnectionPool connectorConnectionPool) {
        String result = null;
        ConnectorDescriptorInfo cdi = connectorConnectionPool.getConnectorDescriptorInfo();
        Set mcfConfigProperties = cdi.getMCFConfigProperties();
        for (ConnectorConfigProperty envProp : mcfConfigProperties) {
            if (!envProp.getName().toUpperCase().equals(prop)) continue;
            result = envProp.getValue();
        }
        return result;
    }

    private ResourcePrincipal getDefaultResourcePrincipal(String poolName, ManagedConnectionFactory mcf) throws NamingException {
        return this.getDefaultResourcePrincipal(poolName, mcf, null);
    }

    private ResourcePrincipal getDefaultResourcePrincipal(String poolName, ManagedConnectionFactory mcf, Hashtable env) throws NamingException {
        String userName = null;
        String password = null;
        ConnectorConnectionPool connectorConnectionPool = null;
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
        InitialContext ic = env != null ? new InitialContext(env) : new InitialContext();
        connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
        userName = this.getPropertyValue("USERNAME", connectorConnectionPool);
        if (userName == null) {
            userName = this.getPropertyValue("USER", connectorConnectionPool);
        }
        password = this.getPropertyValue("PASSWORD", connectorConnectionPool);
        try {
            password = RelativePathResolver.getRealPasswordFromAlias((String)password);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "unable_to_get_password_from_alias", e);
        }
        if (userName == null || userName.trim().equals("")) {
            userName = ConnectionPoolObjectsUtils.getValueFromMCF("UserName", poolName, mcf);
            if (userName.trim().equals("")) {
                userName = ConnectionPoolObjectsUtils.getValueFromMCF("User", poolName, mcf);
            }
            password = ConnectionPoolObjectsUtils.getValueFromMCF("Password", poolName, mcf);
        }
        return new ResourcePrincipal(userName, password);
    }

    public void switchOnMatching(String poolName) throws ConnectorRuntimeException {
        try {
            ConnectorConnectionPool origCcp = this.getOriginalConnectorConnectionPool(poolName);
            origCcp.setMatchConnections(true);
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            this._runtime.getNamingManager().getInitialContext().unbind(jndiNameForPool);
            this._runtime.getNamingManager().publishObject(jndiNameForPool, (Object)origCcp, true);
        }
        catch (NamingException e) {
            ConnectorRuntimeException ex = new ConnectorRuntimeException(e.getMessage());
            throw (ConnectorRuntimeException)ex.initCause((Throwable)e);
        }
    }

    private ConnectorConnectionPool getOriginalConnectorConnectionPool(String poolName) throws NamingException {
        ConnectorConnectionPool ccpOrig = null;
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
        ccpOrig = (ConnectorConnectionPool)this._runtime.getNamingManager().getInitialContext().lookup(jndiNameForPool);
        return ccpOrig;
    }

    private ConnectorConnectionPool getConnectorConnectionPool(String poolName) throws ConnectorRuntimeException, NamingException {
        return this.getConnectorConnectionPool(poolName, null);
    }

    private ConnectorConnectionPool getConnectorConnectionPool(String poolName, Hashtable env) throws ConnectorRuntimeException, NamingException {
        String jndiNameForPool;
        InitialContext ic = env != null ? new InitialContext(env) : new InitialContext();
        ConnectorConnectionPool connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName));
        if (connectorConnectionPool == null) {
            String i18nMsg = localStrings.getString("ccp_adm.null_pool", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_object_null", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        return connectorConnectionPool;
    }

    private ActiveResourceAdapter getResourceAdapter(ConnectorConnectionPool connectorConnectionPool) throws ConnectorRuntimeException {
        String rarName = connectorConnectionPool.getConnectorDescriptorInfo().getRarName();
        ActiveResourceAdapter activeResourceAdapter = this.getActiveResourceAdapter(rarName);
        if (activeResourceAdapter == null) {
            String i18nMsg = localStrings.getString("ccp_adm.active_ra_not_init", (Object)rarName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.resourceadapter_not_initialized", rarName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        return activeResourceAdapter;
    }

    private ActiveResourceAdapter getActiveResourceAdapter(String rarName) throws ConnectorRuntimeException {
        ActiveResourceAdapter activeResourceAdapter = _registry.getActiveResourceAdapter(rarName);
        if (activeResourceAdapter == null) {
            this.ifSystemRarLoad(rarName);
            activeResourceAdapter = _registry.getActiveResourceAdapter(rarName);
        }
        return activeResourceAdapter;
    }

    public ManagedConnectionFactory[] obtainManagedConnectionFactories(String poolName) throws ConnectorRuntimeException {
        ManagedConnectionFactory[] mcfs = null;
        String raName = null;
        try {
            ConnectorConnectionPool conPool = this.getConnectorConnectionPool(poolName);
            ActiveResourceAdapter activeResourceAdapter = this.getResourceAdapter(conPool);
            raName = activeResourceAdapter.getModuleName();
            mcfs = activeResourceAdapter.createManagedConnectionFactories(conPool, null);
        }
        catch (NamingException ne) {
            String i18nMsg = localStrings.getString("pingpool.name_not_bound", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ne);
            _logger.log(Level.FINE, "rardeployment.jndi_lookup_failed", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        catch (NullPointerException ne) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_register_mcf", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, "mcf_add_toregistry_failed", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        for (ManagedConnectionFactory mcf : mcfs) {
            this.validateMCF(mcf, raName);
        }
        return mcfs;
    }

    private void validateMCF(ManagedConnectionFactory mcf, String raName) {
        this._runtime.getConnectorBeanValidator().validateJavaBean(mcf, raName);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(String poolName) throws ConnectorRuntimeException {
        return this.obtainManagedConnectionFactory(poolName, null);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(String poolName, Hashtable env) throws ConnectorRuntimeException {
        try {
            ClassLoader loader;
            if (_registry.isMCFCreated(poolName)) {
                return _registry.getManagedConnectionFactory(poolName);
            }
            ConnectorConnectionPool connectorConnectionPool = this.getConnectorConnectionPool(poolName, env);
            ActiveResourceAdapter activeResourceAdapter = this.getResourceAdapter(connectorConnectionPool);
            ManagedConnectionFactory mcf = activeResourceAdapter.createManagedConnectionFactory(connectorConnectionPool, loader = activeResourceAdapter.getClassLoader());
            if (mcf != null) {
                String str;
                this.validateMCF(mcf, activeResourceAdapter.getModuleName());
                ResourcePrincipal prin = this.getDefaultResourcePrincipal(poolName, mcf, env);
                Subject s = ConnectionPoolObjectsUtils.createSubject(mcf, prin);
                int txSupport = connectorConnectionPool.getTransactionSupport();
                if (mcf instanceof TransactionSupport) {
                    TransactionSupport.TransactionSupportLevel mcfTS = ((TransactionSupport)mcf).getTransactionSupport();
                    int containerTxSupport = ConnectionPoolObjectsUtils.convertSpecTxSupportToContainerTxSupport(mcfTS);
                    boolean isValidTxSupportLevel = ConnectionPoolObjectsUtils.isTxSupportConfigurationSane(containerTxSupport, activeResourceAdapter.getModuleName());
                    if (isValidTxSupportLevel) {
                        txSupport = containerTxSupport;
                    } else {
                        Object[] params = new Object[]{mcfTS, activeResourceAdapter.getModuleName()};
                        String i18nMsg = localStrings.getString("ccp_adm_service.incorrect_tx_support", params);
                        ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
                        _logger.log(Level.SEVERE, "rardeployment.incorrect_tx_support", connectorConnectionPool.getName());
                        throw cre;
                    }
                }
                boolean isPM = false;
                boolean isNonTx = connectorConnectionPool.isNonTransactional();
                ConnectorSecurityMap[] securityMaps = connectorConnectionPool.getSecurityMaps();
                RuntimeSecurityMap runtimeSecurityMap = SecurityMapUtils.processSecurityMaps(securityMaps);
                boolean lazyEnlistable = connectorConnectionPool.isLazyConnectionEnlist();
                boolean lazyAssoc = connectorConnectionPool.isLazyConnectionAssoc();
                if (isPM || isNonTx) {
                    lazyEnlistable = false;
                }
                if (isPM && lazyAssoc && (str = System.getProperty("com.sun.enterprise.resource.AllowLazyAssociationWithPM", "FALSE")).toUpperCase().trim().equals("FALSE")) {
                    lazyAssoc = false;
                }
                PoolMetaData pmd = new PoolMetaData(poolName, mcf, s, txSupport, prin, isPM, isNonTx, lazyEnlistable, runtimeSecurityMap, lazyAssoc);
                this.logFine(pmd.toString());
                _registry.addManagedConnectionFactory(poolName, pmd);
            }
            ConnectorConstants.PoolType pt = this.getPoolType(connectorConnectionPool);
            this.createAndAddPool(poolName, pt, env);
            return mcf;
        }
        catch (NamingException ne) {
            String i18nMsg = localStrings.getString("pingpool.name_not_bound", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ne);
            _logger.log(Level.FINE, "rardeployment.jndi_lookup_failed", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
        catch (NullPointerException ne) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_register_mcf", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, "mcf_add_toregistry_failed", poolName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "", cre);
            }
            throw cre;
        }
    }

    private ConnectorConstants.PoolType getPoolType(ConnectorConnectionPool connectorConnectionPool) {
        ConnectorConstants.PoolType pt = ConnectorConstants.PoolType.STANDARD_POOL;
        if (!connectorConnectionPool.isPoolingOn()) {
            pt = ConnectorConstants.PoolType.POOLING_DISABLED;
        } else if (connectorConnectionPool.isAssociateWithThread()) {
            pt = ConnectorConstants.PoolType.ASSOCIATE_WITH_THREAD_POOL;
        } else if (connectorConnectionPool.isPartitionedPool()) {
            pt = ConnectorConstants.PoolType.PARTITIONED_POOL;
        }
        return pt;
    }

    public ConnectorConstants.PoolType getPoolType(String poolName) throws ConnectorRuntimeException {
        ConnectorConnectionPool ccp;
        try {
            ccp = this.getConnectorConnectionPool(poolName);
        }
        catch (NamingException e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
        return this.getPoolType(ccp);
    }

    private void logFine(String msg) {
        if (msg != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    private void createAndAddPool(String poolName, ConnectorConstants.PoolType pt, Hashtable env) throws ConnectorRuntimeException {
        PoolManager poolMgr = this._runtime.getPoolManager();
        try {
            poolMgr.createEmptyConnectionPool(poolName, pt, env);
        }
        catch (PoolingException pe) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_create_pool_object");
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)pe);
            throw cre;
        }
    }

    public boolean isConnectorConnectionPoolDeployed(String poolName) {
        try {
            Context ic = ConnectorRuntime.getRuntime().getNamingManager().getInitialContext();
            String jndiName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            ic.lookup(jndiName);
            return true;
        }
        catch (NamingException e) {
            return false;
        }
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        if (ccp == null) {
            throw new ConnectorRuntimeException("No pool to reconfigure, new pool object is null");
        }
        this.logFine("new ccp :\n" + ccp.toString());
        String poolName = ccp.getName();
        ConnectorConnectionPool origCcp = null;
        try {
            origCcp = this.getOriginalConnectorConnectionPool(poolName);
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException(ne.getMessage());
        }
        if (origCcp == null) {
            throw new ConnectorRuntimeException("No pool to reconfigure, original pool object is null");
        }
        this.logFine("original ccp :\n" + origCcp.toString());
        ConnectionPoolReconfigHelper.ReconfigAction action = ConnectionPoolReconfigHelper.compare(origCcp, ccp, excludedProps);
        this.logFine("pool reconfig action == " + (Object)((Object)action));
        if (action == ConnectionPoolReconfigHelper.ReconfigAction.UPDATE_MCF_AND_ATTRIBUTES) {
            this.updateMCFAndPoolAttributes(ccp);
        } else if (action == ConnectionPoolReconfigHelper.ReconfigAction.RECREATE_POOL) {
            return true;
        }
        return false;
    }

    private void updateMCFAndPoolAttributes(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        String poolName = ccp.getName();
        try {
            ConnectorConnectionPool origCcp = this.getOriginalConnectorConnectionPool(poolName);
            origCcp.setSteadyPoolSize(ccp.getSteadyPoolSize());
            origCcp.setMaxPoolSize(ccp.getMaxPoolSize());
            origCcp.setMaxWaitTimeInMillis(ccp.getMaxWaitTimeInMillis());
            origCcp.setPoolResizeQuantity(ccp.getPoolResizeQuantity());
            origCcp.setIdleTimeoutInSeconds(ccp.getIdleTimeoutInSeconds());
            origCcp.setFailAllConnections(ccp.isFailAllConnections());
            origCcp.setMatchConnections(ccp.matchConnections());
            origCcp.setMaxConnectionUsage(ccp.getMaxConnectionUsage());
            origCcp.setNonComponent(ccp.isNonComponent());
            origCcp.setNonTransactional(ccp.isNonTransactional());
            origCcp.setConCreationRetryAttempts(ccp.getConCreationRetryAttempts());
            origCcp.setConCreationRetryInterval(ccp.getConCreationRetryInterval());
            origCcp.setValidateAtmostOncePeriod(ccp.getValidateAtmostOncePeriod());
            origCcp.setConnectionLeakTracingTimeout(ccp.getConnectionLeakTracingTimeout());
            origCcp.setConnectionReclaim(ccp.isConnectionReclaim());
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            InitialContext ic = new InitialContext();
            ic.unbind(jndiNameForPool);
            this._runtime.getNamingManager().publishObject(jndiNameForPool, (Object)origCcp, true);
        }
        catch (NamingException ne) {
            throw new ConnectorRuntimeException(ne.getMessage());
        }
        PoolManager poolMgr = this._runtime.getPoolManager();
        try {
            poolMgr.reconfigPoolProperties(ccp);
        }
        catch (PoolingException pe) {
            throw new ConnectorRuntimeException(pe.getMessage());
        }
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        ManagedConnectionFactory mcf = registry.getManagedConnectionFactory(poolName);
        SetMethodAction sma = new SetMethodAction(mcf, ccp.getConnectorDescriptorInfo().getMCFConfigProperties());
        try {
            sma.run();
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
        PoolMetaData pmd = registry.getPoolMetaData(poolName);
        pmd.setIsPM(ccp.isNonComponent());
        pmd.setIsNonTx(ccp.isNonTransactional());
        pmd.setAuthCredentialsDefinedInPool(ccp.getAuthCredentialsDefinedInPool());
        this.logFine("Pool properties reconfiguration done");
    }

    /*
     * Loose catch block
     */
    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        block11: {
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            if (registry == null) {
                throw new ConnectorRuntimeException("Cannot get ConnectorRegistry");
            }
            String poolName = ccp.getName();
            this.unloadAndKillPool(poolName);
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            ManagedConnectionFactory mcf = null;
            this._runtime.getNamingManager().publishObject(jndiNameForPool, (Object)ccp, true);
            mcf = this.obtainManagedConnectionFactory(poolName);
            Object var10_7 = null;
            if (mcf != null) break block11;
            try {
                Context ic = this._runtime.getNamingManager().getInitialContext();
                ic.unbind(jndiNameForPool);
            }
            catch (NamingException e) {
                _logger.log(Level.WARNING, "Unable to unbind the pool configuration object of pool [ " + poolName + " ] during MCF creation failure");
            }
            _logger.log(Level.WARNING, "rardeployment.mcf_creation_failure", poolName);
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_create_mcf", (Object)poolName);
            throw new ConnectorRuntimeException(i18nMsg);
            {
                catch (NamingException ne) {
                    _logger.log(Level.SEVERE, "rardeployment.pool_jndi_bind_failure", poolName);
                    String i18nMsg2 = localStrings.getString("ccp_adm.could_not_recreate_pool", (Object)poolName);
                    ConnectorRuntimeException crex = new ConnectorRuntimeException(i18nMsg2);
                    crex.initCause((Throwable)ne);
                    throw crex;
                }
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (mcf == null) {
                    try {
                        Context ic = this._runtime.getNamingManager().getInitialContext();
                        ic.unbind(jndiNameForPool);
                    }
                    catch (NamingException e) {
                        _logger.log(Level.WARNING, "Unable to unbind the pool configuration object of pool [ " + poolName + " ] during MCF creation failure");
                    }
                    _logger.log(Level.WARNING, "rardeployment.mcf_creation_failure", poolName);
                    i18nMsg = localStrings.getString("ccp_adm.failed_to_create_mcf", (Object)poolName);
                    throw new ConnectorRuntimeException(i18nMsg);
                }
                throw throwable;
            }
        }
    }

    private void unloadAndKillPool(String poolName) throws ConnectorRuntimeException {
        this.killPool(poolName);
        boolean result = _registry.removeManagedConnectionFactory(poolName);
        if (!result) {
            _logger.log(Level.SEVERE, "rardeployment.mcf_removal_failure", poolName);
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.FINE, "", cre);
            throw cre;
        }
        try {
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            Context ic = ConnectorRuntime.getRuntime().getNamingManager().getInitialContext();
            ic.unbind(jndiNameForPool);
        }
        catch (NamingException ne) {
            String i18nMsg = localStrings.getString("ccp_adm.failed_to_remove_from_jndi", (Object)poolName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, "rardeployment.connectionpool_removal_from_jndi_error", poolName);
            _logger.log(Level.FINE, "", cre);
            throw cre;
        }
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, List<Property> props, List<SecurityMap> securityMaps) throws ConnectorRuntimeException {
        if (ccp == null || connectionDefinitionName == null || rarName == null) {
            _logger.log(Level.FINE, "Wrong parameters for pool creation ");
            String i18nMsg = localStrings.getString("ccp_adm.wrong_params_for_create");
            throw new ConnectorRuntimeException(i18nMsg);
        }
        ConnectorDescriptor connectorDescriptor = _registry.getDescriptor(rarName);
        if (connectorDescriptor == null) {
            String i18nMsg = localStrings.getString("ccp_adm.no_conn_pool_obj", (Object)rarName);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_notfound_registry", rarName);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        Set connectionDefs = connectorDescriptor.getOutboundResourceAdapter().getConnectionDefs();
        ConnectionDefDescriptor cdd = null;
        Iterator it = connectionDefs.iterator();
        while (it.hasNext() && !connectionDefinitionName.equals((cdd = (ConnectionDefDescriptor)it.next()).getConnectionFactoryIntf())) {
        }
        ConnectorDescriptorInfo cdi = new ConnectorDescriptorInfo();
        cdi.setRarName(rarName);
        cdi.setResourceAdapterClassName(connectorDescriptor.getResourceAdapterClass());
        cdi.setConnectionDefinitionName(cdd.getConnectionFactoryIntf());
        cdi.setManagedConnectionFactoryClass(cdd.getManagedConnectionFactoryImpl());
        cdi.setConnectionFactoryClass(cdd.getConnectionFactoryImpl());
        cdi.setConnectionFactoryInterface(cdd.getConnectionFactoryIntf());
        cdi.setConnectionClass(cdd.getConnectionImpl());
        cdi.setConnectionInterface(cdd.getConnectionIntf());
        Set mergedProps = ConnectorDDTransformUtils.mergeProps(props, cdd.getConfigProperties());
        cdi.setMCFConfigProperties(mergedProps);
        cdi.setResourceAdapterConfigProperties(connectorDescriptor.getConfigProperties());
        ccp.setSecurityMaps(SecurityMapUtils.getConnectorSecurityMaps(securityMaps));
        this.createConnectorConnectionPool(ccp, cdi);
    }

    public boolean flushConnectionPool(String poolName) throws ConnectorRuntimeException {
        PoolManager poolMgr = this._runtime.getPoolManager();
        try {
            return poolMgr.flushConnectionPool(poolName);
        }
        catch (PoolingException ex) {
            throw new ConnectorRuntimeException(ex.getMessage());
        }
    }

    public Connection getConnection(String jndiName, String user, String password) throws SQLException {
        Connection con = null;
        try {
            String poolName = this.getPoolNameFromResourceJndiName(jndiName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ConnectorRuntime.getConnection :: poolName : " + poolName);
            }
            String passwd = password == null ? "" : password;
            ResourcePrincipal prin = user == null ? null : new ResourcePrincipal(user, password);
            con = (Connection)this.getUnpooledConnection(poolName, prin, true);
            if (con == null) {
                String i18nMsg = localStrings.getString("ccp_adm.null_unpooled_connection");
                throw new SQLException(i18nMsg);
            }
        }
        catch (ResourceException re) {
            SQLException sqle = new SQLException(re.getMessage());
            sqle.initCause(re);
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" getConnection in ConnectorRuntime failed : " + (Object)((Object)re));
            }
            throw sqle;
        }
        catch (Exception ex) {
            SQLException sqle = new SQLException(ex.getMessage());
            sqle.initCause(ex);
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", ex.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" getConnection in ConnectorRuntime failed : " + ex);
            }
            throw sqle;
        }
        return con;
    }

    public Connection getConnection(String jndiName) throws SQLException {
        Connection con = null;
        try {
            String poolName = this.getPoolNameFromResourceJndiName(jndiName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ConnectorRuntime.getConnection :: poolName : " + poolName);
            }
            if ((con = (Connection)this.getUnpooledConnection(poolName, null, true)) == null) {
                String i18nMsg = localStrings.getString("ccp_adm.null_unpooled_connection");
                throw new SQLException(i18nMsg);
            }
        }
        catch (ResourceException re) {
            SQLException sqle = new SQLException(re.getMessage());
            sqle.initCause(re);
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Exception : " + (Object)((Object)re));
            }
            throw sqle;
        }
        catch (Exception ex) {
            SQLException sqle = new SQLException(ex.getMessage());
            sqle.initCause(ex);
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", ex.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" getConnection in ConnectorRuntime failed : " + ex);
            }
            throw sqle;
        }
        return con;
    }

    private String getPoolNameFromResourceJndiName(String jndiName) {
        JdbcResource jdbcResource = null;
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        jdbcResource = (JdbcResource)runtime.getResources().getResourceByName(JdbcResource.class, jndiName);
        if (jdbcResource != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine("jdbcRes is ---: " + jdbcResource.getJndiName());
            _logger.fine("poolName is ---: " + jdbcResource.getPoolName());
        }
        return jdbcResource == null ? null : jdbcResource.getPoolName();
    }
}

