/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class GMSConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Clusters clusters;

    public void postConstruct() {
        this.upgradeClusterElements();
    }

    private void upgradeClusterElements() {
        try {
            List clusterList = this.clusters.getCluster();
            for (Cluster cl : clusterList) {
                ConfigSupport.apply(new ClusterConfigCode(), cl);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading cluster data from V2 to V3", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterConfigCode
    implements SingleConfigCode<Cluster> {
        private ClusterConfigCode() {
        }

        @Override
        public Object run(Cluster cluster) throws PropertyVetoException, TransactionFailure {
            cluster.setGmsEnabled(cluster.getHeartbeatEnabled());
            cluster.setGmsMulticastAddress(cluster.getHeartbeatAddress());
            cluster.setGmsMulticastPort(cluster.getHeartbeatPort());
            cluster.setGmsBindInterfaceAddress(String.format("${GMS-BIND-INTERFACE-ADDRESS-%s}", cluster.getName()));
            return cluster;
        }
    }
}

