/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.internal.api.MasterPassword;
import org.jvnet.hk2.component.Habitat;

public class NodeUtils {
    static final String NODE_DEFAULT_SSH_PORT = "22";
    static final String NODE_DEFAULT_SSH_USER = "${user.name}";
    static final String NODE_DEFAULT_INSTALLDIR = "${com.sun.aas.installRoot}";
    static final String PARAM_NODEHOST = "nodehost";
    static final String PARAM_INSTALLDIR = "installdir";
    static final String PARAM_NODEDIR = "nodedir";
    static final String PARAM_SSHPORT = "sshport";
    static final String PARAM_SSHUSER = "sshuser";
    static final String PARAM_SSHKEYFILE = "sshkeyfile";
    static final String PARAM_SSHPASSWORD = "sshpassword";
    static final String PARAM_SSHKEYPASSPHRASE = "sshkeypassphrase";
    static final String PARAM_TYPE = "type";
    private static final String NL = System.getProperty("line.separator");
    private TokenResolver resolver = null;
    private Logger logger = null;
    private Habitat habitat = null;

    NodeUtils(Habitat habitat, Logger logger) {
        this.logger = logger;
        this.habitat = habitat;
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
    }

    void validate(ParameterMap map, SSHLauncher sshL) throws CommandValidationException {
        String sshkeyfile = (String)map.getOne((Object)PARAM_SSHKEYFILE);
        if (StringUtils.ok((String)sshkeyfile)) {
            File kfile = new File(this.resolver.resolve(sshkeyfile));
            if (!kfile.isAbsolute()) {
                throw new CommandValidationException(Strings.get("key.path.not.absolute", kfile.getPath()));
            }
            if (!kfile.exists()) {
                throw new CommandValidationException(Strings.get("key.path.not.found", kfile.getPath()));
            }
            if (!kfile.canRead()) {
                throw new CommandValidationException(Strings.get("key.path.not.readable", kfile.getPath(), System.getProperty("user.name")));
            }
        }
        this.validatePassword((String)map.getOne((Object)PARAM_SSHPASSWORD));
        this.validatePassword((String)map.getOne((Object)PARAM_SSHKEYPASSPHRASE));
        if (sshL != null) {
            this.validateSSHConnection(map, sshL);
        }
    }

    private void validatePassword(String p) throws CommandValidationException {
        String expandedPassword;
        if (StringUtils.ok((String)p) && (expandedPassword = this.expandPasswordAlias(p)) == null) {
            throw new CommandValidationException(Strings.get("no.such.password.alias", p));
        }
    }

    private void validateSSHConnection(ParameterMap map, SSHLauncher sshL) throws CommandValidationException {
        String nodehost = (String)map.getOne((Object)PARAM_NODEHOST);
        String installdir = (String)map.getOne((Object)PARAM_INSTALLDIR);
        String nodedir = (String)map.getOne((Object)PARAM_NODEDIR);
        String sshport = (String)map.getOne((Object)PARAM_SSHPORT);
        String sshuser = (String)map.getOne((Object)PARAM_SSHUSER);
        String sshkeyfile = (String)map.getOne((Object)PARAM_SSHKEYFILE);
        String sshpassword = (String)map.getOne((Object)PARAM_SSHPASSWORD);
        String sshkeypassphrase = (String)map.getOne((Object)PARAM_SSHKEYPASSPHRASE);
        if (!NetUtils.isPortStringValid((String)this.resolver.resolve(sshport))) {
            throw new CommandValidationException(Strings.get("ssh.invalid.port", sshport));
        }
        int port = Integer.parseInt(this.resolver.resolve(sshport));
        try {
            sshL.validate(this.resolver.resolve(nodehost), port, this.resolver.resolve(sshuser), this.resolver.resolve(sshkeyfile), this.resolver.resolve(installdir), this.logger);
        }
        catch (IOException e) {
            String m1 = e.getMessage();
            String m2 = "";
            Throwable e2 = e.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            if (e instanceof FileNotFoundException) {
                this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{m1, m2, sshL.toString()}));
                throw new CommandValidationException(StringUtils.cat((String)NL, (String[])new String[]{m1, m2}));
            }
            String msg = Strings.get("ssh.bad.connect", nodehost);
            this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{msg, m1, m2, sshL.toString()}));
            throw new CommandValidationException(StringUtils.cat((String)NL, (String[])new String[]{msg, m1, m2}));
        }
    }

    public String expandPasswordAlias(String alias) {
        String ALIAS_PREFIX = "${ALIAS=";
        String ALIAS_SUFFIX = "}";
        if (alias == null) {
            return null;
        }
        int head = alias.indexOf("${ALIAS=");
        int tail = alias.lastIndexOf("}");
        if (head == -1 || tail == -1) {
            return alias;
        }
        String aliasName = alias.substring(head += "${ALIAS=".length(), tail);
        MasterPassword masterPasswordHelper = this.habitat.getByContract(MasterPassword.class);
        try {
            PasswordAdapter pa = masterPasswordHelper.getMasterPasswordAdapter();
            String p = pa.getPasswordForAlias(aliasName);
            return p;
        }
        catch (Exception e) {
            this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{aliasName, e.getMessage()}));
            return null;
        }
    }
}

