/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.StopServer;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

@Service(name="stop-instance")
@Scoped(value=PerLookup.class)
@I18n(value="stop.instance.command")
@Cluster(value={RuntimeType.DAS})
public class StopInstanceCommand
extends StopServer
implements AdminCommand,
PostConstruct {
    @Inject
    private Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    private ServerEnvironment env;
    @Inject
    private ModulesRegistry registry;
    @Param(optional=true, defaultValue="true")
    private Boolean force;
    @Param(optional=false, primary=true)
    private String instanceName;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private ActionReport report;
    private String errorMessage = null;
    private Server instance;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        this.errorMessage = this.env.isDas() ? this.callInstance() : Strings.get("stop.instance.notDas", this.env.getRuntimeType().toString());
        if (this.errorMessage == null) {
            this.errorMessage = this.pollForDeath();
        }
        if (this.errorMessage != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(this.errorMessage);
        } else {
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            this.report.setMessage(Strings.get("stop.instance.success", this.instanceName));
        }
    }

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    private String callInstance() {
        String cmdName = "stop-instance";
        if (!StringUtils.ok((String)this.instanceName)) {
            return Strings.get("stop.instance.noInstanceName", cmdName);
        }
        this.instance = this.helper.getServer(this.instanceName);
        if (this.instance == null) {
            return Strings.get("stop.instance.noSuchInstance", this.instanceName);
        }
        String host = this.instance.getHost();
        if (host == null) {
            return Strings.get("stop.instance.noHost", this.instanceName);
        }
        int port = this.helper.getAdminPort(this.instance);
        if (port < 0) {
            return Strings.get("stop.instance.noPort", this.instanceName);
        }
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand("_stop-instance", host, port, false, "admin", null, this.logger);
            rac.executeCommand(new ParameterMap());
        }
        catch (CommandException ex) {
            return Strings.get("stop.instance.racError", this.instanceName, ex.getLocalizedMessage());
        }
        return null;
    }

    private String pollForDeath() {
        int counter = 0;
        while (++counter < 240) {
            if (!this.instance.isRunning()) {
                return null;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return Strings.get("stop.instance.timeout", this.instanceName);
    }
}

