/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.cluster.SyncRequest;
import com.sun.enterprise.v3.admin.cluster.ServerSynchronizer;
import java.io.File;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.InstanceState;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_synchronize-files")
@Scoped(value=PerLookup.class)
@I18n(value="synchronize.command")
public class SynchronizeFiles
implements AdminCommand {
    @Param(name="file_list", primary=true)
    private File fileList;
    @Param(name="syncarchive", optional=true)
    private boolean syncArchive;
    @Param(name="syncallapps", optional=true)
    private boolean syncAllApps;
    @Inject(optional=true)
    private Applications applications;
    @Inject(optional=true)
    private Servers servers;
    @Inject
    InstanceState instanceState;
    @Inject
    private ServerSynchronizer sync;
    private Logger logger;
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(SynchronizeFiles.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.logger = context.getLogger();
        SyncRequest sr = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{SyncRequest.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(null);
            sr = (SyncRequest)unmarshaller.unmarshal(this.fileList);
            this.logger.finer("SynchronizeFiles: synchronize dir " + sr.dir);
        }
        catch (Exception ex) {
            this.logger.fine("SynchronizeFiles: Exception reading request");
            this.logger.fine(ex.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("sync.exception.reading", "SynchronizeFiles: Exception reading request"));
            report.setFailureCause((Throwable)ex);
            return;
        }
        try {
            Server server = null;
            if (this.servers != null) {
                server = this.servers.getServer(sr.instance);
            }
            if (server == null) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(strings.getLocalString("sync.unknown.instance", "Unknown server instance: {0}", new Object[]{sr.instance}));
                return;
            }
            this.instanceState.setState(sr.instance, InstanceState.StateType.RUNNING);
            this.sync.synchronize(server, sr, context.getOutboundPayload(), report, this.logger);
        }
        catch (Exception ex) {
            this.logger.fine("SynchronizeFiles: Exception processing request");
            this.logger.fine(ex.toString());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(strings.getLocalString("sync.exception.processing", "SynchronizeFiles: Exception processing request"));
            report.setFailureCause((Throwable)ex);
        }
    }
}

