/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import javax.servlet.http.HttpSession;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.jboss.weld.servlet.HttpPassThruSessionBeanStore;

public class ConversationBeanStore
extends HttpPassThruSessionBeanStore {
    private final NamingScheme namingScheme;

    protected ConversationBeanStore(HttpSession session, boolean sessionInvalidated, String cid) {
        if (session == null) {
            throw new IllegalArgumentException(ConversationMessage.NULL_HTTP_SESSION, new Object[0]);
        }
        this.namingScheme = new NamingScheme(ConversationContext.class.getName() + "[" + cid + "]", "#");
        if (sessionInvalidated) {
            this.invalidate();
        }
        this.attachToSession(session);
    }

    protected NamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    public static BeanStore of(HttpSession httpSession, boolean sessionInvalidated, String cid) {
        return new ConversationBeanStore(httpSession, sessionInvalidated, cid);
    }

    public static BeanStore of(HttpSession httpSession, String cid) {
        return new ConversationBeanStore(httpSession, false, cid);
    }
}

