/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.monitoring;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.TransactionAdminBean;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="transaction-service-mon", group="monitoring")
@ManagedObject
@Description(value="Transaction Service Statistics")
public class TransactionServiceStatsProvider {
    private static final int COLUMN_LENGTH = 25;
    private static final String LINE_BREAK = "%%%EOL%%%";
    private CountStatisticImpl activeCount = new CountStatisticImpl("ActiveCount", "count", "Provides the number of transactions that are currently active.");
    private CountStatisticImpl committedCount = new CountStatisticImpl("CommittedCount", "count", "Provides the number of transactions that have been committed.");
    private CountStatisticImpl rolledbackCount = new CountStatisticImpl("RolledbackCount", "count", "Provides the number of transactions that have been rolled back.");
    private StringStatisticImpl inflightTransactions = new StringStatisticImpl("ActiveIds", "List", "Provides the IDs of the transactions that are currently active a.k.a. in-flight transactions. Every such transaction can be rolled back after freezing the transaction service.");
    private StringStatisticImpl state = new StringStatisticImpl("State", "String", "Indicates if the transaction service has been frozen");
    private boolean isFrozen = false;
    private JavaEETransactionManager txMgr;
    private Logger _logger;

    public TransactionServiceStatsProvider(JavaEETransactionManager tm, Logger l) {
        this.txMgr = tm;
        this._logger = l;
    }

    @ManagedAttribute(id="activecount")
    @Description(value="Provides the number of transactions that are currently active.")
    public CountStatistic getActiveCount() {
        return this.activeCount.getStatistic();
    }

    @ManagedAttribute(id="committedcount")
    @Description(value="Provides the number of transactions that have been committed.")
    public CountStatistic getCommittedCount() {
        return this.committedCount.getStatistic();
    }

    @ManagedAttribute(id="rolledbackcount")
    @Description(value="Provides the number of transactions that have been rolled back.")
    public CountStatistic getRolledbackCount() {
        return this.rolledbackCount.getStatistic();
    }

    @ManagedAttribute(id="state")
    @Description(value="Indicates if the transaction service has been frozen.")
    public StringStatistic getState() {
        this.state.setCurrent(this.isFrozen ? "True" : "False");
        return this.state.getStatistic();
    }

    @ManagedAttribute(id="activeids")
    @Description(value="List of inflight transactions.")
    public StringStatistic getActiveIds() {
        StringBuffer strBuf = new StringBuffer(1024);
        if (this.txMgr == null) {
            this._logger.warning("transaction.monitor.tm_null");
            this.inflightTransactions.setCurrent("");
            return this.inflightTransactions.getStatistic();
        }
        ArrayList aList = this.txMgr.getActiveTransactions();
        if (!aList.isEmpty()) {
            TransactionAdminBean txnBean;
            int i;
            int componentNameLength = 25;
            int txIdLength = 40;
            for (i = 0; i < aList.size(); ++i) {
                String txnId;
                txnBean = (TransactionAdminBean)aList.get(i);
                String componentName = txnBean.getComponentName();
                if (componentName.length() > componentNameLength) {
                    componentNameLength = componentName.length() + 1;
                }
                if ((txnId = txnBean.getId()).length() <= txIdLength) continue;
                txIdLength = txnId.length() + 1;
            }
            if (aList.size() > 0) {
                strBuf.append(LINE_BREAK).append(LINE_BREAK);
                this.appendColumn(strBuf, "Transaction Id", txIdLength);
                this.appendColumn(strBuf, "Status", 25);
                this.appendColumn(strBuf, "ElapsedTime(ms)", 25);
                this.appendColumn(strBuf, "ComponentName", componentNameLength);
                strBuf.append("ResourceNames ").append(LINE_BREAK);
            }
            for (i = 0; i < aList.size(); ++i) {
                txnBean = (TransactionAdminBean)aList.get(i);
                String txnId = txnBean.getId();
                this._logger.fine("=== Processing txnId: " + txnId);
                this.appendColumn(strBuf, txnId, txIdLength);
                this.appendColumn(strBuf, txnBean.getStatus(), 25);
                this.appendColumn(strBuf, String.valueOf(txnBean.getElapsedTime()), 25);
                this.appendColumn(strBuf, txnBean.getComponentName(), componentNameLength);
                ArrayList resourceList = txnBean.getResourceNames();
                if (resourceList != null) {
                    for (int k = 0; k < resourceList.size(); ++k) {
                        if (k != 0) {
                            strBuf.append(",");
                        }
                        strBuf.append((String)resourceList.get(k));
                    }
                }
                strBuf.append(LINE_BREAK);
            }
        }
        this._logger.fine("Prepared inflightTransactions text: \n" + strBuf);
        this.inflightTransactions.setCurrent(strBuf == null ? "" : strBuf.toString());
        return this.inflightTransactions.getStatistic();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:activated")
    public void transactionActivatedEvent() {
        this._logger.fine("=== transaction-service active ++");
        this.activeCount.increment();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:deactivated")
    public void transactionDeactivatedEvent() {
        this._logger.fine("=== transaction-service active --");
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:committed")
    public void transactionCommittedEvent() {
        this._logger.fine("=== transaction-service committed ++");
        this.committedCount.increment();
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:rolledback")
    public void transactionRolledbackEvent() {
        this._logger.fine("=== transaction-service rolledback ++");
        this.rolledbackCount.increment();
        this.activeCount.decrement();
    }

    @ProbeListener(value="glassfish:transaction:transaction-service:freeze")
    public void freezeEvent(@ProbeParam(value="isFrozen") boolean b) {
        this.isFrozen = b;
    }

    private void appendColumn(StringBuffer buf, String text, int length) {
        buf.append(text);
        for (int i = text.length(); i < length; ++i) {
            buf.append(" ");
        }
    }
}

