/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.common.HTMLActionReporter;
import java.beans.PropertyChangeEvent;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ApplicationConfigListener
implements TransactionListener,
PostStartup,
PostConstruct {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationConfigListener.class);
    private Logger logger;
    @Inject
    Transactions transactions;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Deployment deployment;
    @Inject(name="default-instance-name")
    Server server;

    @Override
    public void transactionCommited(List<PropertyChangeEvent> changes) {
        for (PropertyChangeEvent event : changes) {
            if (!(event.getSource() instanceof Application) && !(event.getSource() instanceof ApplicationRef) || !event.getPropertyName().equals("enabled")) continue;
            String oldValue = (String)event.getOldValue();
            String newValue = (String)event.getNewValue();
            if (oldValue == null || newValue == null || oldValue.equals(newValue)) continue;
            this.handleAppEnableChange(event.getSource(), Boolean.valueOf(newValue));
        }
    }

    @Override
    public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
    }

    public void postConstruct() {
        this.transactions.addTransactionsListener(this);
        this.logger = Logger.getLogger(ApplicationConfigListener.class.getName());
    }

    private void handleAppEnableChange(Object parent, boolean enabled) {
        String appName = null;
        if (parent instanceof Application) {
            appName = ((Application)parent).getName();
        } else if (parent instanceof ApplicationRef) {
            appName = ((ApplicationRef)parent).getRef();
        }
        if (enabled) {
            if (this.isCurrentInstanceMatchingTarget(parent)) {
                this.enableApplication(appName);
            }
        } else if (this.isCurrentInstanceMatchingTarget(parent)) {
            this.disableApplication(appName);
        }
    }

    private boolean isCurrentInstanceMatchingTarget(Object parent) {
        if (parent instanceof ApplicationRef) {
            ConfigBeanProxy grandparent = ((ApplicationRef)parent).getParent();
            if (grandparent instanceof Server) {
                Server gpServer = (Server)grandparent;
                if (this.server.isDas() && !gpServer.isDas()) {
                    return false;
                }
            } else if (grandparent instanceof Cluster && this.server.isDas()) {
                return false;
            }
        }
        return true;
    }

    private void enableApplication(String appName) {
        Application app = this.applications.getApplication(appName);
        ApplicationRef appRef = this.domain.getApplicationRefInServer(this.server.getName(), appName);
        if (app == null || appRef == null) {
            return;
        }
        if (!this.deployment.isAppEnabled(app)) {
            return;
        }
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            return;
        }
        if (appInfo.isLoaded()) {
            return;
        }
        long operationStartTime = Calendar.getInstance().getTimeInMillis();
        try {
            HTMLActionReporter report = new HTMLActionReporter();
            this.deployment.enable(this.server.getName(), app, appRef, (ActionReport)report, this.logger);
            if (((ActionReport)report).getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.logger.log(Level.INFO, "loading.application.time", new Object[]{appName, Calendar.getInstance().getTimeInMillis() - operationStartTime});
            } else if (((ActionReport)report).getActionExitCode().equals((Object)ActionReport.ExitCode.WARNING)) {
                this.logger.warning(((ActionReport)report).getMessage());
            } else if (((ActionReport)report).getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                throw new Exception(((ActionReport)report).getMessage());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during enabling: ", e);
            RuntimeException re = new RuntimeException(e.getMessage());
            re.initCause(e);
            throw re;
        }
    }

    private void disableApplication(String appName) {
        Application app = this.applications.getApplication(appName);
        ApplicationRef appRef = this.domain.getApplicationRefInServer(this.server.getName(), appName);
        if (app == null || appRef == null) {
            return;
        }
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            return;
        }
        if (!appInfo.isLoaded()) {
            return;
        }
        try {
            HTMLActionReporter report = new HTMLActionReporter();
            this.deployment.disable(appName, this.server.getName(), app, appInfo, (ActionReport)report, this.logger, null, null);
            if (((ActionReport)report).getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                throw new Exception(((ActionReport)report).getMessage());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during disabling: ", e);
            RuntimeException re = new RuntimeException(e.getMessage());
            re.initCause(e);
            throw re;
        }
    }
}

